/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;

public class SSLAuthenticator
extends AuthenticatorBase {
    private static final String info = "org.apache.catalina.authenticator.SSLAuthenticator/1.0";

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        X509Certificate[] certs;
        Principal principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal();
        if (principal != null) {
            if (this.debug >= 1) {
                this.log("Already authenticated '" + principal.getName() + "'");
            }
            return true;
        }
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        if (this.debug >= 1) {
            this.log(" Looking up certificates");
        }
        if ((certs = (X509Certificate[])request.getRequest().getAttribute("javax.servlet.request.X509Certificate")) == null || certs.length < 1) {
            if (this.debug >= 1) {
                this.log("  No certificates included with this request");
            }
            hres.sendError(400, AuthenticatorBase.sm.getString("authenticator.certificates"));
            return false;
        }
        principal = this.context.getRealm().authenticate(certs);
        if (principal == null) {
            if (this.debug >= 1) {
                this.log("  Realm.authenticate() returned false");
            }
            hres.sendError(401, AuthenticatorBase.sm.getString("authenticator.unauthorized"));
            return false;
        }
        this.register(request, response, principal, "CLIENT-CERT", null, null);
        return true;
    }

    public String getInfo() {
        return info;
    }

    public void start() throws LifecycleException {
        super.start();
    }

    public void stop() throws LifecycleException {
        super.stop();
    }
}

