/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.multisession.EnterpriseDebugger;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.util.NbBundle;

public class Session {
    public static final String STATE_CONNECTED = "Connected";
    public static final String STATE_DISCONNECTED = "Disconnected";
    public static final String STATE_HIDDEN = "Hidden";
    public static final String STATE_NOT_RUNNING = "Not Running";
    public static final int ACTION_FINISH = 0;
    public static final int ACTION_DISCONNECT = 1;
    public static final int ACTION_HIDE = 2;
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PERSISTENT = "persistent";
    public static final String PROP_CONNECTION_STATE = "connectionState";
    public static final String PROP_CURRENT = "current";
    public static final String PROP_CONNECTED = "connected";
    public static final String PROP_ACTION_ON_FINISH = "actionOnFinish";
    private boolean connected = true;
    private boolean running = true;
    private String connectionState = "Connected";
    private int actionOnFinish = 2;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private AbstractDebugger debugger;
    private EnterpriseDebugger coreDebugger;
    private DebuggerListener debuggerListener;
    private DebuggerInfo debuggerInfo;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$Session;

    public Session(AbstractDebugger abstractDebugger, DebuggerInfo debuggerInfo) {
        this(null, null, abstractDebugger, debuggerInfo);
    }

    public Session(String string, String string2, AbstractDebugger abstractDebugger, DebuggerInfo debuggerInfo) {
        this.debugger = abstractDebugger;
        this.debuggerInfo = debuggerInfo;
        try {
            this.coreDebugger = (EnterpriseDebugger)TopManager.getDefault().getDebugger();
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
        this.debuggerListener = new DebuggerListener();
        abstractDebugger.addPropertyChangeListener(this.debuggerListener);
        this.coreDebugger.addPropertyChangeListener(this.debuggerListener);
    }

    public boolean isPersistent() {
        return this.coreDebugger.isSessionPersistent(this.debugger);
    }

    public void setPersistent(boolean bl) {
        this.coreDebugger.setSessionPersistent(this.debugger, bl);
        this.firePropertyChange(PROP_PERSISTENT, new Boolean(!bl), new Boolean(bl));
    }

    public AbstractDebugger getDebugger() {
        return this.debugger;
    }

    public AbstractThread getCurrentThread() {
        if (this.debugger instanceof ThreadsRoot) {
            return ((ThreadsRoot)((Object)this.debugger)).getCurrentThread();
        }
        return null;
    }

    public ThreadsProducer getThreadsProducer() {
        if (this.debugger instanceof ThreadsRoot) {
            return ((ThreadsRoot)((Object)this.debugger)).getThreadsRoot();
        }
        return null;
    }

    protected DebuggerInfo getDebuggerInfo() {
        DebuggerInfo debuggerInfo = this.debugger.getDebuggerInfo();
        return debuggerInfo == null ? this.debuggerInfo : debuggerInfo;
    }

    public String getSessionName() {
        DebuggerInfo debuggerInfo = this.getDebuggerInfo();
        return debuggerInfo instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)debuggerInfo).getProcessName() : "process";
    }

    public String getLocationName() {
        DebuggerInfo debuggerInfo = this.getDebuggerInfo();
        return debuggerInfo instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)debuggerInfo).getLocationName() : "localhost";
    }

    public int getActionOnFinish() {
        return this.actionOnFinish;
    }

    public void setActionOnFinish(int n) {
        if (this.actionOnFinish == n) {
            return;
        }
        int n2 = this.actionOnFinish;
        this.actionOnFinish = n;
        this.firePropertyChange(PROP_ACTION_ON_FINISH, new Integer(n2), new Integer(this.actionOnFinish));
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    protected void setConnectionState(String string) {
        if (this.connectionState == string) {
            return;
        }
        if (string != STATE_CONNECTED && string != STATE_DISCONNECTED && string != STATE_HIDDEN && string != STATE_NOT_RUNNING) {
            throw new InternalError("Unknown connectionState constant");
        }
        String string2 = this.connectionState;
        this.connectionState = string;
        this.firePropertyChange(PROP_CONNECTION_STATE, string2, string);
    }

    public boolean isCurrent() {
        return this.debugger == this.coreDebugger.getCurrentDebugger();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        if (bl == this.connected) {
            return;
        }
        if (bl) {
            // empty if block
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isHidden() {
        return this.connectionState == STATE_HIDDEN;
    }

    public void setHidden(boolean bl) {
        if (this.isHidden() == bl) {
            return;
        }
        if (bl) {
            this.setConnectionState(STATE_HIDDEN);
            this.firePropertyChange(PROP_HIDDEN, new Boolean(false), new Boolean(true));
        } else {
            if (this.isRunning()) {
                if (this.isConnected()) {
                    this.setConnectionState(STATE_CONNECTED);
                } else {
                    this.setConnectionState(STATE_DISCONNECTED);
                }
            } else {
                this.setConnectionState(STATE_NOT_RUNNING);
            }
            this.firePropertyChange(PROP_HIDDEN, new Boolean(true), new Boolean(false));
        }
    }

    public void start() {
        this.setHidden(false);
        this.debugger.addPropertyChangeListener(this.debuggerListener);
        this.coreDebugger.addPropertyChangeListener(this.debuggerListener);
        if (!this.running) {
            try {
                this.getDebugger().startDebugger(this.getDebuggerInfo());
            }
            catch (DebuggerException debuggerException) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(((InvocationTargetException)((Object)debuggerException)).getTargetException() == null ? debuggerException : ((InvocationTargetException)((Object)debuggerException)).getTargetException(), (Object)(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$Session == null ? (class$org$netbeans$modules$debugger$multisession$Session = Session.class$("org.netbeans.modules.debugger.multisession.Session")) : class$org$netbeans$modules$debugger$multisession$Session)).getString("EXC_Debugger") + ": " + debuggerException.getMessage())));
            }
            return;
        }
    }

    public void finish() {
        if (this.isPersistent()) {
            switch (this.getActionOnFinish()) {
                case 0: {
                    this.finishIn();
                    break;
                }
                case 1: {
                    this.setConnected(false);
                    break;
                }
                case 2: {
                    this.setHidden(true);
                }
            }
        } else if (this.isConnected()) {
            this.finishIn();
        }
    }

    public boolean isDead() {
        AbstractDebugger[] abstractDebuggerArray = this.coreDebugger.getDebuggers();
        int n = abstractDebuggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (abstractDebuggerArray[n2] == this.debugger) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    protected void debuggerStateChanged(int n) {
        switch (n) {
            case 1: {
                if (this.connected) {
                    this.connected = false;
                    this.firePropertyChange(PROP_CONNECTED, new Boolean(true), new Boolean(false));
                }
                this.running = false;
                this.setConnectionState(STATE_NOT_RUNNING);
                this.debugger.removePropertyChangeListener(this.debuggerListener);
                this.coreDebugger.removePropertyChangeListener(this.debuggerListener);
                break;
            }
            case 2: {
                if (this.getConnectionState() == STATE_HIDDEN) {
                    this.setConnectionState(STATE_DISCONNECTED);
                    return;
                }
                this.connected = true;
                this.setConnectionState(STATE_CONNECTED);
                this.firePropertyChange(PROP_CONNECTED, new Boolean(false), new Boolean(true));
            }
        }
    }

    void finishIn() {
        Session[] sessionArray = this.coreDebugger.getSessions();
        int n = sessionArray.length;
        if (sessionArray != null) {
            int n2 = 0;
            while (n2 < n) {
                if (sessionArray[n2] != this && sessionArray[n2].getDebugger() == this.getDebugger()) {
                    return;
                }
                ++n2;
            }
        }
        try {
            this.getDebugger().finishDebugger();
        }
        catch (DebuggerException debuggerException) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(((InvocationTargetException)((Object)debuggerException)).getTargetException() == null ? debuggerException : ((InvocationTargetException)((Object)debuggerException)).getTargetException(), (Object)(NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$Session == null ? (class$org$netbeans$modules$debugger$multisession$Session = Session.class$("org.netbeans.modules.debugger.multisession.Session")) : class$org$netbeans$modules$debugger$multisession$Session)).getString("EXC_Debugger") + ": " + debuggerException.getMessage())));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DebuggerListener
    implements PropertyChangeListener {
        private DebuggerListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("state") && propertyChangeEvent.getSource() == Session.this.debugger) {
                Session.this.debuggerStateChanged(Session.this.getDebugger().getState());
            } else if (propertyChangeEvent.getPropertyName().equals("currentSession")) {
                Session.this.pcs.firePropertyChange(Session.PROP_CURRENT, !Session.this.isCurrent(), Session.this.isCurrent());
            }
        }
    }
}

