/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.src.ClassElement;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;

public class BreakpointUpdater
extends FileChangeAdapter
implements PropertyChangeListener {
    protected static final LazyRepositoryListener repListener = new LazyRepositoryListener();
    protected CoreBreakpoint.Event breakpoint;
    protected String className;
    private Method classNameChangeMethod;
    private String classNameChangeMethodName;
    private WeakReference clsElemRef;
    protected transient FileObject fileObject;
    private PropertyChangeListener clsElementChangeListenerWeak;
    protected boolean onNestedClass;
    protected boolean listenOnClass;
    static /* synthetic */ Class class$java$lang$String;

    protected ClassElement getClsElement() {
        if (this.clsElemRef == null) {
            return null;
        }
        ClassElement classElement = (ClassElement)this.clsElemRef.get();
        if (classElement == null) {
            this.clsElementChangeListenerWeak = null;
        }
        return classElement;
    }

    protected ClassElement setClsElement(ClassElement classElement) {
        this.clsElemRef = classElement == null ? null : new WeakReference<ClassElement>(classElement);
        return classElement;
    }

    protected void init() {
        repListener.register(this);
    }

    public BreakpointUpdater(CoreBreakpoint.Event event, String string, String string2) {
        this.classNameChangeMethodName = string;
        this.breakpoint = event;
        this.init();
        this.setClassName(string2);
    }

    public void dispose() {
        repListener.unregister(this);
        ClassElement classElement = this.getClsElement();
        if (classElement != null) {
            this.refreshClsElementListener(classElement, null);
        }
        if (this.fileObject != null) {
            this.refreshFileObjectListener(this.fileObject, null);
        }
    }

    protected synchronized void refreshClsElementListener() {
        ClassElement classElement;
        ClassElement classElement2 = this.getClsElement();
        ClassElement classElement3 = classElement = this.className == null ? null : ClassElement.forName((String)this.className);
        if (classElement == classElement2) {
            return;
        }
        this.setClsElement(classElement);
        this.refreshClsElementListener(classElement2, classElement);
    }

    protected synchronized void refreshClsElementListener(ClassElement classElement, ClassElement classElement2) {
        if (classElement2 != classElement) {
            if (classElement != null) {
                classElement.removePropertyChangeListener(this.clsElementChangeListenerWeak);
                this.clsElementChangeListenerWeak = null;
            }
            if (classElement2 != null) {
                this.clsElementChangeListenerWeak = WeakListener.propertyChange((PropertyChangeListener)this, (Object)classElement2);
                classElement2.addPropertyChangeListener(this.clsElementChangeListenerWeak);
            }
        }
    }

    protected synchronized void refreshFileObjectListener() {
        FileObject fileObject = this.fileObject;
        this.fileObject = this.className == null ? null : TopManager.getDefault().getRepository().find(Utils.getPackageName(this.className), Utils.getTopClassName(Utils.getClassName(this.className)), "java");
        this.refreshFileObjectListener(fileObject, this.fileObject);
    }

    protected synchronized void refreshFileObjectListener(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2 != fileObject) {
            if (fileObject != null) {
                fileObject.removeFileChangeListener((FileChangeListener)this);
            }
            if (fileObject2 != null) {
                fileObject2.addFileChangeListener((FileChangeListener)this);
            }
        }
    }

    public void setClassName(String string) {
        this.className = string;
        boolean bl = this.listenOnClass;
        this.refreshFileObjectListener();
        this.onNestedClass = string != null && string.indexOf(36) != -1;
        boolean bl2 = this.listenOnClass = this.onNestedClass && this.fileObject != null;
        if (bl && !this.listenOnClass) {
            ClassElement classElement = this.getClsElement();
            this.setClsElement(null);
            this.refreshClsElementListener(classElement, null);
        } else if (this.listenOnClass) {
            this.refreshClsElementListener();
        }
    }

    protected void updateBreakpoint() {
        if (this.classNameChangeMethodName != null) {
            try {
                this.classNameChangeMethod = this.breakpoint.getClass().getMethod(this.classNameChangeMethodName, class$java$lang$String == null ? (class$java$lang$String = BreakpointUpdater.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (Exception exception) {
                TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
            }
            this.classNameChangeMethodName = null;
        }
        if (this.classNameChangeMethod != null) {
            try {
                this.classNameChangeMethod.invoke((Object)this.breakpoint, this.className);
            }
            catch (Exception exception) {
                this.classNameChangeMethod = null;
                TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
            }
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        if (this.onNestedClass) {
            this.refreshClsElementListener();
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.fileObject = null;
        this.refreshFileObjectListener(this.fileObject, null);
        if (this.listenOnClass) {
            this.refreshClsElementListener(this.getClsElement(), this.setClsElement(null));
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        if (!this.onNestedClass) {
            this.className = this.fileObject.getPackageName('.');
            this.updateBreakpoint();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("name")) {
            this.className = ((ClassElement)propertyChangeEvent.getSource()).getVMName();
            this.updateBreakpoint();
        }
    }

    protected void fileSystemsAdded(List list) {
        if (this.fileObject == null) {
            this.refreshFileObjectListener();
            boolean bl = this.listenOnClass = this.onNestedClass && this.fileObject != null;
            if (this.listenOnClass) {
                this.refreshClsElementListener();
            }
        }
    }

    protected void fileSystemsRemoved(List list) {
        if (this.fileObject != null) {
            boolean bl = false;
            try {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    if ((FileSystem)iterator.next() != this.fileObject.getFileSystem()) continue;
                    bl = true;
                    break;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                bl = true;
            }
            if (bl) {
                this.fileObject = null;
                this.refreshFileObjectListener(this.fileObject, null);
                if (this.listenOnClass) {
                    this.refreshClsElementListener(this.getClsElement(), this.setClsElement(null));
                    this.listenOnClass = false;
                }
            }
        }
    }

    protected void fileSystemsChanged(List list, List list2) {
        this.refreshFileObjectListener();
        boolean bl = this.listenOnClass = this.onNestedClass && this.fileObject != null;
        if (this.listenOnClass) {
            this.refreshClsElementListener();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final class LazyRepositoryListener
    implements Runnable,
    RepositoryListener {
        private static final int TASK_DELAY = 500;
        private RequestProcessor.Task updaterTask;
        private List addedFS;
        private List removedFS;
        private List registeredUpdaters = new ArrayList(10);

        protected LazyRepositoryListener() {
        }

        public void register(BreakpointUpdater breakpointUpdater) {
            List list = this.registeredUpdaters;
            synchronized (list) {
                boolean bl = this.registeredUpdaters.isEmpty();
                this.registeredUpdaters.add(breakpointUpdater);
                if (bl) {
                    this.updaterTask = new RequestProcessor("BreakpointUpdater").create((Runnable)this);
                    Repository.getDefault().addRepositoryListener((RepositoryListener)this);
                }
            }
        }

        public void unregister(BreakpointUpdater breakpointUpdater) {
            List list = this.registeredUpdaters;
            synchronized (list) {
                this.registeredUpdaters.remove(breakpointUpdater);
                if (this.registeredUpdaters.isEmpty()) {
                    Repository.getDefault().removeRepositoryListener((RepositoryListener)this);
                    this.updaterTask = null;
                }
            }
        }

        public void run() {
            block13: {
                BreakpointUpdater[] breakpointUpdaterArray;
                ArrayList arrayList;
                ArrayList arrayList2;
                LazyRepositoryListener lazyRepositoryListener = this;
                synchronized (lazyRepositoryListener) {
                    arrayList2 = this.addedFS == null ? null : new ArrayList(this.addedFS);
                    arrayList = this.removedFS == null ? null : new ArrayList(this.removedFS);
                    this.addedFS = null;
                    this.removedFS = null;
                }
                List list = this.registeredUpdaters;
                synchronized (list) {
                    breakpointUpdaterArray = this.registeredUpdaters.isEmpty() ? null : this.registeredUpdaters.toArray(new BreakpointUpdater[0]);
                }
                if (breakpointUpdaterArray == null) break block13;
                if (arrayList2 == null) {
                    int n = 0;
                    while (n < breakpointUpdaterArray.length) {
                        breakpointUpdaterArray[n].fileSystemsRemoved(arrayList);
                        ++n;
                    }
                } else if (arrayList == null) {
                    int n = 0;
                    while (n < breakpointUpdaterArray.length) {
                        breakpointUpdaterArray[n].fileSystemsAdded(arrayList);
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < breakpointUpdaterArray.length) {
                        breakpointUpdaterArray[n].fileSystemsChanged(arrayList2, arrayList);
                        ++n;
                    }
                }
            }
        }

        public final void fileSystemAdded(RepositoryEvent repositoryEvent) {
            LazyRepositoryListener lazyRepositoryListener = this;
            synchronized (lazyRepositoryListener) {
                if (this.addedFS == null) {
                    this.addedFS = new ArrayList(10);
                }
                this.addedFS.add(repositoryEvent.getFileSystem());
            }
            List list = this.registeredUpdaters;
            synchronized (list) {
                if (this.updaterTask != null) {
                    this.updaterTask.schedule(500);
                }
            }
        }

        public final void fileSystemRemoved(RepositoryEvent repositoryEvent) {
            LazyRepositoryListener lazyRepositoryListener = this;
            synchronized (lazyRepositoryListener) {
                if (this.removedFS == null) {
                    this.removedFS = new ArrayList(10);
                }
                this.removedFS.add(repositoryEvent.getFileSystem());
            }
            List list = this.registeredUpdaters;
            synchronized (list) {
                if (this.updaterTask != null) {
                    this.updaterTask.schedule(500);
                }
            }
        }

        public final void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
        }
    }
}

