/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.util.Hashtable;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.openide.src.ClassElement;
import org.openide.src.ConstructorElement;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;

public abstract class JavaClass {
    private ClassElement element = null;
    private Hashtable innerClasses = new Hashtable();

    public abstract String getName();

    public abstract JavaClass[] getInnerClasses();

    public abstract MethodElement[] getMethods();

    public abstract ConstructorElement[] getConstructors();

    public abstract InitializerElement[] getInitializers();

    public abstract FieldElement[] getFields();

    public abstract boolean isClass();

    public abstract int modifiers();

    public abstract String classLoaderTypeName();

    public abstract JavaVariable getClassLoader();

    public abstract JavaVariable getStaticVariable(FieldElement var1);

    public abstract boolean isPrepared();

    public abstract Identifier getSuperClass();

    public abstract Identifier[] getInterfaces();

    public String getClassName() {
        String string = this.getName();
        int n = string.lastIndexOf(46) + 1;
        int n2 = string.lastIndexOf(36) + 1;
        return string.substring(n2 > n ? n2 : n);
    }

    protected static final Identifier createClassIdentifier(String string) {
        if (string == "") {
            return Identifier.create((String)"");
        }
        int n = string.lastIndexOf(46) + 1;
        int n2 = string.lastIndexOf(36) + 1;
        return Identifier.create((String)string, (String)string.substring(n2 > n ? n2 : n));
    }

    public ClassElement toClassElement() {
        if (this.element != null) {
            return this.element;
        }
        try {
            this.element = new ClassElement();
            JavaClass[] javaClassArray = this.getInnerClasses();
            this.innerClasses = new Hashtable();
            ClassElement[] classElementArray = new ClassElement[javaClassArray.length];
            int n = 0;
            while (n < javaClassArray.length) {
                classElementArray[n] = javaClassArray[n].toClassElement();
                if (classElementArray[n] == null) {
                    classElementArray[n] = new ClassElement();
                }
                this.innerClasses.put(javaClassArray[n].getClassName(), javaClassArray[n]);
                ++n;
            }
            this.element.setName(JavaClass.createClassIdentifier(this.getName()));
            this.element.setClasses(classElementArray);
            this.element.setClassOrInterface(this.isClass());
            Identifier identifier = this.getSuperClass();
            if (identifier != null) {
                this.element.setSuperclass(identifier);
            }
            this.element.setInterfaces(this.getInterfaces());
            if (this.isPrepared()) {
                this.element.setConstructors(this.getConstructors());
                this.element.setMethods(this.getMethods());
                this.element.setInitializers(this.getInitializers());
                this.element.setFields(this.getFields());
            }
            this.element.setModifiers(this.modifiers());
        }
        catch (SourceException sourceException) {
            sourceException.printStackTrace();
        }
        return this.element;
    }

    public void updateClassElement(ClassElement classElement) {
        try {
            this.innerClasses = new Hashtable();
            JavaClass[] javaClassArray = this.getInnerClasses();
            ClassElement[] classElementArray = new ClassElement[javaClassArray.length];
            int n = 0;
            while (n < javaClassArray.length) {
                classElementArray[n] = javaClassArray[n].toClassElement();
                if (classElementArray[n] == null) {
                    classElementArray[n] = new ClassElement();
                }
                this.innerClasses.put(javaClassArray[n].getClassName(), javaClassArray[n]);
                ++n;
            }
            classElement.setClasses(classElementArray);
            if (this.isPrepared()) {
                classElement.setConstructors(this.getConstructors());
                classElement.setMethods(this.getMethods());
                classElement.setInitializers(this.getInitializers());
                classElement.setFields(this.getFields());
            }
            classElement.setModifiers(this.modifiers());
        }
        catch (SourceException sourceException) {
            sourceException.printStackTrace();
        }
    }

    public void updateInnerClasses(ClassElement classElement) {
        try {
            Hashtable<String, JavaClass> hashtable = new Hashtable<String, JavaClass>();
            ClassElement[] classElementArray = classElement.getClasses();
            JavaClass[] javaClassArray = this.getInnerClasses();
            int n = 0;
            while (n < javaClassArray.length) {
                ClassElement classElement2 = javaClassArray[n].toClassElement();
                JavaClass javaClass = (JavaClass)this.innerClasses.get(javaClassArray[n].getClassName());
                if (javaClass == null) {
                    this.innerClasses.put(javaClassArray[n].getClassName(), javaClassArray[n]);
                    classElement.addClass(classElement2);
                }
                hashtable.put(javaClassArray[n].getClassName(), javaClassArray[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < classElementArray.length) {
                if (hashtable.get(classElementArray[n2].getName().getName()) == null) {
                    classElement.removeClass(classElementArray[n2]);
                }
                ++n2;
            }
            this.innerClasses = hashtable;
        }
        catch (SourceException sourceException) {
            sourceException.printStackTrace();
        }
    }

    public JavaClass findInnerClass(ClassElement classElement) {
        return (JavaClass)this.innerClasses.get(classElement.getName().getName());
    }
}

