/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.DebuggerAnnotation;
import org.netbeans.modules.debugger.support.LineBreakpointEvent;
import org.netbeans.modules.debugger.support.java.BreakpointUpdater;
import org.netbeans.modules.debugger.support.java.JUtils;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaLineBreakpointPanel;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public abstract class JavaLineBreakpointEvent
extends LineBreakpointEvent
implements CoreBreakpoint.AnnotatableEvent,
CoreBreakpoint.SessionEvent {
    static final long serialVersionUID = 5611559342537392476L;
    public static final String PROP_SOURCE_NAME = "sourceName";
    public static final String PROP_LINE_NUMBER = "lineNumber";
    public static final String TYPE_NAME = "java-line";
    protected transient LineBreakpointUpdater updater;
    protected transient DebuggerAnnotation annotation;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie$Editor;
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public JavaLineBreakpointEvent() {
        this.init();
    }

    protected void init() {
        this.annotation = new DebuggerAnnotation.Breakpoint(this);
        this.updater = new LineBreakpointUpdater(this, this.getSourceName());
        JavaLineBreakpointEvent javaLineBreakpointEvent = this;
        synchronized (javaLineBreakpointEvent) {
            if (this.sourceName != null && this.sourceName.length() != 0 && this.lineNumber > 0) {
                this.line = Utils.getLine(this.sourceName, this.lineNumber);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public Node.Property[] getProperties() {
        return new Node.Property[]{Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = JavaLineBreakpointEvent.class$("java.lang.String")) : class$java$lang$String, PROP_SOURCE_NAME, JavaDebugger.getString("PROP_breakpoint_source_name"), JavaDebugger.getString("HINT_breakpoint_source_name"), "getSourceName", "setSourceName"), Utils.createProperty(this, Integer.TYPE, PROP_LINE_NUMBER, JavaDebugger.getString("PROP_breakpoint_line_number"), JavaDebugger.getString("HINT_breakpoint_line_number"), "getLineNumber", "setLineNumber")};
    }

    public void dispose() {
        if (this.updater != null) {
            this.updater.dispose();
        }
        this.annotation.detachLine();
    }

    public boolean supportsMIMEType(String string) {
        return true;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public String getTypeDisplayName() {
        return JavaDebugger.getString("CTL_Line_event_type_name");
    }

    public String getCategoryDisplayName() {
        return JavaDebugger.getString("CTL_Java_breakpoint_events_cathegory_name");
    }

    public boolean isDefault() {
        return JUtils.getDefaultType() == TYPE_NAME;
    }

    public String getDisplayName() {
        if (this.line != null) {
            return new MessageFormat(JavaDebugger.getString("CTL_Line_event_name_Line")).format(new Object[]{this.line.getDisplayName()});
        }
        return new MessageFormat(JavaDebugger.getString("CTL_Line_event_name")).format(new Object[]{this.getSourceName(), new Integer(this.getLineNumber())});
    }

    public Line[] getLines() {
        if (this.line == null) {
            return null;
        }
        return new Line[]{this.line};
    }

    public JComponent getCustomizer() {
        this.setSourceName(JUtils.getCurrentClassName());
        this.setLineNumber(Utils.getCurrentLineNumber());
        return new JavaLineBreakpointPanel(this);
    }

    public void synchronizeWith(CoreBreakpoint.Event event) {
    }

    public void setSourceName(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string == this.sourceName || string != null && this.sourceName != null && this.sourceName.equals(string)) {
            return;
        }
        String string2 = this.sourceName;
        this.sourceName = string;
        int n = this.getLineNumber();
        this.line = null;
        if (this.sourceName != null && this.sourceName.length() > 0 && n > 0) {
            this.line = Utils.getLine(this.sourceName, n);
            this.lineNumber = this.line != null ? -1 : n;
        }
        this.updater.setClassName(this.sourceName);
        this.firePropertyChange(PROP_SOURCE_NAME, string2, this.sourceName);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setsourceName(String string) {
        if (string == this.sourceName || string != null && this.sourceName != null && this.sourceName.equals(string)) {
            return;
        }
        String string2 = this.sourceName;
        this.sourceName = string;
        this.firePropertyChange(PROP_SOURCE_NAME, string2, this.sourceName);
    }

    public int getLineNumber() {
        if (this.line != null) {
            this.lineNumber = this.line.getLineNumber() + 1;
        }
        return this.lineNumber;
    }

    public void setLineNumber(int n) {
        if (n == this.lineNumber) {
            return;
        }
        int n2 = this.lineNumber;
        if (n > 0) {
            this.line = Utils.getLine(this.sourceName, n);
            this.lineNumber = n;
        } else {
            this.line = null;
            this.lineNumber = 0;
        }
        this.updater.setClassName(this.sourceName);
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(n2), new Integer(this.getLineNumber()));
    }

    public Line getLine() {
        return this.line;
    }

    public final void setLine(Line line) {
        this.setLine(line, true);
    }

    void setLine(Line line, boolean bl) {
        if (this.line == line) {
            return;
        }
        Line line2 = this.line;
        this.line = line;
        if (this.line != null) {
            this.lineNumber = this.line.getLineNumber() + 1;
            SourceCookie.Editor editor = (SourceCookie.Editor)this.line.getDataObject().getCookie(class$org$openide$cookies$SourceCookie$Editor == null ? (class$org$openide$cookies$SourceCookie$Editor = JavaLineBreakpointEvent.class$("org.openide.cookies.SourceCookie$Editor")) : class$org$openide$cookies$SourceCookie$Editor);
            EditorCookie editorCookie = (EditorCookie)this.line.getDataObject().getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = JavaLineBreakpointEvent.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            this.sourceName = null;
            if (editor != null && editorCookie != null) {
                try {
                    int n = NbDocument.findLineOffset((StyledDocument)editorCookie.openDocument(), (int)(this.lineNumber - 1));
                    this.sourceName = JUtils.getClassNameForElement(editor.findElement(n));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.sourceName == null || this.sourceName.length() < 1) {
                this.sourceName = this.line.getDataObject().getPrimaryFile().getPackageName('.');
            }
        }
        if (bl) {
            this.updater.setClassName(this.sourceName);
        }
        this.firePropertyChange(PROP_LINE_NUMBER, line2, this.line);
    }

    final synchronized Line updateLine() {
        Line line = this.line;
        this.line = this.sourceName != null && this.sourceName.length() != 0 && this.lineNumber > 0 ? Utils.getLine(this.sourceName, this.lineNumber) : null;
        if (this.line != line) {
            this.annotate();
            if (this.line != null) {
                this.lineNumber = this.line.getLineNumber() + 1;
            } else if (line != null) {
                this.lineNumber = line.getLineNumber() + 1;
            }
            this.firePropertyChange(PROP_LINE_NUMBER, line, this.line);
        }
        return this.line;
    }

    protected void sourceRenamed(String string) {
        if (string.equals(this.sourceName)) {
            return;
        }
        String string2 = this.sourceName;
        this.sourceName = string;
        this.firePropertyChange(PROP_SOURCE_NAME, string2, string);
    }

    protected void sourceModified() {
        Line line = this.line;
        if (line != null) {
            this.lineNumber = line.getLineNumber() + 1;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, null, null);
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string + this.hashCode() + "[src " + this.getSourceName() + " :ln " + this.getLineNumber() + " :line " + this.getLine() + "]";
    }

    protected String getAnnotationType() {
        return this.getBreakpoint().isEnabled() ? DebuggerAnnotation.Breakpoint.TYPE_NORMAL : DebuggerAnnotation.Breakpoint.TYPE_DISABLED;
    }

    public synchronized void annotate() {
        boolean bl = this.getBreakpoint().isHidden();
        if (bl || this.line == null) {
            if (this.annotation != null) {
                this.annotation.detachLine();
            }
        } else {
            if (this.annotation == null) {
                this.annotation = new DebuggerAnnotation.Breakpoint(this);
            }
            this.annotation.attachLine(this.line, this.getAnnotationType());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class LineBreakpointUpdater
    extends BreakpointUpdater {
        protected void init() {
            BreakpointUpdater.repListener.register(this);
            ((JavaLineBreakpointEvent)this.breakpoint).updateLine();
        }

        public LineBreakpointUpdater(JavaLineBreakpointEvent javaLineBreakpointEvent, String string) {
            super(javaLineBreakpointEvent, null, string);
        }

        private FileObject getFileObjectOfLine(Line line) {
            int n;
            int n2;
            if (line == null) {
                return null;
            }
            FileObject fileObject = line.getDataObject().getPrimaryFile();
            String string = fileObject.getPackageName('.');
            if (this.className.indexOf(36) == -1 ? !string.equals(this.className) : (n2 = this.className.length()) < (n = string.length()) + 2 || this.className.charAt(n) != '$' || !this.className.startsWith(string)) {
                return null;
            }
            return fileObject;
        }

        protected synchronized void refreshFileObjectListener() {
            FileObject fileObject = this.fileObject;
            Line line = ((JavaLineBreakpointEvent)this.breakpoint).getLine();
            this.fileObject = this.getFileObjectOfLine(line);
            this.refreshFileObjectListener(fileObject, this.fileObject);
        }

        protected void updateBreakpoint() {
            ((JavaLineBreakpointEvent)this.breakpoint).sourceRenamed(this.className);
        }

        public void fileChanged(FileEvent fileEvent) {
            super.fileChanged(fileEvent);
            ((JavaLineBreakpointEvent)this.breakpoint).sourceModified();
        }

        public void fileDeleted(FileEvent fileEvent) {
            ((JavaLineBreakpointEvent)this.breakpoint).updateLine();
            super.fileDeleted(fileEvent);
        }

        protected void fileSystemsAdded(List list) {
            Line line;
            if (this.fileObject == null && (line = ((JavaLineBreakpointEvent)this.breakpoint).updateLine()) != null) {
                this.fileObject = line.getDataObject().getPrimaryFile();
                this.refreshFileObjectListener(null, this.fileObject);
                this.listenOnClass = this.onNestedClass;
                if (this.listenOnClass) {
                    this.refreshClsElementListener();
                }
            }
        }

        protected void fileSystemsRemoved(List list) {
            if (this.fileObject != null) {
                boolean bl = false;
                try {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        if ((FileSystem)iterator.next() != this.fileObject.getFileSystem()) continue;
                        bl = true;
                        break;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    bl = true;
                }
                if (bl) {
                    ((JavaLineBreakpointEvent)this.breakpoint).updateLine();
                    this.fileObject = null;
                    this.refreshFileObjectListener(this.fileObject, null);
                    if (this.listenOnClass) {
                        this.refreshClsElementListener(this.getClsElement(), this.setClsElement(null));
                        this.listenOnClass = false;
                    }
                }
            }
        }

        protected void fileSystemsChanged(List list, List list2) {
            Line line = ((JavaLineBreakpointEvent)this.breakpoint).getLine();
            Line line2 = ((JavaLineBreakpointEvent)this.breakpoint).updateLine();
            if (line2 == line) {
                return;
            }
            FileObject fileObject = this.fileObject;
            this.fileObject = this.getFileObjectOfLine(line2);
            if (this.fileObject == fileObject) {
                return;
            }
            this.refreshFileObjectListener(null, this.fileObject);
            boolean bl = this.listenOnClass = this.fileObject != null && this.onNestedClass;
            if (this.listenOnClass) {
                this.refreshClsElementListener();
            }
        }
    }
}

