/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.CallStackProducer;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.actions.GoToSourceCookie;
import org.netbeans.modules.debugger.support.actions.SwitchOnCookie;
import org.netbeans.modules.debugger.support.nodes.DebuggerNode;
import org.netbeans.modules.debugger.support.nodes.LeafRefresher;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class LocationNode
extends AbstractNode
implements GoToSourceCookie,
SwitchOnCookie,
PropertyChangeListener {
    static final long serialVersionUID = -4901112834613957792L;
    public static final String PROPERTY_CLASS_NAME = "className";
    public static final String PROPERTY_METHOD_NAME = "methodName";
    public static final String PROPERTY_LINE_NUMBER = "lineNumber";
    protected static final String ICON_BASE = "org/netbeans/modules/debugger/resources/callStackView/NonCurrentFrame";
    private static final String ICON_BASE_CURRENT = "org/netbeans/modules/debugger/resources/callStackView/CurrentFrame";
    private static ResourceBundle bundle;
    private SystemAction[] staticActions;
    protected Location location;
    protected CallStackProducer producer;
    protected int index;
    protected boolean showSubNodes;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$nodes$LocationNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$nodes$LocationNode == null ? (class$org$netbeans$modules$debugger$support$nodes$LocationNode = LocationNode.class$("org.netbeans.modules.debugger.support.nodes.LocationNode")) : class$org$netbeans$modules$debugger$support$nodes$LocationNode));
        }
        return bundle.getString(string);
    }

    public LocationNode(Location location, CallStackProducer callStackProducer, int n, boolean bl) {
        super((Children)(location instanceof VariablesProducer && bl ? new LocationChildren(location) : Children.LEAF));
        this.producer = callStackProducer;
        this.index = n;
        this.showSubNodes = bl;
        this.location = location;
        this.updateName();
        this.updateIcon();
        this.createProperties();
        this.getCookieSet().add((Node.Cookie)this);
        callStackProducer.addPropertyChangeListener(this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerLocationNode");
    }

    protected void createProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = LocationNode.class$("java.lang.String")) : class$java$lang$String, PROPERTY_CLASS_NAME, LocationNode.getLocalizedString("PROP_call_stack_class_name"), LocationNode.getLocalizedString("HINT_call_stack_class_name"), "getLocationClassName", null));
        set.put(Utils.createProperty(this, class$java$lang$String == null ? (class$java$lang$String = LocationNode.class$("java.lang.String")) : class$java$lang$String, PROPERTY_LINE_NUMBER, LocationNode.getLocalizedString("PROP_call_stack_line_number"), LocationNode.getLocalizedString("HINT_call_stack_line_number"), "getLocationLineNumber", null));
        this.setSheet(sheet);
    }

    public SystemAction[] getActions() {
        if (this.staticActions == null) {
            this.staticActions = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction = LocationNode.class$("org.netbeans.modules.debugger.support.actions.SwitchToLocationAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = LocationNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = LocationNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
        }
        return this.staticActions;
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction == null ? (class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction = LocationNode.class$("org.netbeans.modules.debugger.support.actions.SwitchToLocationAction")) : class$org$netbeans$modules$debugger$support$actions$SwitchToLocationAction));
    }

    public void goToSource() {
        Line line = this.location.getLine();
        if (line != null) {
            line.show(2);
        }
    }

    public boolean canGoToSource() {
        Line line = this.location.getLine();
        return line != null;
    }

    public boolean canSetCurrent() {
        return this.producer.getCurrentCallStackFrameIndex() != this.index;
    }

    public void setCurrent() {
        this.producer.setCurrentCallStackFrameIndex(this.index);
        this.goToSource();
    }

    public String getLocationClassName() {
        Line line = this.location.getLine();
        return line != null ? line.getDataObject().getName() : "";
    }

    public String getLocationLineNumber() {
        Line line = this.location.getLine();
        return line != null ? "" + line.getLineNumber() : "";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() != null && propertyChangeEvent.getPropertyName().equals("currentCallstackFrameIndex")) {
            this.updateIcon();
        }
    }

    protected void updateLocation(Location location) {
        this.location = location;
        this.updateName();
        this.changeChildren();
    }

    protected void updateName() {
        String string = this.location.getLocationName();
        this.setDisplayName(string);
        this.setName(string);
    }

    protected void changeChildren() {
        if (!(this.location instanceof VariablesProducer)) {
            return;
        }
        LocationChildren locationChildren = (LocationChildren)this.getChildren();
        locationChildren.refreshLocals();
    }

    private void updateIcon() {
        if (this.producer.getCurrentCallStackFrameIndex() == this.index) {
            this.setIconBase(ICON_BASE_CURRENT);
        } else {
            this.setIconBase(ICON_BASE);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class LocationChildren
    extends Children.Keys
    implements LeafRefresher {
        private Location location;
        private boolean initialized = false;

        LocationChildren(Location location) {
            this.location = location;
        }

        protected void addNotify() {
            this.initialized = true;
            this.refreshLocals();
        }

        protected void removeNotify() {
            this.initialized = false;
            this.setKeys(Collections.EMPTY_SET);
        }

        protected void refreshLocals() {
            if (!this.initialized) {
                return;
            }
            VariablesProducer variablesProducer = (VariablesProducer)((Object)((LocationNode)this.getNode()).location);
            Object[] objectArray = variablesProducer.getVariablesFilter().getVariables(variablesProducer);
            Arrays.sort(objectArray, Utils.localsComparator);
            this.setKeys(objectArray);
        }

        protected Node[] createNodes(Object object) {
            Node node = DebuggerNode.createNode(object, new Object[]{object, new Integer(1), Boolean.TRUE});
            if (node == null) {
                return new Node[0];
            }
            return new Node[]{node};
        }

        public void refreshMyKey(Object object) {
            this.refreshKey(object);
        }
    }
}

