/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.compiler;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.compiler.CompilerDisplayer;
import org.netbeans.core.compiler.CompilerTaskImpl;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.compiler.CompilationEngine;
import org.openide.compiler.CompilerGroup;
import org.openide.compiler.CompilerGroupException;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerListener;
import org.openide.compiler.CompilerTask;
import org.openide.compiler.DependencyException;

public class CompilationEngineImpl
extends CompilationEngine {
    private LinkedList queue = new LinkedList();
    private CompilerThread t;
    CompilerDisplayer displayer = new CompilerDisplayer();
    static /* synthetic */ Class class$org$netbeans$core$compiler$CompilationEngineImpl$CompilerThread$GroupCompiler;

    public CompilationEngineImpl() {
        this.t = new CompilerThread(this.queue, this.displayer);
        this.t.start();
    }

    protected CompilerTask start(CompilerJob compilerJob) {
        NbTopManager nbTopManager;
        CompilerTaskImpl compilerTaskImpl = null;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            Thread thread;
            nbTopManager = new Object[2];
            nbTopManager[0] = compilerJob;
            compilerTaskImpl = new CompilerTaskImpl(compilerJob, this, (Object[])nbTopManager);
            nbTopManager[1] = compilerTaskImpl;
            if (!this.t.isAlive()) {
                this.t = new CompilerThread(this.queue, this.displayer);
                this.t.start();
            }
            if ((thread = Thread.currentThread()).getClass() == (class$org$netbeans$core$compiler$CompilationEngineImpl$CompilerThread$GroupCompiler == null ? (class$org$netbeans$core$compiler$CompilationEngineImpl$CompilerThread$GroupCompiler = CompilationEngineImpl.class$("org.netbeans.core.compiler.CompilationEngineImpl$CompilerThread$GroupCompiler")) : class$org$netbeans$core$compiler$CompilationEngineImpl$CompilerThread$GroupCompiler)) {
                this.t.runNested((Object[])nbTopManager);
            } else {
                this.queue.addLast(nbTopManager);
                this.queue.notify();
            }
        }
        if (TopManager.getDefault() instanceof NbTopManager) {
            nbTopManager = (NbTopManager)TopManager.getDefault();
            if (NbTopManager.compileSync) {
                compilerTaskImpl.waitFinished();
            }
        }
        return compilerTaskImpl;
    }

    public void stop() {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.t.stopIt();
            CompilerThread.GroupCompiler.interruptAll();
            Iterator iterator = this.queue.iterator();
            while (iterator.hasNext()) {
                ((CompilerTaskImpl)((Object)((Object[])iterator.next())[1])).done();
            }
            this.queue.clear();
            this.queue.notify();
            this.t = new CompilerThread(this.queue, this.displayer);
            this.t.start();
        }
    }

    public boolean isCompiling() {
        return CompilerThread.GroupCompiler.all.size() > 0;
    }

    void stopTask(CompilerTaskImpl compilerTaskImpl) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.queue.remove(compilerTaskImpl.ref)) {
                return;
            }
            this.stop();
        }
    }

    static List createLevels(CompilerJob compilerJob) throws DependencyException {
        return CompilationEngine.createComputationLevels((CompilerJob)compilerJob);
    }

    static Collection createGroups(Collection collection) throws CompilerGroupException {
        return CompilationEngine.createCompilerGroups((Collection)collection);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class CompilerThread
    extends Thread {
        public LinkedList queue;
        public CompilerDisplayer displayer;
        private boolean stop;
        public CompilerJob currentJob;
        public CompilerTaskImpl currentTask;

        public CompilerThread(LinkedList linkedList, CompilerDisplayer compilerDisplayer) {
            this.setName("Compilation");
            this.setPriority(2);
            this.setDaemon(true);
            this.queue = linkedList;
            this.displayer = compilerDisplayer;
        }

        public void stopIt() {
            this.stop = true;
        }

        private void nextJobAndTask() throws InterruptedException {
            LinkedList linkedList = this.queue;
            synchronized (linkedList) {
                this.currentJob = null;
                while (this.queue.size() == 0) {
                    this.queue.wait();
                }
                Object[] objectArray = (Object[])this.queue.removeFirst();
                this.currentJob = (CompilerJob)objectArray[0];
                this.currentTask = (CompilerTaskImpl)((Object)objectArray[1]);
            }
        }

        public void run() {
            while (!this.stop) {
                Object var5_4;
                boolean bl = true;
                try {
                    try {
                        this.nextJobAndTask();
                        this.displayer.compilationStarted(this.currentTask);
                        bl = this.processJob();
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify(4096, (Throwable)exception);
                        this.currentTask.success = false;
                        var5_4 = null;
                        this.displayer.compilationFinished(this.currentTask, bl & this.currentTask.success);
                        this.currentJob = null;
                        this.currentTask = null;
                        continue;
                    }
                    catch (ThreadDeath threadDeath) {
                        this.stop = true;
                        var5_4 = null;
                        this.displayer.compilationFinished(this.currentTask, bl & this.currentTask.success);
                        this.currentJob = null;
                        this.currentTask = null;
                        continue;
                    }
                    var5_4 = null;
                    this.displayer.compilationFinished(this.currentTask, bl & this.currentTask.success);
                    this.currentJob = null;
                    this.currentTask = null;
                }
                catch (Throwable throwable) {
                    var5_4 = null;
                    this.displayer.compilationFinished(this.currentTask, bl & this.currentTask.success);
                    this.currentJob = null;
                    this.currentTask = null;
                    throw throwable;
                }
            }
        }

        void runNested(Object[] objectArray) {
            CompilerJob compilerJob = this.currentJob;
            CompilerTaskImpl compilerTaskImpl = this.currentTask;
            try {
                this.currentJob = (CompilerJob)objectArray[0];
                this.currentTask = (CompilerTaskImpl)((Object)objectArray[1]);
                this.processJob();
                Object var5_4 = null;
                this.currentJob = compilerJob;
                this.currentTask = compilerTaskImpl;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.currentJob = compilerJob;
                this.currentTask = compilerTaskImpl;
                throw throwable;
            }
        }

        boolean processJob() {
            boolean bl = true;
            try {
                try {
                    ListIterator listIterator = CompilationEngineImpl.createLevels(this.currentJob).listIterator();
                    CompilerGroup[] compilerGroupArray = new CompilerGroup[]{};
                    boolean bl2 = true;
                    while (listIterator.hasNext() && bl2) {
                        compilerGroupArray = CompilationEngineImpl.createGroups((Collection)listIterator.next()).toArray(compilerGroupArray);
                        GroupCompiler groupCompiler = null;
                        bl &= compilerGroupArray.length == 0;
                        int n = 0;
                        while (n < compilerGroupArray.length) {
                            if (compilerGroupArray[n] == null) break;
                            compilerGroupArray[n].addCompilerListener((CompilerListener)this.displayer);
                            groupCompiler = new GroupCompiler(compilerGroupArray[n], groupCompiler);
                            ++n;
                        }
                        if (groupCompiler == null) continue;
                        bl2 &= groupCompiler.stay(this.displayer);
                    }
                    this.currentTask.success = bl2;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(4096, (Throwable)exception);
                    this.currentTask.success = false;
                    Object var8_9 = null;
                    if (this.currentTask != null) {
                        this.currentTask.done();
                    }
                }
                Object var8_8 = null;
                if (this.currentTask != null) {
                    this.currentTask.done();
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (this.currentTask != null) {
                    this.currentTask.done();
                }
                throw throwable;
            }
            return bl;
        }

        protected static class GroupCompiler
        extends Thread {
            static Hashtable all = new Hashtable(11);
            public CompilerGroup grp;
            public GroupCompiler parent;
            public boolean status;

            public GroupCompiler(CompilerGroup compilerGroup, GroupCompiler groupCompiler) {
                this.grp = compilerGroup;
                this.parent = groupCompiler;
                this.status = true;
                this.start();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean stay(CompilerListener compilerListener) throws InterruptedException {
                boolean bl;
                try {
                    all.put(this, this);
                    this.join();
                    this.grp.removeCompilerListener(compilerListener);
                    if (this.parent != null) {
                        boolean bl2 = this.parent.stay(compilerListener) && this.status;
                        Object var4_4 = null;
                        all.remove(this);
                        return bl2;
                    }
                    bl = this.status;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    all.remove(this);
                    throw throwable;
                }
                Object var4_5 = null;
                all.remove(this);
                return bl;
            }

            public void run() {
                try {
                    this.status = this.grp.start();
                }
                catch (ThreadDeath threadDeath) {
                    ErrorManager.getDefault().notify(4096, (Throwable)threadDeath);
                    this.status = false;
                }
                catch (RuntimeException runtimeException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)runtimeException);
                    this.status = false;
                }
            }

            static void interruptAll() {
                Enumeration enumeration = all.keys();
                while (enumeration.hasMoreElements()) {
                    Thread thread = (Thread)enumeration.nextElement();
                    thread.interrupt();
                }
            }
        }
    }
}

