/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.PrintContainer;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.Utilities;
import org.openide.TopManager;
import org.openide.text.Annotation;
import org.openide.text.AttributedCharacters;
import org.openide.text.NbDocument;

public class NbEditorDocument
extends GuardedDocument
implements NbDocument.PositionBiasable,
NbDocument.WriteLockable,
NbDocument.Printable,
NbDocument.CustomEditor,
NbDocument.Annotatable {
    public static final String FORMATTER = "formatter";
    public static final String MIME_TYPE_PROP = "mimeType";
    public static final String INDENT_ENGINE = "indentEngine";
    private Formatter formatter;
    private HashMap annoMap;

    public NbEditorDocument(Class clazz) {
        super(clazz);
        this.addStyleToLayerMapping("NbBreakpointStyle", "NbBreakpointStyleLayer:10");
        this.addStyleToLayerMapping("NbErrorStyle", "NbErrorStyleLayer:20");
        this.addStyleToLayerMapping("NbCurrentStyle", "NbCurrentStyleLayer:30");
        this.setNormalStyleName("NbNormalStyle");
        this.annoMap = new HashMap(20);
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        super.settingsChange(settingsChangeEvent);
        Object object = this.getProperty(MIME_TYPE_PROP);
        if (!(object instanceof String)) {
            BaseKit baseKit = BaseKit.getKit(this.getKitClass());
            this.putProperty(MIME_TYPE_PROP, baseKit.getContentType());
        }
        this.putProperty(INDENT_ENGINE, new BaseDocument.PropertyEvaluator(){
            private Object cached;

            public Object getValue() {
                if (this.cached == null) {
                    this.cached = Settings.getValue(NbEditorDocument.this.getKitClass(), NbEditorDocument.INDENT_ENGINE);
                }
                return this.cached;
            }
        });
        this.formatter = null;
    }

    public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        if (attributeSet != null) {
            Object object = attributeSet.getAttribute(NbDocument.GUARDED);
            if (object != null && object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    super.setCharacterAttributes(n, n2, GuardedDocument.guardedSet, bl);
                } else {
                    super.setCharacterAttributes(n, n2, GuardedDocument.unguardedSet, bl);
                }
            } else {
                super.setCharacterAttributes(n, n2, attributeSet, bl);
            }
        }
    }

    public AttributedCharacterIterator[] createPrintIterators() {
        NbPrintContainer nbPrintContainer = new NbPrintContainer();
        this.print(nbPrintContainer);
        return nbPrintContainer.getIterators();
    }

    public Component createEditor(JEditorPane jEditorPane) {
        return Utilities.getEditorUI(jEditorPane).getExtComponent();
    }

    public Formatter getFormatter() {
        Formatter formatter = this.formatter;
        if (formatter == null) {
            formatter = this.formatter = (Formatter)Settings.getValue(this.getKitClass(), FORMATTER);
        }
        return formatter != null ? formatter : super.getFormatter();
    }

    public void addAnnotation(Position position, int n, Annotation annotation) {
        if (annotation.getAnnotationType() != null) {
            AnnotationDescDelegate annotationDescDelegate = new AnnotationDescDelegate(this, position, n, annotation);
            this.annoMap.put(annotation, annotationDescDelegate);
            this.getAnnotations().addAnnotation(annotationDescDelegate);
        }
    }

    public void removeAnnotation(Annotation annotation) {
        if (annotation.getAnnotationType() != null) {
            AnnotationDescDelegate annotationDescDelegate = (AnnotationDescDelegate)this.annoMap.get(annotation);
            try {
                annotationDescDelegate.detachListeners();
            }
            catch (NullPointerException nullPointerException) {
                TopManager.getDefault().getErrorManager().annotate((Throwable)nullPointerException, 1, "Editor module received request to remove annotation which does not exist in the document. Cause of this error is either in OpenIDE module or in module which originated the annotation. Annotation class = " + annotation, null, null, null);
                TopManager.getDefault().getErrorManager().notify(1, (Throwable)nullPointerException);
                return;
            }
            this.getAnnotations().removeAnnotation(annotationDescDelegate);
            this.annoMap.remove(annotation);
        }
    }

    class NbPrintContainer
    extends AttributedCharacters
    implements PrintContainer {
        ArrayList acl = new ArrayList();
        AttributedCharacters a = new AttributedCharacters();

        NbPrintContainer() {
        }

        public void add(char[] cArray, Font font, Color color, Color color2) {
            this.a.append(cArray, font, color);
        }

        public void eol() {
            this.acl.add(this.a);
            this.a = new AttributedCharacters();
        }

        public boolean initEmptyLines() {
            return true;
        }

        public AttributedCharacterIterator[] getIterators() {
            int n = this.acl.size();
            AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[n];
            int n2 = 0;
            while (n2 < n) {
                AttributedCharacters attributedCharacters = (AttributedCharacters)this.acl.get(n2);
                attributedCharacterIteratorArray[n2] = attributedCharacters.iterator();
                ++n2;
            }
            return attributedCharacterIteratorArray;
        }
    }

    static class AnnotationDescDelegate
    extends AnnotationDesc {
        private Annotation delegate;
        private PropertyChangeListener l;
        private Position pos;
        private BaseDocument doc;

        AnnotationDescDelegate(BaseDocument baseDocument, Position position, int n, Annotation annotation) {
            super(position.getOffset(), n);
            this.pos = position;
            this.delegate = annotation;
            this.doc = baseDocument;
            this.updateAnnotationType();
            this.l = new PropertyChangeListener(this){
                private final /* synthetic */ AnnotationDescDelegate this$0;
                {
                    this.this$0 = annotationDescDelegate;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == "shortDescription") {
                        AnnotationDescDelegate.access$001(this.this$0, "shortDescription", null, null);
                    }
                    if (propertyChangeEvent.getPropertyName() == "moveToFront") {
                        AnnotationDescDelegate.access$101(this.this$0, "moveToFront", null, null);
                    }
                    if (propertyChangeEvent.getPropertyName() == "annotationType") {
                        this.this$0.updateAnnotationType();
                        AnnotationDescDelegate.access$201(this.this$0, "annotationType", null, null);
                    }
                }
            };
            this.delegate.addPropertyChangeListener(this.l);
        }

        public String getAnnotationType() {
            return this.delegate.getAnnotationType();
        }

        public String getShortDescription() {
            return this.delegate.getShortDescription();
        }

        void detachListeners() {
            this.delegate.removePropertyChangeListener(this.l);
        }

        public int getOffset() {
            return this.pos.getOffset();
        }

        public int getLine() {
            try {
                return Utilities.getLineOffset(this.doc, this.pos.getOffset());
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
        }

        static /* synthetic */ void access$001(AnnotationDescDelegate annotationDescDelegate, String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }

        static /* synthetic */ void access$101(AnnotationDescDelegate annotationDescDelegate, String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }

        static /* synthetic */ void access$201(AnnotationDescDelegate annotationDescDelegate, String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }
    }
}

