/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openfile.PackagePanel;
import org.netbeans.modules.openfile.Server;
import org.netbeans.modules.openfile.SettingsBeanInfo;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.FileSystemAction;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OpenFile {
    static final String JAVA_EXT = ".JAVA";
    static final String TXT_EXT = ".TXT";
    private static final String ZIP_EXT = ".ZIP";
    private static final String JAR_EXT = ".JAR";
    private static final String PACKAGE = "package";
    private static final ErrorManager em = TopManager.getDefault().getErrorManager().getInstance("org.netbeans.modules.openfile");
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$cookies$ViewCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$netbeans$modules$openfile$OpenFile;

    public static void open(String string) {
        em.log("OpenFile.open: " + string);
        final File file = new File(string);
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                OpenFile.open(file, false, null, -1, -1);
            }
        }, (int)10000);
    }

    static void open(File file, boolean bl, InetAddress inetAddress, int n, int n2) {
        block26: {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                em.log(iOException.getMessage());
            }
            em.log("    file: " + file);
            em.log("    file.exists: " + file.exists());
            em.log("    file.isFile: " + file.isFile());
            if (!file.exists() || !file.isFile()) {
                final String string = file.toString();
                new Thread(new Runnable(){

                    public void run() {
                        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_fileNotFound", string)));
                    }
                }).start();
                return;
            }
            FileObject fileObject = OpenFile.find(file);
            if (fileObject == null) {
                return;
            }
            try {
                boolean bl2;
                Node node;
                block28: {
                    DataFolder dataFolder;
                    Node node2;
                    Enumeration enumeration;
                    Node node3;
                    Object object;
                    DataObject dataObject;
                    block27: {
                        dataObject = DataObject.find((FileObject)fileObject);
                        EditorCookie editorCookie = n2 != -1 ? (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OpenFile.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie) : null;
                        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = OpenFile.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                        ViewCookie viewCookie = (ViewCookie)dataObject.getCookie(class$org$openide$cookies$ViewCookie == null ? (class$org$openide$cookies$ViewCookie = OpenFile.class$("org.openide.cookies.ViewCookie")) : class$org$openide$cookies$ViewCookie);
                        if (openCookie != null || viewCookie != null || editorCookie != null) {
                            TopManager.getDefault().setStatusText(SettingsBeanInfo.getString(bl ? "MSG_openingAndWaiting" : "MSG_opening", file.toString()));
                            if (editorCookie != null) {
                                editorCookie.open();
                                StyledDocument styledDocument = editorCookie.openDocument();
                                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                                if (jEditorPaneArray.length > 0) {
                                    jEditorPaneArray[0].setCaretPosition(NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n2));
                                } else {
                                    TopManager.getDefault().setStatusText(SettingsBeanInfo.getString("MSG_couldNotOpenAt"));
                                }
                            } else if (openCookie != null) {
                                openCookie.open();
                            } else {
                                viewCookie.view();
                            }
                            TopManager.getDefault().setStatusText("");
                            if (bl) {
                                Server.waitFor(dataObject, inetAddress, n);
                            }
                            break block26;
                        }
                        try {
                            if (fileObject.getFileSystem() instanceof JarFileSystem) {
                                return;
                            }
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block27;
                            fileStateInvalidException.printStackTrace();
                        }
                    }
                    node = dataObject.getNodeDelegate();
                    if (fileObject.isRoot()) {
                        object = fileObject.getFileSystem();
                        node3 = TopManager.getDefault().getPlaces().nodes().repository();
                        Children children = node3.getChildren();
                        enumeration = children.nodes();
                        while (enumeration.hasMoreElements()) {
                            node2 = (Node)enumeration.nextElement();
                            dataFolder = (DataFolder)node2.getCookie(class$org$openide$loaders$DataFolder == null ? OpenFile.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
                            if (dataFolder == null || !dataFolder.getPrimaryFile().getFileSystem().equals(object)) continue;
                            node = node2;
                            break;
                        }
                    }
                    object = TopManager.getDefault().getLoaderPool().allLoaders();
                    node3 = null;
                    while (object.hasMoreElements()) {
                        node3 = (DataLoader)object.nextElement();
                    }
                    bl2 = false;
                    if (node3 != null && dataObject.getClass().getName().equals(node3.getRepresentationClass().getName()) && (enumeration = node.getDefaultAction()) != null && !(enumeration instanceof FileSystemAction)) {
                        enumeration.actionPerformed(new ActionEvent(node, 0, null));
                        fileObject.refresh();
                        try {
                            node2 = DataObject.find((FileObject)fileObject);
                            dataFolder = (OpenCookie)node2.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = OpenFile.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                            if (dataFolder != null) {
                                dataFolder.open();
                                bl2 = true;
                            }
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block28;
                            dataObjectNotFoundException.printStackTrace();
                        }
                    }
                }
                if (!bl2) {
                    TopManager.getDefault().getNodeOperation().explore(node);
                }
                if (bl) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_cannotOpenWillClose", file)));
                }
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
            }
        }
    }

    private static FileObject handleZipJar(File file) {
        JarFileSystem jarFileSystem = new JarFileSystem();
        try {
            jarFileSystem.setJarFile(file);
        }
        catch (IOException iOException) {
            TopManager.getDefault().notifyException((Throwable)iOException);
            return null;
        }
        catch (PropertyVetoException propertyVetoException) {
            TopManager.getDefault().notifyException((Throwable)propertyVetoException);
            return null;
        }
        Repository repository = TopManager.getDefault().getRepository();
        FileSystem fileSystem = repository.findFileSystem(jarFileSystem.getSystemName());
        if (fileSystem == null) {
            repository.addFileSystem((FileSystem)jarFileSystem);
            fileSystem = jarFileSystem;
        }
        return fileSystem.getRoot();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findJavaPackage(File var0) {
        var1_1 = "";
        var2_2 = false;
        var3_3 = null;
        try {
            var3_3 = new BufferedReader(new SourceReader(new FileInputStream(var0)));
            var3_3.mark(2);
            var5_4 = new char[2];
            var3_3.read(var5_4, 0, 2);
            if (var5_4[0] == '\u00ff' && var5_4[1] == '\u00fe') {
                var3_3.close();
                var3_3 = new BufferedReader(new SourceReader((InputStream)new FileInputStream(var0), "Unicode"));
            } else {
                var3_3.reset();
            }
            while (!var2_2) {
                block24: {
                    var6_7 = var3_3.readLine();
                    if (var6_7 != null) break block24;
                    var2_2 = true;
                    var7_8 = var1_1;
                    var15_15 = null;
                    ** GOTO lbl96
                }
                var4_5 = var6_7.indexOf("package");
                if (var4_5 == -1) continue;
                var7_8 = new StringTokenizer(var6_7, " \t;");
                var8_9 = false;
                while (var7_8.hasMoreTokens()) {
                    var9_10 = var7_8.nextToken();
                    if (var8_9) {
                        var10_11 = new StringTokenizer(var9_10, ".");
                        var11_12 = var10_11.hasMoreTokens();
                        block13: while (var10_11.hasMoreTokens()) {
                            var12_13 = var10_11.nextToken();
                            if (var12_13.length() == 0) {
                                var11_12 = false;
                                break;
                            }
                            if (!Character.isJavaIdentifierStart(var12_13.charAt(0))) {
                                var11_12 = false;
                                break;
                            }
                            var13_14 = 1;
                            while (var13_14 < var12_13.length()) {
                                if (!Character.isJavaIdentifierPart(var12_13.charAt(var13_14))) {
                                    var11_12 = false;
                                    continue block13;
                                }
                                ++var13_14;
                            }
                        }
                        if (var11_12) {
                            var1_1 = var9_10;
                            var2_2 = true;
                            var12_13 = var1_1;
                            var15_16 = null;
                            try {
                                if (var3_3 == null) return var12_13;
                                var3_3.close();
                                return var12_13;
                            }
                            catch (IOException var16_22) {
                                TopManager.getDefault().notifyException((Throwable)var16_22);
                            }
                            return var12_13;
                        }
                        var8_9 = false;
                        continue;
                    }
                    if (var9_10.equals("package")) {
                        var8_9 = true;
                        continue;
                    }
                    if (!var9_10.equals("{")) continue;
                    var2_2 = true;
                    var10_11 = var1_1;
                    ** GOTO lbl103
                }
            }
            ** GOTO lbl111
        }
        catch (IOException var4_6) {
            TopManager.getDefault().notifyException((Throwable)var4_6);
            var15_19 = null;
            try {}
            catch (IOException var16_25) {
                TopManager.getDefault().notifyException((Throwable)var16_25);
                return null;
            }
            if (var3_3 == null) return null;
            var3_3.close();
            return null;
        }
        {
            catch (Throwable var14_27) {
                var15_20 = null;
                ** try [egrp 2[TRYBLOCK] [2 : 393->404)] { 
lbl90:
                // 1 sources

                if (var3_3 == null) throw var14_27;
                var3_3.close();
                throw var14_27;
lbl93:
                // 1 sources

                catch (IOException var16_26) {
                    TopManager.getDefault().notifyException((Throwable)var16_26);
                }
                throw var14_27;
            }
lbl96:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [2 : 393->404)] { 
lbl97:
            // 1 sources

            if (var3_3 == null) return var7_8;
            var3_3.close();
            return var7_8;
lbl100:
            // 1 sources

            catch (IOException var16_21) {
                TopManager.getDefault().notifyException((Throwable)var16_21);
            }
            return var7_8;
lbl103:
            // 1 sources

            var15_17 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 393->404)] { 
lbl105:
            // 1 sources

            if (var3_3 == null) return var10_11;
            var3_3.close();
            return var10_11;
lbl108:
            // 1 sources

            catch (IOException var16_23) {
                TopManager.getDefault().notifyException((Throwable)var16_23);
            }
            return var10_11;
lbl111:
            // 1 sources

            var15_18 = null;
            try {}
            catch (IOException var16_24) {}
            TopManager.getDefault().notifyException((Throwable)var16_24);
            return null;
            if (var3_3 == null) return null;
            var3_3.close();
            return null;
        }
    }

    private static synchronized FileObject find(File file) {
        String[] stringArray;
        String string = file.toString();
        String string2 = string.toUpperCase();
        if (string2.endsWith(ZIP_EXT) || string2.endsWith(JAR_EXT)) {
            return OpenFile.handleZipJar(file);
        }
        FileObject[] fileObjectArray = FileUtil.fromFile((File)file);
        if (fileObjectArray.length > 0) {
            FileObject fileObject = fileObjectArray[0];
            if (fileObjectArray.length > 1) {
                if (string2.endsWith(JAVA_EXT)) {
                    String string3 = OpenFile.findJavaPackage(file);
                    int n = 0;
                    while (n < fileObjectArray.length) {
                        String string4 = "";
                        if (!fileObjectArray[n].isRoot()) {
                            FileObject fileObject2 = fileObjectArray[n].getParent();
                            string4 = fileObject2.getPackageName('.');
                        }
                        if (string3.equals(string4)) {
                            fileObject = fileObjectArray[n];
                            break;
                        }
                        ++n;
                    }
                } else {
                    String string5 = fileObject.getPackageName('.');
                    int n = 1;
                    while (n < fileObjectArray.length) {
                        String string6 = fileObjectArray[n].getPackageName('.');
                        if (string6.length() < string5.length()) {
                            fileObject = fileObjectArray[n];
                            string5 = string6;
                        }
                        ++n;
                    }
                }
            }
            return fileObject;
        }
        String[] stringArray2 = null;
        boolean bl = false;
        if (string2.endsWith(JAVA_EXT)) {
            stringArray2 = OpenFile.findJavaPackage(file);
        }
        if (stringArray2 == null) {
            stringArray2 = "";
            bl = false;
        } else {
            bl = true;
        }
        String string7 = stringArray2.replace('.', File.separatorChar);
        Object object = "";
        for (File file2 = file.getParentFile(); !stringArray2.equals("") && file2 != null; file2 = file2.getParentFile()) {
            String[] stringArray3;
            int n = stringArray2.lastIndexOf(46);
            if (n == -1) {
                stringArray = "";
                stringArray3 = stringArray2;
            } else {
                stringArray = stringArray2.substring(0, n);
                stringArray3 = stringArray2.substring(n + 1);
            }
            if (file2.getName().equals(stringArray3) && file2.getParentFile() != null) {
                stringArray2 = stringArray;
                if (object.equals("")) {
                    object = stringArray3;
                    continue;
                }
                object = (String)stringArray3 + "." + (String)object;
                continue;
            }
            bl = false;
            break;
        }
        File[] fileArray = new File[]{null};
        stringArray = new String[]{null};
        int n = 0;
        if (!object.equals("")) {
            int n2 = -1;
            do {
                n2 = object.indexOf(46, n2 + 1);
                ++n;
            } while (n2 != -1);
        }
        if (!bl) {
            n = -1;
        }
        if (!string2.endsWith(JAVA_EXT)) {
            fileArray[0] = file.getParentFile();
            stringArray[0] = "";
        } else {
            OpenFile.askForMountPoint(file, n, fileArray, stringArray);
        }
        if (fileArray[0] == null) {
            return null;
        }
        LocalFileSystem localFileSystem = new LocalFileSystem();
        try {
            localFileSystem.setRootDirectory(fileArray[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            TopManager.getDefault().notifyException((Throwable)propertyVetoException);
            return null;
        }
        catch (IOException iOException) {
            TopManager.getDefault().notifyException((Throwable)iOException);
            return null;
        }
        Repository repository = TopManager.getDefault().getRepository();
        if (repository.findFileSystem(localFileSystem.getSystemName()) != null) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$openfile$OpenFile == null ? (class$org$netbeans$modules$openfile$OpenFile = OpenFile.class$("org.netbeans.modules.openfile.OpenFile")) : class$org$netbeans$modules$openfile$OpenFile)).getString("MSG_wasAlreadyMounted"), localFileSystem.getSystemName())));
            return null;
        }
        repository.addFileSystem((FileSystem)localFileSystem);
        return localFileSystem.findResource(stringArray[0].replace('.', '/') + (stringArray[0].equals("") ? "" : "/") + file.getName());
    }

    private static void askForMountPoint(File file, int n, final File[] fileArray, final String[] stringArray) {
        final Vector<File> vector = new Vector<File>();
        final Vector<String> vector2 = new Vector<String>();
        String string = "";
        File file2 = file.getParentFile();
        while (file2 != null) {
            vector.add(file2);
            vector2.add(string);
            if (!string.equals("")) {
                string = "." + string;
            }
            string = file2.getName() + string;
            file2 = file2.getParentFile();
        }
        if (n != -1) {
            String string2 = (String)vector2.get(n);
            fileArray[0] = (File)vector.get(n);
            stringArray[0] = string2;
            return;
        }
        PackagePanel packagePanel = new PackagePanel(file, n, vector, vector2);
        final Dialog[] dialogArray = new Dialog[1];
        final JButton jButton = packagePanel.getOKButton();
        JButton jButton2 = packagePanel.getCancelButton();
        final JList jList = packagePanel.getList();
        dialogArray[0] = TopManager.getDefault().createDialog(new DialogDescriptor((Object)packagePanel, SettingsBeanInfo.getString("LBL_wizTitle"), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, new HelpCtx((class$org$netbeans$modules$openfile$OpenFile == null ? (class$org$netbeans$modules$openfile$OpenFile = OpenFile.class$("org.netbeans.modules.openfile.OpenFile")) : class$org$netbeans$modules$openfile$OpenFile).getName() + ".dialog"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jButton) {
                    int n = jList.getSelectedIndex();
                    if (n != -1) {
                        fileArray[0] = (File)vector.get(n);
                        stringArray[0] = (String)vector2.get(n);
                    } else {
                        System.err.println("Should not have accepted OK button");
                    }
                }
                dialogArray[0].dispose();
            }
        }));
        dialogArray[0].show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class SourceReader
    extends InputStreamReader {
        private int preRead = -1;
        private boolean inString = false;
        private boolean backslashLast = false;
        private boolean separatorLast = false;
        private static final char[] separators = new char[]{'.'};
        private static final char[] whitespaces = new char[]{' ', '\t', '\r', '\n'};

        public SourceReader(InputStream inputStream) {
            super(inputStream);
        }

        public SourceReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
            super(inputStream, string);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            char[] cArray2 = new char[1];
            while (n3 < n2) {
                int n4;
                if (this.preRead != -1) {
                    n4 = this.preRead;
                    this.preRead = -1;
                } else {
                    n4 = super.read(cArray2, 0, 1);
                    if (n4 == -1) {
                        return n3 > 0 ? n3 : -1;
                    }
                    n4 = cArray2[0];
                }
                if (n4 == 47 && !this.inString) {
                    this.preRead = super.read(cArray2, 0, 1);
                    if (this.preRead == 1) {
                        this.preRead = cArray2[0];
                    }
                    if (this.preRead != 42 && this.preRead != 47) {
                        cArray[n++] = (char)n4;
                        ++n3;
                        if (this.preRead != -1) continue;
                        return n3;
                    }
                    if (this.preRead == 42) {
                        this.preRead = -1;
                        do {
                            if ((n4 = this.moveToChar(42)) != 0) continue;
                            n4 = super.read(cArray2, 0, 1);
                            if (n4 == 1) {
                                n4 = cArray2[0];
                            }
                            if (n4 != 42) continue;
                            this.preRead = n4;
                        } while (n4 != 47 && n4 != -1);
                    } else {
                        this.preRead = -1;
                        n4 = this.moveToChar(10);
                        if (n4 == 0) {
                            this.preRead = 10;
                        }
                    }
                    if (n4 != -1) continue;
                    return -1;
                }
                if (!this.inString) {
                    block24: {
                        if (SourceReader.isWhitespace(n4)) {
                            do {
                                this.preRead = super.read(cArray2, 0, 1);
                                if (this.preRead == -1) {
                                    return n3 > 0 ? n3 : -1;
                                }
                                this.preRead = cArray2[0];
                                if (!SourceReader.isSeparator(this.preRead)) continue;
                                n4 = this.preRead;
                                this.preRead = -1;
                                break block24;
                            } while (SourceReader.isWhitespace(this.preRead));
                            if (this.separatorLast) {
                                n4 = this.preRead;
                                this.preRead = -1;
                            }
                        }
                    }
                    if (n4 == 34 || n4 == 39) {
                        this.inString = true;
                        this.separatorLast = false;
                    } else {
                        this.separatorLast = SourceReader.isSeparator(n4);
                    }
                } else if (n4 == 34 || n4 == 39) {
                    if (!this.backslashLast) {
                        this.inString = false;
                    } else {
                        this.backslashLast = false;
                    }
                } else {
                    this.backslashLast = n4 == 92;
                }
                cArray[n++] = (char)n4;
                ++n3;
            }
            return n3;
        }

        private int moveToChar(int n) throws IOException {
            int n2;
            char[] cArray = new char[1];
            if (this.preRead != -1) {
                n2 = this.preRead;
                this.preRead = -1;
            } else {
                n2 = super.read(cArray, 0, 1);
                if (n2 == 1) {
                    n2 = cArray[0];
                }
            }
            while (n2 != -1 && n2 != n) {
                n2 = super.read(cArray, 0, 1);
                if (n2 != 1) continue;
                n2 = cArray[0];
            }
            return n2 == -1 ? -1 : 0;
        }

        private static boolean isSeparator(int n) {
            int n2 = 0;
            while (n2 < separators.length) {
                if (n == separators[n2]) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private static boolean isWhitespace(int n) {
            int n2 = 0;
            while (n2 < whitespaces.length) {
                if (n == whitespaces[n2]) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

