/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.Date;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.util.NbBundle;

public class LocalFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.List,
AbstractFileSystem.Info,
AbstractFileSystem.Change {
    private static final long serialVersionUID = -5355566113542272442L;
    private static final int REFRESH_TIME = Integer.getInteger("org.openide.filesystems.LocalFileSystem.REFRESH_TIME", 15000);
    private File rootFile = new File(".");
    private boolean readOnly;
    private static final int SUCCESS = 0;
    private static final int FAILURE = 1;
    private static final int NOT_EXISTS = 3;
    static /* synthetic */ Class class$org$openide$filesystems$LocalFileSystem;

    public LocalFileSystem() {
        Impl impl = new Impl(this);
        this.info = impl;
        this.change = impl;
        InnerAttrs innerAttrs = new InnerAttrs(this, this.info, this.change, impl);
        this.attr = innerAttrs;
        this.list = innerAttrs;
        this.setRefreshTime(REFRESH_TIME);
    }

    public LocalFileSystem(FileSystemCapability fileSystemCapability) {
        this();
        this.setCapability(fileSystemCapability);
    }

    public String getDisplayName() {
        boolean bl;
        boolean bl2 = bl = this.isValid() && this.rootFile != null && this.rootFile.isDirectory() && this.rootFile.exists();
        if (bl) {
            return FileSystem.getString((String)"LAB_FileSystemValid", (Object)this.rootFile.toString());
        }
        return FileSystem.getString((String)"LAB_FileSystemInvalid", (Object)this.rootFile.toString());
    }

    public synchronized void setRootDirectory(File file) throws PropertyVetoException, IOException {
        if (!file.exists() || file.isFile()) {
            FSException.io((String)"EXC_RootNotExist", (Object)file.toString());
        }
        String string = this.getDisplayName();
        this.setSystemName(this.computeSystemName(file));
        this.rootFile = file;
        this.firePropertyChange("root", null, this.refreshRoot());
        this.firePropertyChange("displayName", string, this.getDisplayName());
    }

    public File getRootDirectory() {
        return this.rootFile;
    }

    public void setReadOnly(boolean bl) {
        if (bl != this.readOnly) {
            this.readOnly = bl;
            this.firePropertyChange("readOnly", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(this.rootFile.toString());
    }

    protected String computeSystemName(File file) {
        return file.toString().replace(File.separatorChar, '/');
    }

    public String[] children(String string) {
        File file = this.getFile(string);
        if (file.isDirectory()) {
            return file.list();
        }
        return null;
    }

    public void createFolder(String string) throws IOException {
        boolean bl;
        File file = this.getFile(string);
        if (string.equals("")) {
            FSException.io((String)"EXC_CannotCreateF", (Object[])new Object[]{file.getName(), this.getDisplayName(), file.toString()});
        }
        if (file.exists()) {
            FSException.io((String)"EXC_FolderAlreadyExist", (Object[])new Object[]{file.getName(), this.getDisplayName(), file.toString()});
        }
        if (!(bl = LocalFileSystem.createRecursiveFolder(file))) {
            FSException.io((String)"EXC_CannotCreateF", (Object[])new Object[]{file.getName(), this.getDisplayName(), file.toString()});
        }
    }

    boolean isEnabledRefreshFolder() {
        return true;
    }

    private static boolean createRecursiveFolder(File file) {
        String string;
        if (file.exists()) {
            return true;
        }
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        if ((string = file.getParent()) == null) {
            return false;
        }
        if (!LocalFileSystem.createRecursiveFolder(new File(string))) {
            return false;
        }
        file.mkdir();
        return file.exists();
    }

    public void createData(String string) throws IOException {
        File file = this.getFile(string);
        if (!file.createNewFile()) {
            String string2 = NbBundle.getMessage((Class)(class$org$openide$filesystems$LocalFileSystem == null ? (class$org$openide$filesystems$LocalFileSystem = LocalFileSystem.class$("org.openide.filesystems.LocalFileSystem")) : class$org$openide$filesystems$LocalFileSystem), (String)"EXC_DataAlreadyExist", (Object[])new Object[]{file.getName(), this.getDisplayName(), file.toString()});
            SyncFailedException syncFailedException = new SyncFailedException(string2);
            ExternalUtil.annotate((Throwable)syncFailedException, (String)string2);
            throw syncFailedException;
        }
    }

    public void rename(String string, String string2) throws IOException {
        File file = this.getFile(string);
        File file2 = this.getFile(string2);
        if (file2.exists() && !file2.equals(file) || !file.renameTo(file2)) {
            FSException.io((String)"EXC_CannotRename", (Object)string, (Object)this.getDisplayName(), (Object)string2);
        }
    }

    public void delete(String string) throws IOException {
        File file = this.getFile(string);
        if (LocalFileSystem.deleteFile(file) != 0) {
            if (file.exists()) {
                FSException.io((String)"EXC_CannotDelete", (Object)string, (Object)this.getDisplayName(), (Object)file.toString());
            } else {
                FileObject fileObject = this.findResource(string);
                if (fileObject != null) {
                    if (fileObject.getParent() != null) {
                        fileObject.getParent().refresh();
                    }
                    fileObject.refresh();
                    if (fileObject.isValid()) {
                        FSException.io((String)"EXC_CannotDelete", (Object)string, (Object)this.getDisplayName(), (Object)file.toString());
                    }
                }
            }
        }
    }

    private static int deleteFile(File file) {
        boolean bl = file.delete();
        if (bl) {
            return 0;
        }
        if (!file.exists()) {
            return 3;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                if (LocalFileSystem.deleteFile(fileArray[n]) != 0) {
                    return 1;
                }
                ++n;
            }
        }
        return file.delete() ? 0 : 1;
    }

    public Date lastModified(String string) {
        return new Date(this.getFile(string).lastModified());
    }

    public boolean folder(String string) {
        return this.getFile(string).isDirectory();
    }

    public boolean readOnly(String string) {
        File file = this.getFile(string);
        return !file.canWrite() && file.exists();
    }

    public String mimeType(String string) {
        return null;
    }

    public long size(String string) {
        return this.getFile(string).length();
    }

    public InputStream inputStream(String string) throws FileNotFoundException {
        FileInputStream fileInputStream;
        File file = null;
        try {
            file = this.getFile(string);
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (file == null || !file.exists()) {
                ExternalUtil.annotate((Throwable)fileNotFoundException, (String)NbBundle.getMessage((Class)(class$org$openide$filesystems$LocalFileSystem == null ? (class$org$openide$filesystems$LocalFileSystem = LocalFileSystem.class$("org.openide.filesystems.LocalFileSystem")) : class$org$openide$filesystems$LocalFileSystem), (String)"EXC_FileOutsideModified"));
            }
            throw fileNotFoundException;
        }
        return fileInputStream;
    }

    public OutputStream outputStream(String string) throws IOException {
        return new FileOutputStream(this.getFile(string));
    }

    public void lock(String string) throws IOException {
        File file = this.getFile(string);
        if (!file.canWrite() && file.exists() || this.isReadOnly()) {
            FSException.io((String)"EXC_CannotLock", (Object)string, (Object)this.getDisplayName(), (Object)file.toString());
        }
    }

    public void unlock(String string) {
    }

    public void markUnimportant(String string) {
    }

    private File getFile(String string) {
        return new File(this.rootFile, string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.registerValidation(new ObjectInputValidation(){
            static /* synthetic */ Class class$org$openide$filesystems$DefaultAttributes;

            public void validateObject() {
                if (LocalFileSystem.this.attr.getClass() == (class$org$openide$filesystems$DefaultAttributes == null ? (class$org$openide$filesystems$DefaultAttributes = 1.class$("org.openide.filesystems.DefaultAttributes")) : class$org$openide$filesystems$DefaultAttributes)) {
                    Impl impl = new Impl(LocalFileSystem.this);
                    LocalFileSystem.this.attr = new InnerAttrs(LocalFileSystem.this, impl, impl, impl);
                }
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class InnerAttrs
    extends DefaultAttributes {
        static final long serialVersionUID = 1257351369229921993L;
        LocalFileSystem lfs;

        public InnerAttrs(LocalFileSystem localFileSystem, AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
            super(info, change, list);
            this.lfs = localFileSystem;
        }

        public Object readAttribute(String string, String string2) {
            if (string2.equals("java.io.File")) {
                return this.lfs.getFile(string);
            }
            return super.readAttribute(string, string2);
        }
    }

    public static class Impl
    implements AbstractFileSystem.List,
    AbstractFileSystem.Info,
    AbstractFileSystem.Change {
        static final long serialVersionUID = -8432015909317698511L;
        private LocalFileSystem fs;

        public Impl(LocalFileSystem localFileSystem) {
            this.fs = localFileSystem;
        }

        public String[] children(String string) {
            return this.fs.children(string);
        }

        public void createFolder(String string) throws IOException {
            this.fs.createFolder(string);
        }

        public void createData(String string) throws IOException {
            this.fs.createData(string);
        }

        public void rename(String string, String string2) throws IOException {
            this.fs.rename(string, string2);
        }

        public void delete(String string) throws IOException {
            this.fs.delete(string);
        }

        public Date lastModified(String string) {
            return this.fs.lastModified(string);
        }

        public boolean folder(String string) {
            return this.fs.folder(string);
        }

        public boolean readOnly(String string) {
            return this.fs.readOnly(string);
        }

        public String mimeType(String string) {
            return this.fs.mimeType(string);
        }

        public long size(String string) {
            return this.fs.size(string);
        }

        public InputStream inputStream(String string) throws FileNotFoundException {
            return this.fs.inputStream(string);
        }

        public OutputStream outputStream(String string) throws IOException {
            return this.fs.outputStream(string);
        }

        public void lock(String string) throws IOException {
            this.fs.lock(string);
        }

        public void unlock(String string) {
            this.fs.unlock(string);
        }

        public void markUnimportant(String string) {
            this.fs.markUnimportant(string);
        }
    }
}

