/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import org.openide.util.Utilities;

public class ProgressDialog
extends JDialog {
    static final long serialVersionUID = 6292164837837186498L;
    JLabel label;
    JProgressBar bar;
    JPanel progressPanel;
    Dimension panelSize;

    public ProgressDialog(Frame frame, String string, int n, int n2) {
        super(frame);
        this.initialize(string, n, n2);
    }

    public ProgressDialog(String string, int n, int n2) {
        this.initialize(string, n, n2);
    }

    private void initialize(String string, int n, int n2) {
        this.setDefaultCloseOperation(0);
        this.setTitle(string);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout(5, 5));
        this.progressPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.label = new JLabel("                           ");
        this.progressPanel.add((Component)this.label, "North");
        this.bar = new JProgressBar();
        this.bar.setMinimum(n);
        this.bar.setMaximum(n2);
        this.bar.setValue(0);
        this.progressPanel.add((Component)this.bar, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.progressPanel, "Center");
        this.pack();
        this.center();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        if (this.panelSize == null) {
            this.panelSize = this.progressPanel.getSize();
        }
        this.label.paintImmediately(0, 0, this.panelSize.width, this.panelSize.height);
    }

    public void setValue(int n) {
        try {
            this.bar.setValue(n);
            this.bar.paintImmediately(0, 0, this.bar.getSize().width, this.bar.getSize().height);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void center() {
        ((Component)this).setBounds(Utilities.findCenterBounds((Dimension)this.getSize()));
    }

    public void inc() {
        this.setValue(this.bar.getValue() + 1);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(dimension.width, 300);
        dimension.height = Math.max(dimension.height, 100);
        return dimension;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.panelSize = this.progressPanel.getSize();
        this.progressPanel.paintImmediately(0, 0, this.panelSize.width, this.panelSize.height);
    }
}

