/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.netbeans.modules.vcscore.actions.ClusterItemVisualizer;
import org.netbeans.modules.vcscore.actions.GeneralCommandAction;
import org.openide.TopManager;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClusteringAction
extends GeneralCommandAction {
    public static final String POPUP_DEFINITION_FOLDER = "Popup_Definition_Folder";
    public static final String IS_SWITCHABLE_POPUP = "IsSwitchable";
    protected static final String CLIENT_PROP_ACTION = "SELECTED_COMMAND_ACTION";
    transient boolean CTRL_Down = false;
    private transient ArrayList switchableList;
    protected transient boolean isMenu;
    static final long serialVersionUID = 0L;
    private transient JMenu lazyMenu = null;
    private transient MenuListener menuListener = new MenuListener(){

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void menuSelected(MenuEvent menuEvent) {
            ClusteringAction.this.deselectedMenu();
        }
    };
    private transient MenuKeyListener menuKeyListener = new MenuKeyListener(){

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            boolean bl = "Ctrl".equals(KeyEvent.getKeyText(menuKeyEvent.getKeyCode())) || !menuKeyEvent.isControlDown();
            ClusteringAction.this.changeCtrlSigns(bl);
            ClusteringAction.this.CTRL_Down = bl;
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
            boolean bl = "Ctrl".equals(KeyEvent.getKeyText(menuKeyEvent.getKeyCode())) || !menuKeyEvent.isControlDown();
            ClusteringAction.this.changeCtrlSigns(!bl);
            ClusteringAction.this.CTRL_Down = !bl;
        }
    };
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$ClusteringAction;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie$Of;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$ClusterItemVisualizer;
    static /* synthetic */ Class class$javax$swing$JSeparator;

    protected String iconResource() {
        return null;
    }

    public String getName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$actions$ClusteringAction == null ? (class$org$netbeans$modules$vcscore$actions$ClusteringAction = ClusteringAction.class$("org.netbeans.modules.vcscore.actions.ClusteringAction")) : class$org$netbeans$modules$vcscore$actions$ClusteringAction)).getString("ClusteringAction.displayName");
    }

    protected String getClusterRootPath() {
        return this.getValue(POPUP_DEFINITION_FOLDER).toString();
    }

    protected boolean isSwitchingEnabled() {
        Boolean bl = (Boolean)this.getValue(IS_SWITCHABLE_POPUP);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    protected boolean isCTRLDown() {
        return this.CTRL_Down;
    }

    public JMenuItem getMenuPresenter() {
        if (this.lazyMenu != null) {
            this.lazyMenu.removeMenuListener(this.menuListener);
            this.lazyMenu.removeMenuKeyListener(this.menuKeyListener);
        }
        this.lazyMenu = new LazyPopup(true);
        return this.lazyMenu;
    }

    public JMenuItem getPopupPresenter() {
        if (this.lazyMenu != null) {
            this.lazyMenu.removeMenuListener(this.menuListener);
            this.lazyMenu.removeMenuKeyListener(this.menuKeyListener);
        }
        this.lazyMenu = new LazyPopup(false);
        return this.lazyMenu;
    }

    void createPresenter(boolean bl, JMenu jMenu) {
        this.switchableList = new ArrayList();
        this.isMenu = bl;
        jMenu.addMenuKeyListener(this.menuKeyListener);
        jMenu.addMenuListener(this.menuListener);
        this.createPresenter(jMenu, this.getClusterRootPath());
    }

    protected void createPresenter(JMenu jMenu, String string) {
        JMenuItem jMenuItem = null;
        JMenu jMenu2 = null;
        FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(string);
        if (fileObject == null) {
            return;
        }
        DataFolder dataFolder = null;
        try {
            dataFolder = (DataFolder)DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
        DataObject[] dataObjectArray = dataFolder.getChildren();
        if (dataObjectArray != null && dataObjectArray.length > 0) {
            boolean bl = false;
            int n = 0;
            while (n < dataObjectArray.length) {
                Object object;
                if (dataObjectArray[n] instanceof DataFolder) {
                    jMenu2 = new JMenu();
                    Actions.setMenuText((AbstractButton)jMenu2, (String)dataObjectArray[n].getName(), (boolean)this.isMenu);
                    object = string + "/" + dataObjectArray[n].getPrimaryFile().getName();
                    this.createPresenter(jMenu2, (String)object);
                    if (jMenu2.getItemCount() > 0) {
                        jMenu2.addActionListener((ActionListener)((Object)this));
                        jMenu.add(jMenu2);
                    }
                    bl = false;
                }
                if ((object = (InstanceCookie.Of)dataObjectArray[n].getCookie(class$org$openide$cookies$InstanceCookie$Of == null ? ClusteringAction.class$("org.openide.cookies.InstanceCookie$Of") : class$org$openide$cookies$InstanceCookie$Of)) != null) {
                    try {
                        ClusterItemVisualizer clusterItemVisualizer;
                        Object object2;
                        if (object.instanceOf(class$org$netbeans$modules$vcscore$actions$ClusterItemVisualizer == null ? ClusteringAction.class$("org.netbeans.modules.vcscore.actions.ClusterItemVisualizer") : class$org$netbeans$modules$vcscore$actions$ClusterItemVisualizer) && (object2 = object.instanceCreate()) != null && this.checkItemEnable(clusterItemVisualizer = (ClusterItemVisualizer)object2)) {
                            jMenuItem = this.createItem(clusterItemVisualizer);
                            jMenu.add(jMenuItem);
                            bl = false;
                        }
                        if (object.instanceOf(class$javax$swing$JSeparator == null ? ClusteringAction.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator) && !bl) {
                            jMenu.addSeparator();
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        TopManager.getDefault().getErrorManager().notify(65536, (Throwable)exception);
                    }
                }
                ++n;
            }
        }
    }

    protected boolean checkItemEnable(ClusterItemVisualizer clusterItemVisualizer) {
        return clusterItemVisualizer.isItemEnabled(this);
    }

    private JMenuItem createItem(ClusterItemVisualizer clusterItemVisualizer) {
        JMenuItem jMenuItem = new JMenuItem();
        String string = clusterItemVisualizer.getName();
        if (!this.isSwitchingEnabled() && clusterItemVisualizer.isSwitchable()) {
            string = string + NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$actions$ClusteringAction == null ? (class$org$netbeans$modules$vcscore$actions$ClusteringAction = ClusteringAction.class$("org.netbeans.modules.vcscore.actions.ClusteringAction")) : class$org$netbeans$modules$vcscore$actions$ClusteringAction)).getString("ClusteringAction.DialogDots");
        }
        Actions.setMenuText((AbstractButton)jMenuItem, (String)string, (boolean)this.isMenu);
        if (this.isMenu) {
            jMenuItem.setIcon(clusterItemVisualizer.getIcon());
        }
        jMenuItem.putClientProperty(CLIENT_PROP_ACTION, clusterItemVisualizer);
        jMenuItem.addActionListener((ActionListener)((Object)this));
        this.assignHelp(jMenuItem, clusterItemVisualizer.getClass().getName());
        if (this.isSwitchingEnabled() && clusterItemVisualizer.isSwitchable()) {
            this.switchableList.add(jMenuItem);
        }
        return jMenuItem;
    }

    private void assignHelp(JMenuItem jMenuItem, String string) {
        HelpCtx.setHelpIDString((JComponent)jMenuItem, (String)((class$org$netbeans$modules$vcscore$actions$ClusteringAction == null ? (class$org$netbeans$modules$vcscore$actions$ClusteringAction = ClusteringAction.class$("org.netbeans.modules.vcscore.actions.ClusteringAction")) : class$org$netbeans$modules$vcscore$actions$ClusteringAction).getName() + "." + string));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            ClusterItemVisualizer clusterItemVisualizer = (ClusterItemVisualizer)jMenuItem.getClientProperty(CLIENT_PROP_ACTION);
            clusterItemVisualizer.setSwitched(this.CTRL_Down);
            clusterItemVisualizer.performAction(this.getActivatedNodes(), this);
        }
    }

    private void deselectedMenu() {
        this.changeCtrlSigns(false);
        this.CTRL_Down = false;
    }

    private void changeCtrlSigns(boolean bl) {
        if (bl == this.CTRL_Down) {
            return;
        }
        String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$actions$ClusteringAction == null ? (class$org$netbeans$modules$vcscore$actions$ClusteringAction = ClusteringAction.class$("org.netbeans.modules.vcscore.actions.ClusteringAction")) : class$org$netbeans$modules$vcscore$actions$ClusteringAction)).getString("ClusteringAction.DialogDots");
        Iterator iterator = ((AbstractList)this.switchableList).iterator();
        while (iterator.hasNext()) {
            JMenuItem jMenuItem = (JMenuItem)iterator.next();
            String string2 = jMenuItem.getText();
            if (bl) {
                if (!string2.endsWith(string)) {
                    string2 = string2 + string;
                }
            } else if (string2.endsWith(string)) {
                string2 = string2.substring(0, string2.length() - string.length());
            }
            jMenuItem.setText(string2);
        }
    }

    protected boolean clearSharedData() {
        if (this.lazyMenu != null) {
            this.lazyMenu.removeMenuListener(this.menuListener);
            this.lazyMenu.removeMenuKeyListener(this.menuKeyListener);
        }
        this.lazyMenu = null;
        this.menuListener = null;
        return super.clearSharedData();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class LazyPopup
    extends JMenuPlus {
        private Icon icon = null;
        private boolean isMenu;
        private boolean created = false;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$ClusteringAction;

        LazyPopup(boolean bl) {
            this.isMenu = bl;
            Actions.setMenuText((AbstractButton)((Object)this), (String)ClusteringAction.this.getName(), (boolean)bl);
            if (bl) {
                ((AbstractButton)((Object)this)).setIcon(ClusteringAction.this.getIcon());
            }
            HelpCtx.setHelpIDString((JComponent)((Object)this), (String)(class$org$netbeans$modules$vcscore$actions$ClusteringAction == null ? (class$org$netbeans$modules$vcscore$actions$ClusteringAction = LazyPopup.class$("org.netbeans.modules.vcscore.actions.ClusteringAction")) : class$org$netbeans$modules$vcscore$actions$ClusteringAction).getName());
        }

        public JPopupMenu getPopupMenu() {
            if (!this.created) {
                this.createMenuItems();
            }
            return super.getPopupMenu();
        }

        private void createMenuItems() {
            this.created = true;
            ((JMenu)((Object)this)).removeAll();
            ClusteringAction.this.createPresenter(this.isMenu, (JMenu)((Object)this));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

