/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.actions;

import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vcscore.actions.GeneralCommandAction;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.VersioningRepository;
import org.netbeans.modules.vcscore.versioning.impl.VersioningExplorer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class VersioningExplorerAction
extends GeneralCommandAction {
    private static final long serialVersionUID = -4949229720968764504L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction;

    public String getName() {
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction == null ? (class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction = VersioningExplorerAction.class$("org.netbeans.modules.vcscore.actions.VersioningExplorerAction")) : class$org$netbeans$modules$vcscore$actions$VersioningExplorerAction), (String)"LBL_VersioningExplorer");
    }

    protected String iconResource() {
        return "org/netbeans/modules/vcscore/versioning/impl/versioningExplorer.gif";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected void performAction(Node[] nodeArray) {
        VersioningExplorer.Panel panel = VersioningExplorer.getRevisionExplorer();
        panel.open();
        HashMap hashMap = this.getFilesByFS(nodeArray);
        VersioningExplorerAction.selectVersioningFiles(panel, hashMap);
        panel.requestFocus();
    }

    private FileObject[] convertFileObjects(FileObject[] fileObjectArray) {
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            return fileObjectArray;
        }
        FileObject[] fileObjectArray2 = new FileObject[fileObjectArray.length];
        int n = 0;
        while (n < fileObjectArray.length) {
            fileObjectArray2[n] = fileObjectArray[n];
            FileObject fileObject = fileObjectArray[n];
            FileSystem fileSystem = (FileSystem)fileObject.getAttribute("VcsFileSystemAttributeIdentifier");
            if (fileSystem != null) {
                try {
                    FileSystem fileSystem2 = fileObject.getFileSystem();
                    if (!fileSystem2.equals(fileSystem)) {
                        String string = (String)fileObject.getAttribute("VcsFileSystemNativeFOPath");
                        fileObjectArray2[n] = fileSystem.findResource(string);
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return fileObjectArray2;
    }

    private HashMap getFilesByFS(Node[] nodeArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap hashMap2 = this.getSupporterMap(nodeArray);
        Iterator iterator = hashMap2.values().iterator();
        while (iterator.hasNext()) {
            Set set = (Set)iterator.next();
            FileObject[] fileObjectArray = new FileObject[set.size()];
            if (fileObjectArray == null || fileObjectArray.length == 0) continue;
            fileObjectArray = set.toArray(fileObjectArray);
            FileObject[] fileObjectArray2 = this.convertFileObjects(fileObjectArray);
            int n = 0;
            while (n < fileObjectArray2.length) {
                FileObject fileObject = fileObjectArray2[n];
                try {
                    FileSystem fileSystem = fileObject.getFileSystem();
                    if (fileSystem != null) {
                        hashMap.put(fileObject.getPackageNameExt('/', '.'), fileSystem.getSystemName());
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                ++n;
            }
        }
        return hashMap;
    }

    private Node[] getVersioningNodes(Map map) {
        VersioningRepository versioningRepository = VersioningRepository.getRepository();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            FileObject fileObject;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            VersioningFileSystem versioningFileSystem = versioningRepository.getSystem(string2);
            if (versioningFileSystem == null || (fileObject = versioningFileSystem.findResource(string)) == null) continue;
            try {
                linkedList.add(DataObject.find((FileObject)fileObject).getNodeDelegate());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return linkedList.toArray(new Node[linkedList.size()]);
    }

    private static void selectVersioningFiles(ExplorerPanel explorerPanel, Map map) {
        Node[] nodeArray;
        VersioningRepository versioningRepository = VersioningRepository.getRepository();
        final ExplorerManager explorerManager = explorerPanel.getExplorerManager();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            FileObject fileObject;
            nodeArray = iterator.next();
            String string = (String)nodeArray.getKey();
            String string2 = (String)nodeArray.getValue();
            VersioningFileSystem versioningFileSystem = versioningRepository.getSystem(string2);
            if (versioningFileSystem == null || (fileObject = versioningFileSystem.findResource(string)) == null) continue;
            Node node = explorerManager.getRootContext().getChildren().findChild(versioningFileSystem.getSystemName());
            linkedList.add(VersioningExplorerAction.selectVersioningFile(explorerPanel, node, string));
        }
        nodeArray = linkedList.toArray(new Node[linkedList.size()]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = 0;
                while (n < nodeArray.length) {
                    explorerManager.setExploredContext(nodeArray[n]);
                    ++n;
                }
                try {
                    explorerManager.setSelectedNodes(nodeArray);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        });
    }

    private static Node selectVersioningFile(ExplorerPanel explorerPanel, Node node, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Node node2 = node;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Node node3 = node2.getChildren().findChild(string2);
            if (node3 == null) break;
            node2 = node3;
        }
        return node2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

