/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.VcsDirContainer;
import org.netbeans.modules.vcscore.VcsFactory;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class VcsCache
extends FileSystemCache
implements FileReaderListener {
    private Debug E;
    private Debug D;
    private Reference fileSystem;
    private String fsRoot;
    private int rootNameLength;
    private Map cacheDirs;
    private HashMap refreshStrategyWhenNonLocal;

    public VcsCache(Reference reference, String string) {
        super(string);
        this.D = this.E = new Debug("VcsCache", true);
        this.fileSystem = reference;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)reference.get();
        this.fsRoot = vcsFileSystem.getRootDirectory().getAbsolutePath();
        vcsFileSystem.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VcsCache.this.updateFSRoot();
            }
        });
        this.rootNameLength = this.fsRoot.length();
        this.cacheDirs = new Hashtable();
        this.refreshStrategyWhenNonLocal = new HashMap();
    }

    public void updateFSRoot() {
        this.fsRoot = ((VcsFileSystem)this.fileSystem.get()).getRootDirectory().getAbsolutePath();
        this.rootNameLength = this.fsRoot.length();
    }

    String getPath(File file) {
        String string = file.getAbsolutePath();
        if (string.length() <= this.rootNameLength) {
            return "";
        }
        String string2 = string.charAt(this.rootNameLength) == '/' || string.charAt(this.rootNameLength) == File.separatorChar ? string.substring(this.rootNameLength + 1) : string.substring(this.rootNameLength);
        string2 = string2.replace(File.separatorChar, '/');
        return string2;
    }

    String getAbsolutePath(File file) {
        return file.getAbsolutePath();
    }

    private VcsFactory getFactory() {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return null;
        }
        return vcsFileSystem.getVcsFactory();
    }

    void runVcsDirReader(VcsCacheDir vcsCacheDir, Object object) {
        String string;
        VcsFileSystem vcsFileSystem;
        VcsCache vcsCache = this;
        synchronized (vcsCache) {
            vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
            if (vcsFileSystem == null) {
                return;
            }
            if (vcsCacheDir.isBeingLoaded()) {
                return;
            }
            vcsCacheDir.setBeingLoaded(true);
            string = this.getPath(vcsCacheDir.getFile());
        }
        VcsFactory vcsFactory = vcsFileSystem.getVcsFactory();
        VcsCommandExecutor vcsCommandExecutor = vcsFactory.getVcsDirReader(new DirReaderListenerWithLock(object), string);
        if (vcsCommandExecutor != null) {
            vcsFileSystem.getCommandsPool().startExecutor(vcsCommandExecutor, vcsFileSystem);
        }
    }

    synchronized void runVcsDirReaderRecursive(VcsCacheDir vcsCacheDir, Object object) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return;
        }
        VcsFactory vcsFactory = vcsFileSystem.getVcsFactory();
        VcsCommandExecutor vcsCommandExecutor = vcsFactory.getVcsDirReaderRecursive(new DirReaderListenerWithLock(object), this.getPath(vcsCacheDir.getFile()));
        if (vcsCommandExecutor != null) {
            vcsFileSystem.getCommandsPool().startExecutor(vcsCommandExecutor, vcsFileSystem);
        }
    }

    String getCacheFileName(File file) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return null;
        }
        return vcsFileSystem.getCacheFileName(this.getPath(file));
    }

    FilenameFilter getLocalFileFilter() {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return null;
        }
        return vcsFileSystem.getLocalFileFilter();
    }

    String getLocalFileStatus() {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return "";
        }
        FileStatusProvider fileStatusProvider = vcsFileSystem.getStatusProvider();
        if (fileStatusProvider == null) {
            return "";
        }
        return fileStatusProvider.getLocalFileStatus();
    }

    public void writeAllToDisk() {
    }

    protected void loadDir(CacheDir cacheDir, int n, Object object) {
        if (n == 11 || n == 12) {
            ((VcsCacheDir)cacheDir).refreshLocal(n == 12);
            if (cacheDir.isLocal()) {
                return;
            }
            if (this.doesStrategyApply(cacheDir, n, 11)) {
                cacheDir.checkServer(object);
            }
            if (this.doesStrategyApply(cacheDir, n, 10)) {
                cacheDir.setAppliedLevel(10);
            }
            if (this.doesStrategyApply(cacheDir, n, 12)) {
                cacheDir.checkServerRecursive(object);
            }
        } else {
            super.loadDir(cacheDir, n, object);
        }
        if (cacheDir.isLocal() && (this.doesStrategyApply(cacheDir, n, 11) || this.doesStrategyApply(cacheDir, n, 3))) {
            this.refreshStrategyWhenNonLocal.put(cacheDir.getAbsolutePath(), new Integer(n));
        }
    }

    public CacheFile getCacheFile(File file, int n, Object object) {
        String string;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return null;
        }
        boolean bl = false;
        if (vcsFileSystem.getRootDirectory().equals(file) || file.getParentFile() == null) {
            string = file.getAbsolutePath();
            file = vcsFileSystem.getRootDirectory();
            bl = true;
        } else {
            string = file.getParentFile().getAbsolutePath();
        }
        CacheDir cacheDir = this.getDir(string);
        if (cacheDir == null && (cacheDir = this.initCacheDir(new File(string))) == null) {
            return null;
        }
        if (n != 5 && n != 3 && n != -1 || cacheDir.getAppliedLevel() < 3) {
            this.loadDir(cacheDir, n, object);
        }
        if (bl) {
            return cacheDir;
        }
        String string2 = file.getName();
        CacheFile cacheFile = cacheDir.getFile(string2);
        if (cacheFile != null) {
            return cacheFile;
        }
        CacheDir cacheDir2 = cacheDir.getSubDir(string2);
        return cacheDir2;
    }

    public void doRefreshDir(CacheDir cacheDir, boolean bl) {
        this.doRefreshDir(cacheDir, bl, null);
    }

    public void doRefreshDir(CacheDir cacheDir, boolean bl, Object object) {
        int n = bl ? 12 : 11;
        this.loadDir(cacheDir, n, object);
    }

    private CacheDir initCacheDir(File file) {
        File file2 = file.getParentFile();
        CacheDir cacheDir = null;
        if (file2 != null) {
            cacheDir = this.getDir(file2.getAbsolutePath());
        }
        CacheDir cacheDir2 = null;
        if (cacheDir == null) {
            VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
            if (vcsFileSystem == null) {
                return null;
            }
            VcsFactory vcsFactory = vcsFileSystem.getVcsFactory();
            cacheDir2 = new VcsCacheDir(this.getId(), file);
            cacheDir2.setLocal(false);
            this.registerDir(cacheDir2);
        } else {
            cacheDir2 = cacheDir.getSubDir(file.getName());
            if (cacheDir2 == null) {
                cacheDir2 = new VcsCacheDir(this.getId(), file);
                cacheDir.addChildDir(cacheDir2, false);
                cacheDir2.setLocal(false);
                this.registerDir(cacheDir2);
            }
        }
        return cacheDir2;
    }

    public void registerDir(CacheDir cacheDir) {
        if (cacheDir != null) {
            int n;
            String string = cacheDir.getAbsolutePath();
            while (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            while ((n = string.indexOf(File.separator + File.separator)) > 0) {
                string = string.substring(0, n) + string.substring(n + 1, string.length());
            }
            this.cacheDirs.put(string, new WeakReference<CacheDir>(cacheDir));
        }
    }

    public void registerDirRecursive(CacheDir cacheDir) {
        this.registerDir(cacheDir);
        CacheDir[] cacheDirArray = cacheDir.getSubDirs();
        int n = 0;
        while (n < cacheDirArray.length) {
            this.registerDirRecursive(cacheDirArray[n]);
            ++n;
        }
    }

    public void unregisterDir(CacheDir cacheDir) {
        if (cacheDir != null) {
            int n;
            String string = cacheDir.getAbsolutePath();
            while (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            while ((n = string.indexOf(File.separator + File.separator)) > 0) {
                string = string.substring(0, n) + string.substring(n + 1, string.length());
            }
            this.cacheDirs.remove(string);
            CacheDir[] cacheDirArray = cacheDir.getSubDirs();
            int n2 = 0;
            while (n2 < cacheDirArray.length) {
                this.unregisterDir(cacheDirArray[n2]);
                ++n2;
            }
        }
    }

    public CacheDir getDir(String string) {
        int n;
        while (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        while ((n = string.indexOf(File.separator + File.separator)) > 0) {
            string = string.substring(0, n) + string.substring(n + 1, string.length());
        }
        Reference reference = (Reference)this.cacheDirs.get(string);
        return reference != null ? reference.get() : null;
    }

    private void heyDoRefreshDir(String string) {
        FileObject fileObject;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem != null && (fileObject = vcsFileSystem.findResource(string)) != null) {
            fileObject.refresh();
        }
    }

    private void heyDoRefreshDirRecursive(VcsCacheDir vcsCacheDir) {
        this.heyDoRefreshDir(this.getPath(vcsCacheDir.getFile()));
        CacheDir[] cacheDirArray = vcsCacheDir.getSubDirs();
        int n = 0;
        while (n < cacheDirArray.length) {
            this.heyDoRefreshDirRecursive((VcsCacheDir)cacheDirArray[n]);
            ++n;
        }
    }

    private ArrayList getNonLocalSubfiles(VcsCacheDir vcsCacheDir) {
        String[] stringArray = vcsCacheDir.getFilesAndSubdirs();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n = 0;
        while (n < arrayList.size()) {
            CacheDir cacheDir;
            String string = arrayList.get(n);
            CacheFile cacheFile = vcsCacheDir.getFile(string);
            if (cacheFile instanceof VcsCacheFile) {
                if (((VcsCacheFile)cacheFile).isLocal()) {
                    arrayList.remove(n--);
                }
            } else if (cacheFile instanceof VcsCacheDir && ((VcsCacheDir)cacheFile).isLocal()) {
                arrayList.remove(n--);
            }
            if ((cacheDir = vcsCacheDir.getSubDir(string)) instanceof VcsCacheDir && ((VcsCacheDir)cacheDir).isLocal()) {
                arrayList.remove(n--);
            }
            ++n;
        }
        return arrayList;
    }

    private VcsCacheDir createSubFiles(VcsFileSystem vcsFileSystem, String string, Collection collection, Object object) {
        Object object2;
        Object object3;
        Object object4;
        VcsCacheDir vcsCacheDir = (VcsCacheDir)vcsFileSystem.getCacheProvider().getDir(string);
        if (vcsCacheDir == null) {
            vcsCacheDir = (VcsCacheDir)this.initCacheDir(vcsFileSystem.getFile(string));
        }
        CacheHandler cacheHandler = CacheHandler.getInstance();
        ArrayList arrayList = this.getNonLocalSubfiles(vcsCacheDir);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object5;
            String[] stringArray = (String[])iterator.next();
            object4 = RefreshCommandSupport.matchToFile(stringArray, vcsFileSystem.getCacheIdStr(), vcsCacheDir.getFile());
            cacheHandler.addCacheLocker(object, (CacheFile)object4);
            object3 = ((CacheFile)object4).getName();
            if (object4 instanceof VcsCacheFile) {
                ((VcsCacheFile)object4).setLocal(false);
                if (arrayList.contains(object3)) {
                    vcsCacheDir.removeFile((String)object3, false);
                    vcsCacheDir.addFile((CacheFile)object4, false);
                    ((AbstractCollection)arrayList).remove(object3);
                    continue;
                }
                vcsCacheDir.addFile((CacheFile)object4, true);
                continue;
            }
            if (!(object4 instanceof VcsCacheDir)) continue;
            object2 = (VcsCacheDir)object4;
            ((CacheDir)object2).setLocal(false);
            if (arrayList.contains(object3)) {
                ((AbstractCollection)arrayList).remove(object3);
            } else {
                vcsCacheDir.addChildDir((CacheDir)object2, true);
            }
            if (object2 != vcsCacheDir.getSubDir((String)object3)) {
                object5 = (VcsCacheDir)vcsCacheDir.getSubDir((String)object3);
                ((CacheFile)object5).setStatus(((CacheFile)object2).getStatus());
                ((CacheFile)object5).setSticky(((CacheFile)object2).getSticky());
                ((CacheFile)object5).setLocker(((CacheFile)object2).getLocker());
                ((CacheFile)object5).setRevision(((CacheFile)object2).getRevision());
                ((CacheFile)object5).setSize(((CacheFile)object2).getSize());
                ((CacheFile)object5).setDate(((CacheFile)object2).getDate());
                ((CacheFile)object5).setTime(((CacheFile)object2).getTime());
                ((CacheFile)object5).setAttr(((CacheFile)object2).getAttr());
                ((CacheDir)object5).setLocal(false);
                cacheHandler.removeCacheLocker(object, (CacheFile)object2);
                object2 = object5;
                cacheHandler.addCacheLocker(object, (CacheFile)object2);
            }
            if ((object5 = (Integer)this.refreshStrategyWhenNonLocal.get(((CacheDir)object2).getAbsolutePath())) == null) continue;
            this.loadDir((CacheDir)object2, (Integer)object5, null);
        }
        if (arrayList.size() > 0) {
            int n = arrayList.size() - 1;
            while (n >= 0) {
                object4 = (String)arrayList.get(n);
                object3 = vcsCacheDir.getFile((String)object4);
                if (object3 != null) {
                    vcsCacheDir.removeFile((String)object4, true);
                } else {
                    object2 = vcsCacheDir.getSubDir((String)object4);
                    if (object2 != null) {
                        vcsCacheDir.removeChildDir((String)object4, true);
                    }
                }
                --n;
            }
            vcsCacheDir.refreshLocal(false);
        }
        vcsCacheDir.setLoaded(true);
        return vcsCacheDir;
    }

    private VcsCacheDir createSubFiles(VcsFileSystem vcsFileSystem, VcsDirContainer vcsDirContainer, Object object) {
        Hashtable hashtable = (Hashtable)vcsDirContainer.getElement();
        Collection<Object> collection = hashtable == null ? Collections.EMPTY_LIST : hashtable.values();
        CacheHandler cacheHandler = CacheHandler.getInstance();
        VcsCacheDir vcsCacheDir = this.createSubFiles(vcsFileSystem, vcsDirContainer.getPath(), collection, object);
        cacheHandler.addCacheLocker(object, vcsCacheDir);
        VcsDirContainer[] vcsDirContainerArray = vcsDirContainer.getSubdirContainers();
        int n = 0;
        while (n < vcsDirContainerArray.length) {
            VcsCacheDir vcsCacheDir2 = this.createSubFiles(vcsFileSystem, vcsDirContainerArray[n], object);
            vcsCacheDir.addChildDir(vcsCacheDir2, true);
            cacheHandler.addCacheLocker(object, vcsCacheDir2);
            ++n;
        }
        return vcsCacheDir;
    }

    public void readFileFinished(String string, Collection collection) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return;
        }
        VcsCacheDir vcsCacheDir = (VcsCacheDir)vcsFileSystem.getCacheProvider().getDir(string);
        if (vcsCacheDir == null) {
            vcsCacheDir = (VcsCacheDir)this.initCacheDir(vcsFileSystem.getFile(string));
            this.registerDir(vcsCacheDir);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CacheFile cacheFile;
            String[] stringArray = (String[])iterator.next();
            if (stringArray.length == 1) {
                cacheFile = vcsCacheDir.getFile(stringArray[0]);
                if (cacheFile != null) {
                    vcsCacheDir.removeFile(stringArray[0], true);
                    continue;
                }
                cacheFile = vcsCacheDir.getSubDir(stringArray[0]);
                if (cacheFile == null) continue;
                vcsCacheDir.removeChildDir(stringArray[0], true);
                continue;
            }
            cacheFile = RefreshCommandSupport.matchToExistingFile(stringArray, vcsFileSystem.getCacheIdStr(), vcsCacheDir.getFile());
            String string2 = cacheFile.getName();
            boolean bl = false;
            if (cacheFile instanceof VcsCacheFile && vcsCacheDir.getFile(string2) == null) {
                vcsCacheDir.addFile(cacheFile, true);
                bl = true;
            } else if (cacheFile instanceof VcsCacheDir && vcsCacheDir.getSubDir(string2) == null) {
                vcsCacheDir.addChildDir((CacheDir)cacheFile, true);
                bl = true;
            }
            if (bl) {
                this.fireCacheHandlerEvent(0, cacheFile);
                continue;
            }
            try {
                this.fireCacheHandlerEvent(2, cacheFile);
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                throw (UndeclaredThrowableException)ErrorManager.getDefault().annotate((Throwable)undeclaredThrowableException, "BAD cache file fired: " + cacheFile + ", it's parent = " + cacheFile.getParent() + ", dir = " + vcsCacheDir + ", registered dir for file '" + vcsCacheDir.getFile().getAbsolutePath() + "' = " + this.getDir(vcsCacheDir.getFile().getAbsolutePath()) + "\nPlease attach this text to issue #24340");
            }
        }
        vcsCacheDir.writeToDisk();
        this.heyDoRefreshDir(this.getPath(vcsCacheDir.getFile()));
    }

    public void readDirFinished(String string, Collection collection, boolean bl, Object object) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return;
        }
        String string2 = this.fsRoot + File.separatorChar + string.replace('/', File.separatorChar);
        if (!bl && collection.size() == 0) {
            CacheDir cacheDir = this.getDir(string2);
            if (cacheDir instanceof VcsCacheDir) {
                ((VcsCacheDir)cacheDir).setBeingLoaded(false);
                ((VcsCacheDir)cacheDir).setLoaded(true);
            }
            return;
        }
        VcsCacheDir vcsCacheDir = this.createSubFiles(vcsFileSystem, string, collection, object);
        this.registerDir(vcsCacheDir);
        vcsCacheDir.writeToDisk();
        vcsCacheDir.setBeingLoaded(false);
        this.fireCacheHandlerEvent(2, vcsCacheDir);
        this.heyDoRefreshDir(this.getPath(vcsCacheDir.getFile()));
    }

    public void readDirFinishedRecursive(String string, VcsDirContainer vcsDirContainer, boolean bl, Object object) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return;
        }
        String string2 = this.fsRoot + File.separatorChar + string.replace('/', File.separatorChar);
        VcsCacheDir vcsCacheDir = this.createSubFiles(vcsFileSystem, vcsDirContainer, object);
        this.registerDirRecursive(vcsCacheDir);
        vcsCacheDir.writeToDiskRecursively();
        this.fireCacheHandlerEvent(3, vcsCacheDir);
        this.heyDoRefreshDirRecursive(vcsCacheDir);
    }

    void createIgnoreList(VcsCacheDir vcsCacheDir, ArrayList arrayList) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return;
        }
        VcsFileSystem.IgnoreListSupport ignoreListSupport = vcsFileSystem.getIgnoreListSupport();
        vcsCacheDir.setIgnoreList(VcsUtilities.createIgnoreList(vcsCacheDir, this.getPath(vcsCacheDir.getFile()), ignoreListSupport));
    }

    private class DirReaderListenerWithLock
    implements DirReaderListener {
        private Object locker;

        public DirReaderListenerWithLock(Object object) {
            this.locker = object;
        }

        public void readDirFinished(String string, Collection collection, boolean bl) {
            VcsCache.this.readDirFinished(string, collection, bl, this.locker);
            this.locker = null;
        }

        public void readDirFinishedRecursive(String string, VcsDirContainer vcsDirContainer, boolean bl) {
            VcsCache.this.readDirFinishedRecursive(string, vcsDirContainer, bl, this.locker);
            this.locker = null;
        }
    }
}

