/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cmdline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.ExecuteCommand;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandListener;
import org.netbeans.modules.vcscore.commands.CommandsPool;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AdditionalCommandDialog
extends JDialog
implements Runnable,
CommandDataOutputListener {
    private Debug E;
    private Debug D;
    private JLabel label;
    private JScrollPane listScrollPane;
    private JButton stopButton;
    private JTextArea textArea;
    private VcsFileSystem fileSystem;
    private UserCommand uc;
    private Hashtable vars;
    private String exec;
    private boolean shouldStop;
    private Thread listUpdator;
    private ExecuteCommand runningCmd;
    private CommandsPool cPool;
    static final long serialVersionUID = 7828168693077944573L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$cmdline$AdditionalCommandDialog;

    public AdditionalCommandDialog(VcsFileSystem vcsFileSystem, UserCommand userCommand, Hashtable hashtable, Frame frame, boolean bl) {
        this(vcsFileSystem, userCommand, hashtable, frame, bl, null);
    }

    public AdditionalCommandDialog(VcsFileSystem vcsFileSystem, UserCommand userCommand, Hashtable hashtable, Frame frame, boolean bl, String string) {
        super(frame, bl);
        this.D = this.E = new Debug("AdditionalCommandDialog", true);
        this.fileSystem = null;
        this.uc = null;
        this.vars = null;
        this.exec = null;
        this.shouldStop = false;
        this.listUpdator = null;
        this.runningCmd = null;
        this.cPool = null;
        this.fileSystem = vcsFileSystem;
        this.cPool = vcsFileSystem.getCommandsPool();
        this.uc = userCommand;
        this.vars = hashtable;
        this.exec = string;
        this.initComponents();
        this.pack();
        HelpCtx.setHelpIDString((JComponent)this.getRootPane(), (String)(class$org$netbeans$modules$vcscore$cmdline$AdditionalCommandDialog == null ? (class$org$netbeans$modules$vcscore$cmdline$AdditionalCommandDialog = AdditionalCommandDialog.class$("org.netbeans.modules.vcscore.cmdline.AdditionalCommandDialog")) : class$org$netbeans$modules$vcscore$cmdline$AdditionalCommandDialog).getName());
    }

    private void initComponents() {
        ((Component)this).setBackground(new Color(192, 192, 192));
        this.setTitle(this.g("CTL_Command_output"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AdditionalCommandDialog.this.closeDialog();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.label = new JLabel();
        this.label.setText(this.g("CTL_Output_of_the_command", this.uc.getDisplayName()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.05;
        this.getContentPane().add((Component)this.label, gridBagConstraints);
        this.listScrollPane = new JScrollPane();
        this.listScrollPane.setPreferredSize(new Dimension(600, 400));
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setKeymap(null);
        this.listScrollPane.add(this.textArea);
        this.listScrollPane.setViewportView(this.textArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.9;
        this.getContentPane().add((Component)this.listScrollPane, gridBagConstraints);
        this.stopButton = new JButton();
        this.stopButton.setText(this.g("CTL_StopButtonLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.stopButton, gridBagConstraints);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdditionalCommandDialog.this.stopButtonPressed(actionEvent);
            }
        });
    }

    private void stopButtonPressed(ActionEvent actionEvent) {
        if (this.runningCmd != null || !this.cPool.isRunning(this.runningCmd)) {
            this.closeDialog();
        } else if (NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)this.g("DLG_ReallyKillCmd"), 0)))) {
            this.cPool.kill(this.runningCmd);
            this.closeDialog();
        }
    }

    private void closeDialog() {
        this.shouldStop = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void scrollDown() {
        int n = this.textArea.getSize().height - this.listScrollPane.getSize().height;
        this.D.deb("scrollDown(): height = " + this.textArea.getSize().height + " - " + this.listScrollPane.getSize().height + " = " + n);
        if (n < 0) {
            n = 0;
        }
        this.listScrollPane.getViewport().setViewPosition(new Point(0, n));
    }

    private void printMessage(String string) {
        String[] stringArray = new String[]{" ", "  ", "   ", "    ", "     ", "      ", "       ", "        "};
        int n = string.indexOf(9, 0);
        while ((n = string.indexOf(9, n)) > 0) {
            String string2 = string.substring(0, n);
            int n2 = 7 - (n - string2.lastIndexOf(10) - 1) % 8;
            string = string2 + stringArray[n2] + string.substring(n + 1);
        }
        String string3 = string;
        this.textArea.append(string3 + "\n");
        if (this.listUpdator == null || !this.listUpdator.isAlive()) {
            this.listUpdator = new ListUpdator(this.textArea);
            this.listUpdator.start();
            Thread.yield();
        }
    }

    public void outputData(String[] stringArray) {
        this.printMessage(VcsUtilities.arrayToSpaceSeparatedString(stringArray));
    }

    public ExecuteCommand getExecuteCommand() {
        this.createCommand();
        return this.runningCmd;
    }

    public ExecuteCommand createCommand() {
        String string = this.g("MSG_Executing_additional_command", this.uc.getDisplayName());
        this.fileSystem.debug(this.uc.getName() + ": " + string);
        ExecuteCommand executeCommand = this.exec == null ? new ExecuteCommand(this.fileSystem, this.uc, this.vars) : new ExecuteCommand(this.fileSystem, this.uc, this.vars, this.exec);
        this.runningCmd = executeCommand;
        executeCommand.addDataOutputListener(this);
        executeCommand.addDataErrorOutputListener(this);
        this.cPool.addCommandListener(new CommandListener(){

            public void commandPreprocessing(VcsCommandExecutor vcsCommandExecutor) {
            }

            public void commandPreprocessed(VcsCommandExecutor vcsCommandExecutor, boolean bl) {
            }

            public void commandStarted(VcsCommandExecutor vcsCommandExecutor) {
                if (vcsCommandExecutor.equals(AdditionalCommandDialog.this.runningCmd)) {
                    AdditionalCommandDialog.this.show();
                }
            }

            public void commandDone(VcsCommandExecutor vcsCommandExecutor) {
                if (vcsCommandExecutor.equals(AdditionalCommandDialog.this.runningCmd)) {
                    Runnable runnable = new Runnable(this){
                        private final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            4.access$600(this.this$1).run();
                        }
                    };
                    new Thread(runnable, "ExecuteCommand Display Thread").start();
                }
            }

            static /* synthetic */ AdditionalCommandDialog access$600(4 var0) {
                return var0.AdditionalCommandDialog.this;
            }
        });
        return executeCommand;
    }

    public void run() {
        ExecuteCommand executeCommand = this.runningCmd;
        if (this.shouldStop) {
            String string = this.g("MSG_User_interrupt");
            this.printMessage(">" + string);
            this.fileSystem.debug(this.uc.getName() + ": " + string);
            return;
        }
        String string = executeCommand.getExitStatus() == 0 ? this.g("MSG_Command_finished") : this.g("MSG_Command_failed");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AdditionalCommandDialog.this.stopButton.setText(AdditionalCommandDialog.this.g("CTL_CloseButtonLabel"));
                AdditionalCommandDialog.this.getRootPane().setDefaultButton(AdditionalCommandDialog.this.stopButton);
            }
        });
        this.printMessage(">" + string);
        new ListUpdator(this.textArea).start();
    }

    String g(String string) {
        return NbBundle.getBundle((String)"org.netbeans.modules.vcscore.cmdline.Bundle").getString(string);
    }

    String g(String string, Object object) {
        return MessageFormat.format(this.g(string), object);
    }

    String g(String string, Object object, Object object2) {
        return MessageFormat.format(this.g(string), object, object2);
    }

    String g(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(this.g(string), object, object2, object3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$300(AdditionalCommandDialog additionalCommandDialog) {
        additionalCommandDialog.scrollDown();
    }

    class ListUpdator
    extends Thread {
        private JTextArea textArea;

        ListUpdator(JTextArea jTextArea) {
            this.textArea = jTextArea;
        }

        public void run() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(this){
                    private final /* synthetic */ ListUpdator this$1;
                    {
                        this.this$1 = listUpdator;
                    }

                    public void run() {
                        AdditionalCommandDialog.access$300(ListUpdator.access$200(this.this$1));
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                AdditionalCommandDialog.this.E.deb("List Updator Interrupted");
            }
            catch (InvocationTargetException invocationTargetException) {
                AdditionalCommandDialog.this.E.deb("List Updator throwed InvocationTargetException " + invocationTargetException.getMessage());
            }
        }

        static /* synthetic */ AdditionalCommandDialog access$200(ListUpdator listUpdator) {
            return listUpdator.AdditionalCommandDialog.this;
        }
    }
}

