/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.revision;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.beans.FeatureDescriptor;
import java.beans.PropertyVetoException;
import java.io.ObjectStreamException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.vcscore.revision.RevisionChildren;
import org.netbeans.modules.vcscore.revision.RevisionNode;
import org.netbeans.modules.vcscore.util.TopComponentCloseListener;
import org.openide.TopManager;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class RevisionExplorer {
    private static final String MODE_NAME = "RevisionExplorer";
    private static final String ICON_ROOT = "org/openide/resources/defaultFolder";
    private Panel panel;
    private Node root = null;

    private RevisionExplorer(Node node) {
        this.root = node;
        this.panel = new Panel();
        this.panel.setName(node.getDisplayName());
        this.panel.getExplorerManager().setRootContext(node);
        this.initComponents();
    }

    public static Panel getRevisionExplorer(RevisionNode revisionNode, String string) {
        return RevisionExplorer.getRevisionExplorer(revisionNode, string, null);
    }

    public static Panel getRevisionExplorer(RevisionNode revisionNode, String string, Image image) {
        Object object;
        Children.Array array;
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)((RevisionChildren)revisionNode.getChildren()).getList().getFileObject());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObject = null;
        }
        Workspace workspace = TopManager.getDefault().getWindowManager().getCurrentWorkspace();
        Mode mode = workspace.findMode(MODE_NAME);
        if (mode != null) {
            array = mode.getTopComponents();
            int n = 0;
            while (n < ((Children.Array)array).length) {
                object = (Panel)array[n];
                Node node = object.getExplorerManager().getRootContext();
                DataObject dataObject2 = null;
                if (node instanceof DataNode) {
                    dataObject2 = ((DataNode)node).getDataObject();
                }
                if (dataObject != null && dataObject.equals(dataObject2)) {
                    Children.Array array2 = (Children.Array)node.getChildren();
                    array2.remove(new Node[]{array2.findChild(((FeatureDescriptor)((Object)revisionNode)).getName())});
                    array2.add(new Node[]{revisionNode});
                    return object;
                }
                ++n;
            }
        }
        array = new Children.Array();
        array.add(new Node[]{revisionNode});
        DataNode dataNode = null;
        if (dataObject != null) {
            dataNode = new DataNode(dataObject, (Children)array);
        }
        if (dataNode == null) {
            dataNode = new AbstractNode((Children)array);
            dataNode.setDisplayName(string);
        }
        dataNode.setIconBase(ICON_ROOT);
        object = new RevisionExplorer((Node)dataNode);
        return ((RevisionExplorer)object).panel;
    }

    private void initComponents() {
        PropertySheetView propertySheetView = new PropertySheetView();
        try {
            propertySheetView.setSortingMode(0);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        SplittedPanel splittedPanel = new SplittedPanel();
        splittedPanel.setSplitType(2);
        splittedPanel.add((Component)new BeanTreeView(), SplittedPanel.ADD_LEFT);
        splittedPanel.add((Component)propertySheetView, SplittedPanel.ADD_RIGHT);
        ((Container)((Object)this.panel)).add((Component)splittedPanel);
    }

    public static class Panel
    extends ExplorerPanel {
        private transient ArrayList closeListeners = new ArrayList();
        private static final long serialVersionUID = 4299110182628710910L;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$revision$RevisionExplorer;

        Panel() {
        }

        public void open(Workspace workspace) {
            Mode mode = workspace.findMode((TopComponent)this);
            if (mode == null) {
                String string = NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$revision$RevisionExplorer == null ? (class$org$netbeans$modules$vcscore$revision$RevisionExplorer = Panel.class$("org.netbeans.modules.vcscore.revision.RevisionExplorer")) : class$org$netbeans$modules$vcscore$revision$RevisionExplorer), (String)"CTL_Explorer.title");
                mode = workspace.createMode(RevisionExplorer.MODE_NAME, string, null);
                mode.dockInto((TopComponent)this);
            }
            super.open(workspace);
        }

        public boolean canClose(Workspace workspace, boolean bl) {
            boolean bl2 = super.canClose(workspace, bl);
            if (bl && bl2) {
                this.closing();
            }
            return bl2;
        }

        public void addCloseListener(TopComponentCloseListener topComponentCloseListener) {
            this.closeListeners.add(topComponentCloseListener);
        }

        private void closing() {
            if (this.closeListeners != null) {
                Iterator iterator = ((AbstractList)this.closeListeners).iterator();
                while (iterator.hasNext()) {
                    ((TopComponentCloseListener)iterator.next()).closing();
                }
                this.closeListeners = new ArrayList();
            }
        }

        protected void updateTitle() {
            this.setName(this.getExplorerManager().getRootContext().getDisplayName());
        }

        protected Object writeReplace() throws ObjectStreamException {
            this.closing();
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

