/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views;

import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.vcscore.ui.views.ChildrenInfoFilter;
import org.netbeans.modules.vcscore.ui.views.FileInfoNode;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfo;
import org.netbeans.modules.vcscore.versioning.VersioningRepository;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;

public class FileVcsInfoChildren
extends Children.Keys {
    private boolean filteredListCreated = false;
    private boolean addNotifyCalled = false;
    private List keyList = Collections.synchronizedList(new ArrayList());
    private ChildrenInfoFilter filter;
    private List filteredList = new ArrayList();
    private WeakSet weakNodesSet = new WeakSet();

    protected void addNotify() {
        if (!this.filteredListCreated) {
            Collections.sort(this.keyList, new FileVcsInfoComparator());
            this.createFilteredList();
        }
        this.setFilteredKeys();
        this.addNotifyCalled = true;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
        this.addNotifyCalled = false;
        this.filteredListCreated = false;
        this.filteredList.clear();
    }

    public void updateFilter() {
        if (this.filteredListCreated) {
            Collections.sort(this.keyList, new FileVcsInfoComparator());
            this.createFilteredList();
            if (this.addNotifyCalled) {
                this.setFilteredKeys();
            }
        }
    }

    private List createFilteredList() {
        List list = this.filteredList;
        list.clear();
        Iterator iterator = this.keyList.iterator();
        while (iterator.hasNext()) {
            FileVcsInfo fileVcsInfo = (FileVcsInfo)iterator.next();
            if (this.filter != null) {
                if (!this.filter.checkFileInfo(fileVcsInfo)) continue;
                list.add(fileVcsInfo);
                continue;
            }
            list.add(fileVcsInfo);
        }
        this.filteredListCreated = true;
        return list;
    }

    private void setFilteredKeys() {
        this.setKeys(this.filteredList);
    }

    public void addKey(FileVcsInfo fileVcsInfo) {
        this.keyList.add(fileVcsInfo);
        this.updateFilter();
    }

    public void removeKey(FileVcsInfo fileVcsInfo) {
        this.keyList.remove(fileVcsInfo);
        this.filteredList.remove(fileVcsInfo);
        this.updateFilter();
    }

    public FileVcsInfo findKeyByFileName(String string) {
        ArrayList arrayList = new ArrayList(this.keyList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FileVcsInfo fileVcsInfo = (FileVcsInfo)iterator.next();
            if (!string.equals(fileVcsInfo.getFile().getName())) continue;
            return fileVcsInfo;
        }
        return null;
    }

    public Iterator getAllKeys() {
        ArrayList arrayList = new ArrayList(this.keyList);
        return arrayList.iterator();
    }

    public Iterator getFilteredKeys() {
        if (!this.filteredListCreated) {
            Collections.sort(this.keyList, new FileVcsInfoComparator());
            this.createFilteredList();
        }
        return ((AbstractList)new ArrayList(this.filteredList)).iterator();
    }

    public int getTotalKeyCount() {
        return this.keyList.size();
    }

    public int getFilteredKeyCount() {
        return this.filteredList.size();
    }

    void setChildrenNodesFilter(ChildrenInfoFilter childrenInfoFilter) {
        this.filter = childrenInfoFilter;
        if (this.filteredListCreated) {
            this.updateFilter();
        }
    }

    public void refreshThisKey(Object object) {
        super.refreshKey(object);
    }

    protected Node[] createNodes(Object object) {
        if (!(object instanceof FileVcsInfo)) {
            return new Node[0];
        }
        FileVcsInfo fileVcsInfo = (FileVcsInfo)object;
        DataObject dataObject = FileVcsInfoChildren.findVersioningDO(fileVcsInfo);
        if (dataObject != null) {
            FileInfoNode fileInfoNode = null;
            if (!fileVcsInfo.getChildren().equals(Children.LEAF)) {
                fileVcsInfo.replaceChildrenWithClone();
                fileInfoNode = new FileInfoNode(dataObject, fileVcsInfo);
            } else {
                fileInfoNode = new FileInfoNode(dataObject, fileVcsInfo);
            }
            return new Node[]{fileInfoNode};
        }
        if (!fileVcsInfo.getChildren().equals(Children.LEAF)) {
            fileVcsInfo.replaceChildrenWithClone();
        }
        FileInfoNode fileInfoNode = new FileInfoNode((Node)new DummyNode(fileVcsInfo), fileVcsInfo);
        return new Node[]{fileInfoNode};
    }

    static DataObject findVersioningDO(FileVcsInfo fileVcsInfo) {
        VersioningRepository versioningRepository = VersioningRepository.getRepository();
        File file = fileVcsInfo.getFile();
        if (file != null) {
            try {
                String string = file.getCanonicalPath();
                File file2 = file.getCanonicalFile();
                List list = versioningRepository.getVersioningFileSystems();
                FileSystem fileSystem = null;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    File file3;
                    String string2;
                    File file4;
                    fileSystem = (FileSystem)iterator.next();
                    if (fileSystem == null || (file4 = FileUtil.toFile((FileObject)fileSystem.getRoot())) == null || string.indexOf(string2 = file4.getCanonicalPath()) != 0) continue;
                    String string3 = string.substring(string2.length()).replace(File.separatorChar, '/');
                    FileObject fileObject = fileSystem.findResource(string3);
                    File file5 = file3 = fileObject != null ? FileUtil.toFile((FileObject)fileObject) : null;
                    if (fileObject == null || file3 == null || !file2.equals(file3.getCanonicalFile())) continue;
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObject);
                        return dataObject;
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        dataObjectNotFoundException.printStackTrace();
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public Object clone() {
        FileVcsInfoChildren fileVcsInfoChildren = new FileVcsInfoChildren();
        fileVcsInfoChildren.initialize(this.keyList, this.filter, this.filteredList, this.filteredListCreated);
        return fileVcsInfoChildren;
    }

    void initialize(List list, ChildrenInfoFilter childrenInfoFilter, List list2, boolean bl) {
        this.keyList = list;
        this.filter = childrenInfoFilter;
        this.filteredListCreated = this.filteredListCreated;
        this.filteredList = list2;
    }

    private static class DummyNode
    extends AbstractNode {
        private FileVcsInfo info;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;

        public DummyNode(FileVcsInfo fileVcsInfo) {
            super(fileVcsInfo.getChildren());
            this.info = fileVcsInfo;
            this.setName(fileVcsInfo.getFile().getName());
        }

        public Node.Cookie getCookie(Class clazz) {
            if (clazz.equals(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = DummyNode.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo)) {
                return this.info;
            }
            return super.getCookie(clazz);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class FileVcsInfoComparator
    implements Comparator {
        private FileVcsInfoComparator() {
        }

        public int compare(Object object, Object object2) {
            FileVcsInfo fileVcsInfo = (FileVcsInfo)object;
            FileVcsInfo fileVcsInfo2 = (FileVcsInfo)object2;
            if (fileVcsInfo.getFile().isDirectory() && !fileVcsInfo2.getFile().isDirectory()) {
                return -1;
            }
            if (!fileVcsInfo.getFile().isDirectory() && fileVcsInfo2.getFile().isDirectory()) {
                return 1;
            }
            return fileVcsInfo.getFile().compareTo(fileVcsInfo2.getFile());
        }
    }
}

