/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.ui.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfo;
import org.netbeans.modules.vcscore.ui.views.FileVcsInfoChildren;
import org.netbeans.modules.vcscore.util.table.ColumnSortListener;
import org.netbeans.modules.vcscore.util.table.TableInfoModel;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public class NodesTableView
extends JScrollPane
implements Externalizable {
    static final long serialVersionUID = 0L;
    private transient ExplorerManager manager;
    protected transient JTable table;
    protected transient TableInfoModel model;
    transient Listener managerListener;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient PopupAdapter popupListener;
    transient TableNodeListener nodeListener;
    private boolean popupAllowed = true;
    private boolean traversalAllowed = true;
    private ActionListener defaultProcessor;
    transient boolean listenerActive;
    private String compositeAttributeName;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;

    public NodesTableView(TableInfoModel tableInfoModel) {
        this.model = tableInfoModel;
        this.initializeTable();
    }

    private void initializeTable() {
        this.table = this.createTable();
        this.table.setModel(this.model);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setUpdateTableInRealTime(true);
        ColumnSortListener columnSortListener = new ColumnSortListener(this.table);
        jTableHeader.addMouseListener(columnSortListener);
        this.setViewportView(this.table);
        this.managerListener = new Listener();
        this.popupListener = new PopupAdapter();
        this.nodeListener = new TableNodeListener();
        this.model.addTableModelListener(this.managerListener);
        this.table.addMouseListener(this.managerListener);
        this.table.addMouseListener((MouseListener)((Object)this.popupListener));
        this.table.getSelectionModel().setSelectionMode(2);
        ToolTipManager.sharedInstance().registerComponent(this.table);
        this.table.addFocusListener(new FocusAdapter());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(new Boolean(this.popupAllowed));
        objectOutput.writeObject(new Boolean(this.traversalAllowed));
        objectOutput.writeObject(this.compositeAttributeName);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.popupAllowed = (Boolean)objectInput.readObject();
        this.traversalAllowed = (Boolean)objectInput.readObject();
        this.compositeAttributeName = objectInput.readUTF();
    }

    public boolean isPopupAllowed() {
        return this.popupAllowed;
    }

    public void setPopupAllowed(boolean bl) {
        this.popupAllowed = bl;
    }

    public boolean isTraversalAllowed() {
        return false;
    }

    public void setTraversalAllowed(boolean bl) {
        this.traversalAllowed = bl;
    }

    public ActionListener getDefaultProcessor() {
        return this.defaultProcessor;
    }

    public void setDefaultProcessor(ActionListener actionListener) {
        this.defaultProcessor = actionListener;
    }

    public int getSelectionMode() {
        return this.table.getSelectionModel().getSelectionMode();
    }

    public boolean isDragSource() {
        return false;
    }

    public void setDragSource(boolean bl) {
    }

    public boolean isDropTarget() {
        return false;
    }

    public void setDropTarget(boolean bl) {
    }

    protected JTable createTable() {
        NbTable nbTable = new NbTable();
        return nbTable;
    }

    public TableInfoModel getTableModel() {
        return this.model;
    }

    protected void selectionChanged(Node[] nodeArray, ExplorerManager explorerManager) throws PropertyVetoException {
        explorerManager.setSelectedNodes(nodeArray);
    }

    protected boolean selectionAccept(Node[] nodeArray) {
        return true;
    }

    private void fillModelWithData(FileVcsInfo fileVcsInfo) {
        Children children = fileVcsInfo.getChildren();
        if (!children.equals(Children.LEAF)) {
            Iterator iterator = ((FileVcsInfoChildren)children).getFilteredKeys();
            while (iterator.hasNext()) {
                FileVcsInfo fileVcsInfo2 = (FileVcsInfo)iterator.next();
                if (fileVcsInfo2 != null && !fileVcsInfo2.getType().startsWith("BLANK")) {
                    this.model.addElement(fileVcsInfo2);
                }
                if (Children.LEAF.equals(fileVcsInfo2.getChildren())) continue;
                this.fillModelWithData(fileVcsInfo2);
            }
        }
    }

    private void clearModel() {
        this.model.clear();
    }

    public void addNotify() {
        FileVcsInfo fileVcsInfo;
        super.addNotify();
        ExplorerManager explorerManager = ExplorerManager.find((Component)this);
        if (explorerManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListener.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.clearModel();
            fileVcsInfo = (FileVcsInfo)this.manager.getRootContext().getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = NodesTableView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
            if (fileVcsInfo != null) {
                this.fillModelWithData(fileVcsInfo);
            }
        }
        if (!this.listenerActive) {
            this.listenerActive = true;
            this.table.getSelectionModel().addListSelectionListener(this.managerListener);
            if (this.manager != null && (fileVcsInfo = (FileVcsInfo)this.manager.getRootContext().getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = NodesTableView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo)) != null) {
                fileVcsInfo.addPropertyChangeListener(this.managerListener);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.listenerActive = false;
        this.table.getSelectionModel().removeListSelectionListener(this.managerListener);
        FileVcsInfo fileVcsInfo = (FileVcsInfo)this.manager.getRootContext().getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = NodesTableView.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
        if (fileVcsInfo != null) {
            fileVcsInfo.removePropertyChangeListener(this.managerListener);
        }
    }

    public void requestFocus() {
        this.table.requestFocus();
    }

    final void performObjectAt(int n, int n2) {
        if (n < 0 || n >= this.model.getRowCount()) {
            return;
        }
    }

    void createPopup(int n, int n2) {
        if (this.manager == null) {
            return;
        }
        if (!this.popupAllowed) {
            return;
        }
        JPopupMenu jPopupMenu = NodeOp.findContextMenu((Node[])this.manager.getSelectedNodes());
        if (jPopupMenu != null && jPopupMenu.getSubElements().length > 0) {
            Point point = this.getViewport().getViewPosition();
            point.x = n - point.x;
            point.y = n2 - point.y;
            SwingUtilities.convertPointToScreen(point, this);
            Dimension dimension = jPopupMenu.getPreferredSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            if (point.x + dimension.width > dimension2.width) {
                point.x = dimension2.width - dimension.width;
            }
            if (point.y + dimension.height > dimension2.height) {
                point.y = dimension2.height - dimension.height;
            }
            SwingUtilities.convertPointFromScreen(point, this);
            jPopupMenu.show(this, point.x, point.y);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class Listener
    extends MouseAdapter
    implements TableModelListener,
    ListSelectionListener,
    PropertyChangeListener,
    VetoableChangeListener {
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;

        private Listener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                // empty if block
            }
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            NodesTableView.this.manager;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && !NodesTableView.this.selectionAccept(nodeArray = (Node[])propertyChangeEvent.getNewValue())) {
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FileVcsInfo fileVcsInfo;
            NodesTableView.this.manager;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() != null) {
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                List list = NodesTableView.this.model.getList();
                NodesTableView.this.table.getSelectionModel().clearSelection();
                NodesTableView.this.table.getSelectionModel().setSelectionMode(2);
                NodesTableView.this.table.getSelectionModel().setValueIsAdjusting(true);
                int n = 0;
                while (n < nodeArray.length) {
                    FileVcsInfo fileVcsInfo2 = (FileVcsInfo)nodeArray[n].getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? Listener.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo") : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
                    int n2 = list.indexOf(fileVcsInfo2);
                    if (n2 >= 0 && !NodesTableView.this.table.getSelectionModel().isSelectedIndex(n2)) {
                        NodesTableView.this.table.getSelectionModel().addSelectionInterval(n2, n2);
                    }
                    ++n;
                }
                NodesTableView.this.table.getSelectionModel().setValueIsAdjusting(false);
                return;
            }
            if ("exploredContext".equals(propertyChangeEvent.getPropertyName())) {
                return;
            }
            if ("FILTER_UPDATED".equals(propertyChangeEvent.getPropertyName()) && (fileVcsInfo = (FileVcsInfo)NodesTableView.this.manager.getRootContext().getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = Listener.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo)) != null) {
                NodesTableView.this.clearModel();
                NodesTableView.this.fillModelWithData(fileVcsInfo);
                NodesTableView.this.model.fireTableDataChanged();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = NodesTableView.this.table.getSelectedRows();
            Node[] nodeArray = new Node[nArray.length];
            int n = 0;
            while (n < nodeArray.length) {
                FileVcsInfo fileVcsInfo = (FileVcsInfo)NodesTableView.this.model.getElementAt(nArray[n]);
                String string = (String)fileVcsInfo.getAttribute("NODE_PATH");
                string = string == null || string.length() == 0 ? fileVcsInfo.getFile().getName() : string + "/" + fileVcsInfo.getFile().getName();
                try {
                    Node node;
                    nodeArray[n] = node = NodeOp.findPath((Node)NodesTableView.this.manager.getRootContext(), (Enumeration)new StringTokenizer(string, "/"));
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    TopManager.getDefault().getErrorManager().notify((Throwable)nodeNotFoundException);
                }
                ++n;
            }
            NodesTableView.this.manager.removePropertyChangeListener(NodesTableView.this.wlpc);
            NodesTableView.this.manager.removeVetoableChangeListener(NodesTableView.this.wlvc);
            try {
                try {
                    NodesTableView.this.selectionChanged(nodeArray, NodesTableView.this.manager);
                }
                catch (PropertyVetoException propertyVetoException) {
                    Object var9_11 = null;
                    NodesTableView.this.manager.addPropertyChangeListener(NodesTableView.this.wlpc);
                    NodesTableView.this.manager.addVetoableChangeListener(NodesTableView.this.wlvc);
                    return;
                }
                Object var9_10 = null;
                NodesTableView.this.manager.addPropertyChangeListener(NodesTableView.this.wlpc);
                NodesTableView.this.manager.addVetoableChangeListener(NodesTableView.this.wlvc);
                return;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                NodesTableView.this.manager.addPropertyChangeListener(NodesTableView.this.wlpc);
                NodesTableView.this.manager.addVetoableChangeListener(NodesTableView.this.wlvc);
                throw throwable;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    final class FocusAdapter
    implements FocusListener {
        CallbackSystemAction csa;
        PopupPerformer performer;
        static /* synthetic */ Class class$org$openide$ErrorManager;

        FocusAdapter() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.csa == null) {
                try {
                    Class<?> clazz = Class.forName("org.openide.actions.PopupAction");
                    this.csa = (CallbackSystemAction)SystemAction.get(clazz);
                    this.performer = new PopupPerformer();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError();
                    ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = FocusAdapter.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                    if (errorManager != null) {
                        errorManager.annotate((Throwable)noClassDefFoundError, (Throwable)classNotFoundException);
                    }
                    throw noClassDefFoundError;
                }
            }
            this.csa.setActionPerformer((ActionPerformer)this.performer);
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupPerformer) {
                this.csa.setActionPerformer(null);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    final class PopupPerformer
    implements ActionPerformer {
        PopupPerformer() {
        }

        public void performAction(SystemAction systemAction) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n;
                    ListSelectionModel listSelectionModel = ((PopupPerformer)this).NodesTableView.this.table.getSelectionModel();
                    boolean bl = listSelectionModel.getSelectionMode() != 0;
                    int n2 = n = bl ? listSelectionModel.getLeadSelectionIndex() : listSelectionModel.getLeadSelectionIndex();
                    if (n < 0) {
                        return;
                    }
                    Rectangle rectangle = ((PopupPerformer)this).NodesTableView.this.table.getCellRect(((PopupPerformer)this).NodesTableView.this.table.getSelectedRow(), ((PopupPerformer)this).NodesTableView.this.table.getSelectedColumn(), false);
                    Point point = rectangle.getLocation();
                    if (point == null) {
                        return;
                    }
                    NodesTableView.this.createPopup(point.x, point.y);
                }
            });
        }
    }

    private final class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        private PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            int n = NodesTableView.this.table.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            NodesTableView.this.createPopup(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    final class NbTable
    extends JTable {
        static final long serialVersionUID = 0L;

        NbTable() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (mouseEvent != null) {
                Object object;
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n >= 0 && n2 >= 0 && (object = NodesTableView.this.model.getValueAt(n, n2)) != null) {
                    return object.toString();
                }
            }
            return null;
        }
    }

    private class TableNodeListener
    extends NodeAdapter {
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo;

        private TableNodeListener() {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            super.nodeDestroyed(nodeEvent);
            FileVcsInfo fileVcsInfo = (FileVcsInfo)nodeEvent.getNode().getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? (class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo = TableNodeListener.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo")) : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
            NodesTableView.this.model.removeElement(fileVcsInfo);
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            super.childrenRemoved(nodeMemberEvent);
            Node[] nodeArray = nodeMemberEvent.getDelta();
            int n = 0;
            while (n < nodeArray.length) {
                FileVcsInfo fileVcsInfo = (FileVcsInfo)nodeArray[n].getCookie(class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo == null ? TableNodeListener.class$("org.netbeans.modules.vcscore.ui.views.FileVcsInfo") : class$org$netbeans$modules$vcscore$ui$views$FileVcsInfo);
                NodesTableView.this.model.removeElement(fileVcsInfo);
                ++n;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

