/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.util;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.netbeans.modules.vcscore.util.TopComponentCloseListener;
import org.openide.text.CloneableEditorSupport;
import org.openide.windows.CloneableOpenSupport;

public class FileEditorSupport
extends CloneableEditorSupport {
    private File file;
    private FileEnvironment env;

    public FileEditorSupport(File file, FileEnvironment fileEnvironment) {
        super((CloneableEditorSupport.Env)fileEnvironment);
        fileEnvironment.setFileEditorSupport(this);
        this.file = file;
        this.env = fileEnvironment;
    }

    public void addCloseListener(TopComponentCloseListener topComponentCloseListener) {
        this.env.addCloseListener(topComponentCloseListener);
    }

    public String messageName() {
        return this.file.getName();
    }

    public String messageOpened() {
        return null;
    }

    public String messageOpening() {
        return null;
    }

    public String messageSave() {
        return "";
    }

    public String messageToolTip() {
        return "";
    }

    protected boolean canClose() {
        boolean bl = super.canClose();
        if (bl) {
            Iterator iterator = ((AbstractList)this.env.getCloseListeners()).iterator();
            while (iterator.hasNext()) {
                ((TopComponentCloseListener)iterator.next()).closing();
            }
        }
        return bl;
    }

    public static class FileEnvironment
    implements CloneableEditorSupport.Env {
        private File file;
        private String mimeType;
        private ArrayList closeListeners = new ArrayList();
        private transient FileEditorSupport editorSupport = null;
        static final long serialVersionUID = 2366777428924127835L;

        public FileEnvironment(File file, String string) {
            this.file = file;
            this.mimeType = string;
        }

        void addCloseListener(TopComponentCloseListener topComponentCloseListener) {
            this.closeListeners.add(topComponentCloseListener);
        }

        ArrayList getCloseListeners() {
            return this.closeListeners;
        }

        void setFileEditorSupport(FileEditorSupport fileEditorSupport) {
            this.editorSupport = fileEditorSupport;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public Date getTime() {
            return new Date(this.file.lastModified());
        }

        public InputStream inputStream() throws IOException {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException(fileNotFoundException.getMessage());
            }
            return fileInputStream;
        }

        public OutputStream outputStream() throws IOException {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IOException(fileNotFoundException.getMessage());
            }
            return fileOutputStream;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            if (this.editorSupport != null) {
                return this.editorSupport;
            }
            if (this.file.exists()) {
                return new FileEditorSupport(this.file, this);
            }
            return null;
        }

        public boolean isModified() {
            return false;
        }

        public boolean isValid() {
            return this.editorSupport != null;
        }

        public void markModified() throws IOException {
            throw new IOException();
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        }

        public void unmarkModified() {
        }
    }
}

