/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.versioning;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.VersioningRepositoryEvent;
import org.netbeans.modules.vcscore.versioning.VersioningRepositoryListener;
import org.openide.util.Lookup;

public final class VersioningRepository
implements Serializable {
    private static VersioningRepository repository;
    private ArrayList verSystems;
    private ArrayList verSystemsCopy;
    private Hashtable names;
    private transient EventListenerList listenerList = new EventListenerList();
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("systemName")) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = (String)propertyChangeEvent.getNewValue();
                VersioningFileSystem versioningFileSystem = (VersioningFileSystem)propertyChangeEvent.getSource();
                1 var5_5 = this;
                synchronized (var5_5) {
                    VersioningRepository.this.names.remove(string);
                    VersioningRepository.this.names.put(string2, versioningFileSystem);
                }
            }
        }
    };
    private static final long serialVersionUID = 8047724018983158285L;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$VersioningRepository;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener;

    private VersioningRepository() {
        this.verSystems = new ArrayList();
        this.names = new Hashtable();
    }

    public static VersioningRepository getRepository() {
        if (repository == null) {
            VersioningRepository.initRepository();
        }
        return repository;
    }

    private static synchronized void initRepository() {
        if (repository != null) {
            return;
        }
        Lookup lookup = Lookup.getDefault();
        repository = (VersioningRepository)lookup.lookup(class$org$netbeans$modules$vcscore$versioning$VersioningRepository == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningRepository = VersioningRepository.class$("org.netbeans.modules.vcscore.versioning.VersioningRepository")) : class$org$netbeans$modules$vcscore$versioning$VersioningRepository);
        if (repository == null) {
            repository = new VersioningRepository();
        }
    }

    public final void addVersioningFileSystem(VersioningFileSystem versioningFileSystem) {
        boolean bl;
        VersioningRepository versioningRepository = this;
        synchronized (versioningRepository) {
            String string = versioningFileSystem.getSystemName();
            if (!this.names.containsKey(string)) {
                this.verSystems.add(versioningFileSystem);
                this.verSystemsCopy = new ArrayList(this.verSystems);
                this.names.put(string, versioningFileSystem);
                versioningFileSystem.addPropertyChangeListener(this.propListener);
                bl = true;
                versioningFileSystem.addNotify();
            } else {
                bl = false;
            }
        }
        if (bl) {
            this.fireVerSystem(versioningFileSystem, true);
        }
    }

    public final void removeVersioningFileSystem(VersioningFileSystem versioningFileSystem) {
        boolean bl;
        VersioningRepository versioningRepository = this;
        synchronized (versioningRepository) {
            String string = versioningFileSystem.getSystemName();
            if (this.names.containsKey(string)) {
                ((AbstractCollection)this.verSystems).remove(versioningFileSystem);
                this.verSystemsCopy = new ArrayList(this.verSystems);
                this.names.remove(string);
                bl = true;
                versioningFileSystem.removePropertyChangeListener(this.propListener);
                versioningFileSystem.removeNotify();
            } else {
                bl = false;
            }
        }
        if (bl) {
            this.fireVerSystem(versioningFileSystem, false);
        }
    }

    public final List getVersioningFileSystems() {
        ArrayList arrayList = new ArrayList(this.verSystems);
        return arrayList;
    }

    public final synchronized VersioningFileSystem getSystem(String string) {
        return (VersioningFileSystem)this.names.get(string);
    }

    public void addRepositoryListener(VersioningRepositoryListener versioningRepositoryListener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.add(class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener = VersioningRepository.class$("org.netbeans.modules.vcscore.versioning.VersioningRepositoryListener")) : class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener, versioningRepositoryListener);
        }
    }

    public void removeRepositoryListener(VersioningRepositoryListener versioningRepositoryListener) {
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            this.listenerList.remove(class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener = VersioningRepository.class$("org.netbeans.modules.vcscore.versioning.VersioningRepositoryListener")) : class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener, versioningRepositoryListener);
        }
    }

    private void fireVerSystem(VersioningFileSystem versioningFileSystem, boolean bl) {
        VersioningRepositoryListener[] versioningRepositoryListenerArray;
        EventListenerList eventListenerList = this.listenerList;
        synchronized (eventListenerList) {
            versioningRepositoryListenerArray = (VersioningRepositoryListener[])this.listenerList.getListeners(class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener == null ? (class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener = VersioningRepository.class$("org.netbeans.modules.vcscore.versioning.VersioningRepositoryListener")) : class$org$netbeans$modules$vcscore$versioning$VersioningRepositoryListener);
        }
        VersioningRepositoryEvent versioningRepositoryEvent = new VersioningRepositoryEvent(this, versioningFileSystem, bl);
        if (bl) {
            int n = 0;
            while (n < versioningRepositoryListenerArray.length) {
                versioningRepositoryListenerArray[n].versioningSystemAdded(versioningRepositoryEvent);
                ++n;
            }
        } else {
            int n = 0;
            while (n < versioningRepositoryListenerArray.length) {
                versioningRepositoryListenerArray[n].versioningSystemRemoved(versioningRepositoryEvent);
                ++n;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

