/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import org.apache.tools.ant.module.run.OutputWriterOutputStream;
import org.apache.tools.ant.module.xml.AntProjectSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.modules.ModuleInstall;
import org.openide.util.RequestProcessor;

public class AntModule
extends ModuleInstall {
    private static final long serialVersionUID = -8877465721852434693L;
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.apache.tools.ant.module");

    public void uninstalled() {
        AntProjectSupport.stopFiringProcessor();
        OutputWriterOutputStream.detachAllAnnotations();
    }

    public static final class GlobalJarFileSystem
    extends JarFileSystem
    implements Runnable,
    RepositoryListener {
        private static final long serialVersionUID = -2165058869503900139L;

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            err.log("#17476: suppressing old GlobalJarFileSystem");
            RequestProcessor.postRequest((Runnable)this);
        }

        public void run() {
            err.log("Removing GlobalJarFileSystem from repository");
            this.listFSs();
            Repository.getDefault().removeFileSystem((FileSystem)this);
            this.listFSs();
            Repository.getDefault().addRepositoryListener((RepositoryListener)this);
        }

        private void listFSs() {
            if (err.isLoggable(1)) {
                LinkedList<FileSystem> linkedList = new LinkedList<FileSystem>();
                Enumeration enumeration = Repository.getDefault().getFileSystems();
                while (enumeration.hasMoreElements()) {
                    FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                    if (!(fileSystem instanceof GlobalJarFileSystem)) continue;
                    linkedList.add(fileSystem);
                }
                err.log("GJFSs in repo: " + linkedList);
            }
        }

        public void fileSystemAdded(RepositoryEvent repositoryEvent) {
            if (repositoryEvent.getFileSystem() == this) {
                RequestProcessor.postRequest((Runnable)this);
            }
        }

        public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
            if (repositoryEvent.getFileSystem() == this) {
                err.log("removing GJFS actually worked");
            }
        }

        public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
        }
    }
}

