/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.loader.AntCompilerSupport;
import org.apache.tools.ant.module.run.AntExecutor;
import org.openide.ServiceType;
import org.openide.compiler.CompilerType;
import org.openide.execution.Executor;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileSystemCapability;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakListener;

public class AntSettings
extends SystemOption
implements ChangeListener {
    public static final String PROP_VERBOSITY = "verbosity";
    public static final String PROP_PROPERTIES = "properties";
    public static final String PROP_SAVE_ALL = "saveAll";
    public static final String PROP_CUSTOM_DEFS = "customDefs";
    public static final String PROP_COMPILER = "compiler";
    public static final String PROP_EXECUTOR = "executor";
    public static final String PROP_REUSE_OUTPUT = "reuseOutput";
    public static final String PROP_ANT_VERSION = "antVersion";
    private static final String DEF_CLASS_PATH = "netbeans.class.path";
    private static final String DEF_BOOTCLASS_PATH = "netbeans.bootclass.path";
    private static final String DEF_LIBRARY_PATH = "netbeans.library.path";
    private static final String DEF_FILESYSTEMS_PATH = "netbeans.filesystems.path";
    private static final long serialVersionUID = -4457782585534082966L;
    static /* synthetic */ Class class$org$apache$tools$ant$module$run$AntExecutor;
    static /* synthetic */ Class class$org$apache$tools$ant$module$AntSettings;

    protected void initialize() {
        super.initialize();
        this.setVerbosity(2);
        Properties properties = new Properties();
        properties.setProperty("build.compiler.emacs", "true");
        properties.setProperty("build.sysclasspath", "ignore");
        this.setProperties(properties);
        this.setReuseOutput(false);
        this.setSaveAll(true);
        this.setCustomDefs(new IntrospectedInfo());
        this.setCompiler(AntCompilerSupport.NoCompiler.NO_COMPILER);
        Executor executor = Executor.find((Class)(class$org$apache$tools$ant$module$run$AntExecutor == null ? (class$org$apache$tools$ant$module$run$AntExecutor = AntSettings.class$("org.apache.tools.ant.module.run.AntExecutor")) : class$org$apache$tools$ant$module$run$AntExecutor));
        if (executor == null) {
            executor = new AntExecutor();
        }
        this.setExecutor(executor);
    }

    public String displayName() {
        return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$AntSettings == null ? (class$org$apache$tools$ant$module$AntSettings = AntSettings.class$("org.apache.tools.ant.module.AntSettings")) : class$org$apache$tools$ant$module$AntSettings), (String)"LBL_settings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.apache.tools.ant.module.settings");
    }

    public static AntSettings getDefault() {
        return (AntSettings)SharedClassObject.findObject((Class)(class$org$apache$tools$ant$module$AntSettings == null ? (class$org$apache$tools$ant$module$AntSettings = AntSettings.class$("org.apache.tools.ant.module.AntSettings")) : class$org$apache$tools$ant$module$AntSettings), (boolean)true);
    }

    public int getVerbosity() {
        return (Integer)this.getProperty(PROP_VERBOSITY);
    }

    public void setVerbosity(int n) {
        this.putProperty(PROP_VERBOSITY, new Integer(n), true);
    }

    public Properties getProperties() {
        HashMap hashMap = (HashMap)this.getProperty(PROP_PROPERTIES);
        Properties properties = new Properties();
        ((Hashtable)properties).putAll(hashMap);
        properties.setProperty(DEF_CLASS_PATH, AntSettings.getClassPath(NbClassPath.createClassPath()));
        properties.setProperty(DEF_BOOTCLASS_PATH, AntSettings.getClassPath(NbClassPath.createBootClassPath()));
        properties.setProperty(DEF_LIBRARY_PATH, AntSettings.getClassPath(NbClassPath.createLibraryPath()));
        properties.setProperty(DEF_FILESYSTEMS_PATH, AntSettings.getClassPath(NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.EXECUTE)));
        return properties;
    }

    private static String getClassPath(NbClassPath nbClassPath) {
        String string = nbClassPath.getClassPath();
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public void setProperties(Properties properties) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(properties);
        hashMap.remove(DEF_CLASS_PATH);
        hashMap.remove(DEF_BOOTCLASS_PATH);
        hashMap.remove(DEF_LIBRARY_PATH);
        hashMap.remove(DEF_FILESYSTEMS_PATH);
        this.putProperty(PROP_PROPERTIES, hashMap, true);
    }

    public boolean getSaveAll() {
        return (Boolean)this.getProperty(PROP_SAVE_ALL);
    }

    public void setSaveAll(boolean bl) {
        this.putProperty(PROP_SAVE_ALL, new Boolean(bl), true);
    }

    public IntrospectedInfo getCustomDefs() {
        return (IntrospectedInfo)this.getProperty(PROP_CUSTOM_DEFS);
    }

    public void setCustomDefs(IntrospectedInfo introspectedInfo) {
        this.putProperty(PROP_CUSTOM_DEFS, introspectedInfo, true);
        introspectedInfo.addChangeListener(WeakListener.change((ChangeListener)this, (Object)introspectedInfo));
    }

    public CompilerType getCompiler() {
        ServiceType.Handle handle = (ServiceType.Handle)this.getProperty(PROP_COMPILER);
        CompilerType compilerType = (CompilerType)handle.getServiceType();
        if (compilerType != null) {
            return compilerType;
        }
        return AntCompilerSupport.NoCompiler.NO_COMPILER;
    }

    public void setCompiler(CompilerType compilerType) {
        this.putProperty(PROP_COMPILER, new ServiceType.Handle((ServiceType)compilerType), true);
    }

    public Executor getExecutor() {
        ServiceType.Handle handle = (ServiceType.Handle)this.getProperty(PROP_EXECUTOR);
        Executor executor = (Executor)handle.getServiceType();
        if (executor != null) {
            return executor;
        }
        return new AntExecutor();
    }

    public void setExecutor(Executor executor) {
        this.putProperty(PROP_EXECUTOR, new ServiceType.Handle((ServiceType)executor), true);
    }

    public boolean getReuseOutput() {
        return (Boolean)this.getProperty(PROP_REUSE_OUTPUT);
    }

    public void setReuseOutput(boolean bl) {
        this.putProperty(PROP_REUSE_OUTPUT, new Boolean(bl), true);
    }

    public String getAntVersion() {
        String string = (String)this.getProperty(PROP_ANT_VERSION);
        if (string == null) {
            try {
                string = Main.getAntVersion();
            }
            catch (BuildException buildException) {
                AntModule.err.notify(1, (Throwable)buildException);
                string = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$AntSettings == null ? (class$org$apache$tools$ant$module$AntSettings = AntSettings.class$("org.apache.tools.ant.module.AntSettings")) : class$org$apache$tools$ant$module$AntSettings), (String)"LBL_ant_version_unknown");
            }
            this.putProperty(PROP_ANT_VERSION, string, false);
        }
        return string;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.firePropertyChange(PROP_CUSTOM_DEFS, null, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

