/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.loader;

import java.io.IOException;
import java.io.ObjectInput;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.loader.AntProjectDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.SafeException;

public class AntProjectDataLoader
extends UniFileLoader {
    private static final String REQUIRED_MIME = "text/x-ant+xml";
    private static final String KNOWN_ANT_FILE = "org.apache.tools.ant.module.loader.AntProjectDataLoader.KNOWN_ANT_FILE";
    private static final String KNOWN_ANT_FILE_OLD = "org.apache.tools.ant.module.AntProjectDataLoader.KNOWN_ANT_FILE";
    private static final long serialVersionUID = 3642056255958054115L;
    static /* synthetic */ Class class$org$apache$tools$ant$module$loader$AntProjectDataLoader;
    static /* synthetic */ Class class$org$openide$actions$OpenAction;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$OpenLocalExplorerAction;
    static /* synthetic */ Class class$org$openide$actions$ExecuteAction;
    static /* synthetic */ Class class$org$apache$tools$ant$module$nodes$RunTargetsAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$SaveAsTemplateAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public AntProjectDataLoader() {
        super("org.apache.tools.ant.module.loader.AntProjectDataObject");
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$loader$AntProjectDataLoader == null ? (class$org$apache$tools$ant$module$loader$AntProjectDataLoader = AntProjectDataLoader.class$("org.apache.tools.ant.module.loader.AntProjectDataLoader")) : class$org$apache$tools$ant$module$loader$AntProjectDataLoader), (String)"LBL_loader_name");
    }

    protected void initialize() {
        super.initialize();
        this.getExtensions().addMimeType(REQUIRED_MIME);
    }

    protected SystemAction[] defaultActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenAction == null ? (class$org$openide$actions$OpenAction = AntProjectDataLoader.class$("org.openide.actions.OpenAction")) : class$org$openide$actions$OpenAction)), SystemAction.get((Class)(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = AntProjectDataLoader.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)), null, SystemAction.get((Class)(class$org$openide$actions$OpenLocalExplorerAction == null ? (class$org$openide$actions$OpenLocalExplorerAction = AntProjectDataLoader.class$("org.openide.actions.OpenLocalExplorerAction")) : class$org$openide$actions$OpenLocalExplorerAction)), null, SystemAction.get((Class)(class$org$openide$actions$ExecuteAction == null ? (class$org$openide$actions$ExecuteAction = AntProjectDataLoader.class$("org.openide.actions.ExecuteAction")) : class$org$openide$actions$ExecuteAction)), SystemAction.get((Class)(class$org$apache$tools$ant$module$nodes$RunTargetsAction == null ? (class$org$apache$tools$ant$module$nodes$RunTargetsAction = AntProjectDataLoader.class$("org.apache.tools.ant.module.nodes.RunTargetsAction")) : class$org$apache$tools$ant$module$nodes$RunTargetsAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = AntProjectDataLoader.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = AntProjectDataLoader.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = AntProjectDataLoader.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = AntProjectDataLoader.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = AntProjectDataLoader.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = AntProjectDataLoader.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = AntProjectDataLoader.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), null, SystemAction.get((Class)(class$org$openide$actions$SaveAsTemplateAction == null ? (class$org$openide$actions$SaveAsTemplateAction = AntProjectDataLoader.class$("org.openide.actions.SaveAsTemplateAction")) : class$org$openide$actions$SaveAsTemplateAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = AntProjectDataLoader.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = AntProjectDataLoader.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(objectInput);
        }
        catch (SafeException safeException) {
            AntModule.err.annotate((Throwable)safeException, 0, "Reading AntProjectDataLoader: resetting action list to default", null, null, null);
            AntModule.err.notify(1, (Throwable)safeException);
        }
        ExtensionList extensionList = this.getExtensions();
        if (extensionList.isRegistered(".xml")) {
            AntModule.err.log("#15547: correcting old Ant object type extension list to be MIME format");
            if (extensionList.mimeTypes().hasMoreElements()) {
                AntModule.err.log("WARNING: old extension list had some MIME types in it, will be kept...");
            }
            extensionList.removeExtension("xml");
            if (extensionList.extensions().hasMoreElements()) {
                AntModule.err.log("WARNING: old extension list had non-.xml extensions in it, will not be converted...");
                extensionList = new ExtensionList();
                this.setExtensions(extensionList);
            }
            extensionList.addMimeType(REQUIRED_MIME);
        }
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        FileObject fileObject2 = super.findPrimaryFile(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        AntProjectDataLoader.clearAttrs(fileObject2);
        return fileObject2;
    }

    private static void clearAttrs(FileObject fileObject) {
        if (fileObject.getAttribute(KNOWN_ANT_FILE) == null && fileObject.getAttribute(KNOWN_ANT_FILE_OLD) == null) {
            return;
        }
        if (fileObject.isReadOnly()) {
            return;
        }
        try {
            FileSystem fileSystem = fileObject.getFileSystem();
            if (!fileSystem.isValid()) {
                return;
            }
            if (fileSystem == Repository.getDefault().getDefaultFileSystem()) {
                return;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            AntModule.err.notify(1, (Throwable)fileStateInvalidException);
            return;
        }
        try {
            fileObject.setAttribute(KNOWN_ANT_FILE, null);
            fileObject.setAttribute(KNOWN_ANT_FILE_OLD, null);
        }
        catch (IOException iOException) {
            AntModule.err.notify(1, (Throwable)iOException);
        }
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new AntProjectDataObject(fileObject, this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

