/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.javac.v8.util;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<Key, Data> {
    private int hashSize;
    private int hashMask;
    private int limit;
    private int size;
    private Entry<Key, Data>[] table;

    public Hashtable(int n, float f) {
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        this.hashSize = n2;
        this.hashMask = n2 - 1;
        this.limit = (int)((float)n2 * f);
        this.size = 0;
        this.table = new Entry[n2];
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable() {
        this(32);
    }

    public static <A, B> Hashtable<A, B> make() {
        return new Hashtable();
    }

    private void dble() {
        this.hashSize <<= 1;
        this.hashMask = this.hashSize - 1;
        this.limit <<= 1;
        Entry<Key, Data>[] entryArray = this.table;
        this.table = new Entry[this.hashSize];
        int n = 0;
        while (n < entryArray.length) {
            this.copy(entryArray[n]);
            ++n;
        }
    }

    private void copy(Entry<Key, Data> entry) {
        while (entry != null) {
            Entry entry2 = entry.next;
            int n = entry.hash & this.hashMask;
            entry.next = this.table[n];
            this.table[n] = entry;
            entry = entry2;
        }
    }

    public Data get(Key Key2) {
        int n = Key2.hashCode();
        Entry<Key, Data> entry = this.table[n & this.hashMask];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(Key2)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Data put(Key Key2, Data Data) {
        int n = Key2.hashCode();
        Entry<Key, Data> entry = this.table[n & this.hashMask];
        while (entry != null) {
            if (entry.hash == n && entry.key.equals(Key2)) {
                Object Data2 = entry.value;
                entry.value = Data;
                return Data2;
            }
            entry = entry.next;
        }
        ++this.size;
        if (this.size > this.limit) {
            this.dble();
        }
        int n2 = n & this.hashMask;
        Entry<Key, Data> entry2 = new Entry<Key, Data>(Key2, Data, n, this.table[n2]);
        this.table[n2] = entry2;
        return null;
    }

    public Data remove(Key Key2) {
        int n = Key2.hashCode();
        Entry<Key, Data> entry = null;
        Entry<Key, Data> entry2 = this.table[n & this.hashMask];
        while (entry2 != null) {
            if (entry2.hash == n && entry2.key.equals(Key2)) {
                if (entry != null) {
                    entry.next = entry2.next;
                } else {
                    this.table[n & this.hashMask] = entry2.next;
                }
                --this.size;
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry2.next;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void reset() {
        int n = 0;
        while (n < this.table.length) {
            this.table[n] = null;
            ++n;
        }
        this.size = 0;
    }

    /*
     * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<Key, Data> {
        Key key;
        Data value;
        int hash;
        Entry<Key, Data> next;

        Entry(Key Key2, Data Data, int n, Entry<Key, Data> entry) {
            this.key = Key2;
            this.value = Data;
            this.hash = n;
            this.next = entry;
        }
    }
}

