/*
 * w_main.h : Main header file for win32 port(NetHack2000 project)
 *
 * Copyright (c) Yukihiko Aoki 1999
 * NetHack may be freely redistributed.  See license for details.
 *
 */

#ifndef W_MAIN_H
#define W_MAIN_H

#ifndef W_DIBTILE_H
#include "w_dibtile.h"
#endif

/*
 * Some game configuration
 */
#define DEF_BASEWNDNAME         "JNetHack for Windows (Alpha 0.3.1.0)"
#define DEF_INIFILE             "nethack.ini"
#define DEF_WALLFILENAME        "wall.bmp"
#define DEF_BASEMINWIDTH        (640)
#define DEF_BASEMINHEIGHT       (480)
#define DEF_MOREINTERVAL        (500)
#define RINGBUFSIZE             (128)
#define TILEDIR                 "tiles"
#define CTLPARAM                "-ctl:"
#define WAVEDIR                 "waves"

/*
 * Only for non warning compilation. These definitions should be delete.
 */
#undef NDECL
#undef FDECL
#define NDECL(f)                f(void)
#define FDECL(f,p)              f p   

/*
 * Status window bitmap configuration
 */
#define STB_HEIGHT              24
#define STB_GOLD_WIDTH          12
#define STB_STAT_WIDTH          24
#define STB_HUN_WIDTH           80
#define STB_ENC_WIDTH           80

/*
 * Keyboard status
 */
#define KEYSTAT_NOTINITIALIZED  0x00
#define KEYSTAT_WAITCOMMAND     0x01
#define KEYSTAT_MENUSELECT      0x02
#define KEYSTAT_DIALOGINPUT     0x04    

/* 
 * Boolean flags for properties
 */
#define FLAG_ON                 (0x01)
#define FLAG_OFF                (0x00)

/*
 *
 */
#define PROGRESS_SETHWND        0
#define PROGRESS_SETRANGE       1
#define PROGRESS_SETPOS         2

#define INVALID_GLYPH           (-1)
#define D_ENTIRE                0       /* Entire map ROWNO x COLNO */
#define D_DEFAULT               1       /* Default bitmap size */
#define DM_CHAR                 0       /* Text draw mode */
#define DM_TILE                 1       /* Tile draw mode */

/*
 * Graphics display mode
 */
#define MODE_INVALID            (-1)
#define MODE_CONSOLE            1
#define MODE_GDI2D              2
#define MODE_GDI3D              3

/*
 * View flag
 */
#define VIEWPOINT_CLEAR         0
#define VIEWPOINT_SET           1

/*
 * Object type definition : These types will use in micro map.
 * Values will be an vertical index of bitmap file for type.
 */
#define PLACE_NON               0       /* Nothing there */
#define PLACE_YOU               1       /* You, player */
#define PLACE_PET               2       /* Pet */
#define PLACE_MON               3       /* Monster */
#define PLACE_OBJ               4       /* Object */
#define PLACE_TRP               5       /* Trap */
#define PLACE_WAL               6       /* Wall */
#define PLACE_FLR               7       /* Floor */
#define PLACE_UST               8       /* Up stair, ladder */
#define PLACE_DST               9       /* Down stair, ladder */
#define PLACE_SFX               10      /* Speical effect, swallow */
#define PLACE_FUN               11      /* Furniture */
#define PLACE_WAT               12      /* Water */
#define PLACE_AIR               13      /* Air */
#define PLACE_CLO               14      /* Cloud */
#define PLACE_LAV               15      /* Lava */
#define PLACE_BRI               16      /* Drawbridge */
#define PLACE_ICE               17      /* Ice */
#define PLACE_HDR               18      /* Horizontal door (closed) */
#define PLACE_VDR               19      /* Vertical door (closed) */
#define PLACE_CUR               20      /* Cursor */
#define PLACE_NUM               21

/*
 * Font data structure
 */
typedef struct tagFONTINFO {
    HFONT font_handle;                  /* font handle */
    long  font_width;                   /* width */
    long  font_height;                  /* height */
    long  font_weight;                  /* weight */
    DWORD font_color;                   /* rgb color */
    BYTE  font_italic;                  /* boolean flag */
    char  font_name[LF_FACESIZE];       /* face name */
}FONTINFO;

/*
 * Window data structure
 */
typedef struct tagWINDESC{
    DWORD style;                        /* window style */
    DWORD exstyle;                      /* extra style */
    BOOL  can_show;                     /* visiblity */
    BOOL  create_at_init;               /* create as HWND at init */
    BOOL  draw_memory;                  /* draw on memory device context */
    char  *cname;                       /* window class name */
    char  *wname;                       /* window name */
    HWND  hwnd;                         /* window handle */
    int   type;                         /* window type */
    POINT cur;                          /* cursor position */
    BOOL  more;                         /* more loop flag */
    void  *pinfo;                       /* window specific data */
    void  (*procCalcRect)(struct tagWINDESC *,RECT *,RECT *);
    void  (*procDestroy)(struct tagWINDESC *);
    void  (*procDisplay)(struct tagWINDESC *);
    void  (*procClear)(struct tagWINDESC *);
    void  (*procSetCursor)(struct tagWINDESC *,int,int);
    void  (*procPutStr)(struct tagWINDESC *,int,const char *);
    void  (*procDraw)(struct tagWINDESC *, HDC);
    struct tagWINDESC *next;
}WINDESC;

/*
 * Global resources
 */ 
typedef struct tagWINRESOURCE {
    TILELIST *gld_bmp;                  /* gold */
    TILELIST *enc_bmp;                  /* encumbered status */
    TILELIST *hun_bmp;                  /* hunger status */
    TILELIST *stt_bmp;                  /* special status */
    TILELIST *sym_bmp;                  /* micro map symbol */
    HBITMAP   btn_bmp;
    HBITMAP   mor_bmp;                  /* more */
    HBITMAP   wal_bmp;                  /* background */
}WINRESOURCE;

/*
 * System property
 */
typedef struct tagSYSTEMPROP {
    BYTE sound_flg;                     /* sound on/off */
    BYTE curkey_flg;                    /* cursor key use/unuse */
    BYTE ask_popup;                     /* yn_function is dialog/message */
}SYSTEMPROP;

/*
 * display informations : load from .ctl files
 */
typedef struct WINCONTROL {
    char name[BUFSZ];                   /* name of display mode */
    int  mode;                          /* type of display mode */
    char glyph[MAX_PATH+1];             /* file path of bitmap (main) */
    char option[MAX_PATH+1];            /* file path of bitmap (cursor) */
    char effect[MAX_PATH+1];            /* file path of bitmap (animations) */
    char animation[BUFSZ+1];            /* animations */
    int  cx;                            /* single tile width */
    int  cy;                            /* single tile height */
    char valid_rect[BUFSZ];             /* default tile rect */
    struct WINCONTROL *next;            /* next pointer for link list */
}WINCONTROL;

/*
 * display function table
 */
typedef struct DISPPROC {
    void (*uninit)(void);
    void (*clear)(void);                /* Clear map */
    void (*printGlyph)(int,int,int,int);/* Print glyph to destinate position */
    void (*updateGlyph)(void);          /* Refresh glyphs */
    void (*setCursor)(POINT);           /* Set cursor position */
    void (*setDispMode)(int,int,int);   /* Display mode change */
    void (*draw)(HWND,HDC,BOOL);        /* Redraw window */
    void (*getRect)(RECT*);             /* Get best match rectangle size */
    void (*putGlyph)(HDC,RECT*,int);    /* Put glyph to destinate rectangle */
    void (*setViewPoint)(int,int,int);
    void (*dispEffect)(HWND,HDC,int,int,int,int);/* Display effect */
    void (*clip)(int,int);
    HPALETTE (*getPalette)(void);       /* Return palette */
}DISPPROC;

/*
 * special effects
 */
typedef struct tagEFFECTITEM {
    short    start;
    short    count;
    BOOL     flush_flg;
    COLORREF color;
}EFFECTITEM;

/*
 * Colors
 */
#define zap_color(n)  color = iflags.use_color ? zapcolors[n] : NO_COLOR
#define cmap_color(n) color = iflags.use_color ? defsyms[n].color : NO_COLOR
#define obj_color(n)  color = iflags.use_color ? objects[n].oc_color : NO_COLOR
#define mon_color(n)  color = iflags.use_color ? mons[n].mcolor : NO_COLOR
#define pet_color(n)  color = iflags.use_color ? mons[n].mcolor : 	      \
				            /* If no color, try to hilite pets; black  */ \
				            /* should be HI				               */ \
				           ((iflags.hilite_pet && has_color(CLR_BLACK)) ? \
							CLR_BLACK : NO_COLOR)

/*
 * Macro definition
 */
#define GETWINDESC(hwnd)    (WINDESC*)GetWindowLong(hwnd,GWL_USERDATA)
#define NEWMEMORY(sz)       HeapAlloc(GetProcessHeap(),HEAP_ZERO_MEMORY,sz)
#define DELMEMORY(ptr)      HeapFree(GetProcessHeap(),0,ptr);
#define RCWIDTH(rc)         (rc->right - rc->left)
#define RCHEIGHT(rc)        (rc->bottom - rc->top)

#define E extern

/*
 * Global variables
 */
E HINSTANCE     g_hInstance;
E HWND          g_baseHwnd;
E char          g_propFile[];
E WINRESOURCE  *g_resource;    
E COLORREF      colormap[];
E DISPPROC      disp_procs;
E SYSTEMPROP    g_sysprop;

/*
 * Function prototypes
 */

/* w_main.c */
E void getModuleDirectory(char *, int);
E void System_defaultProperty(void *);

/* w_procs.c */
E void FDECL(win32_init_nhwindows, (int *, char **));
E void NDECL(win32_player_selection);
E void NDECL(win32_askname);
E void NDECL(win32_get_nh_event) ;
E void FDECL(win32_exit_nhwindows, (const char *));
E void FDECL(win32_suspend_nhwindows, (const char *));
E void NDECL(win32_resume_nhwindows);
E winid FDECL(win32_create_nhwindow, (int));
E void FDECL(win32_clear_nhwindow, (winid));
E void FDECL(win32_display_nhwindow, (winid, BOOLEAN_P));
E void FDECL(win32_dismiss_nhwindow, (winid));
E void FDECL(win32_destroy_nhwindow, (winid));
E void FDECL(win32_curs, (winid,int,int));
E void FDECL(win32_putstr, (winid, int, const char *));
E void FDECL(win32_display_file, (const char *, BOOLEAN_P));
E void FDECL(win32_start_menu, (winid));
E void FDECL(win32_add_menu, (winid,int,const ANY_P *,CHAR_P,int,const char *, BOOLEAN_P));
E void FDECL(win32_end_menu, (winid, const char *));
E int FDECL(win32_select_menu, (winid, int, MENU_ITEM_P **));
E void NDECL(win32_update_inventory);
E void NDECL(win32_mark_synch);
E void NDECL(win32_wait_synch);
#ifdef CLIPPING
E void FDECL(win32_cliparound, (int, int));
#endif
E void FDECL(win32_print_glyph, (winid,XCHAR_P,XCHAR_P,int));
E void FDECL(win32_print_glyph_compose, (winid,XCHAR_P,XCHAR_P,int,int));
E void FDECL(win32_raw_print, (const char *));
E void FDECL(win32_raw_print_bold, (const char *));
E int  NDECL(win32_nhgetch);
E int  FDECL(win32_nh_poskey, (int *, int *, int *));
E void NDECL(win32_nhbell);
E int  NDECL(win32_doprev_message);
E char FDECL(win32_yn_function, (const char *, const char *, CHAR_P));
E void FDECL(win32_getlin, (const char *,char *));
E int  NDECL(win32_get_ext_cmd);
E void FDECL(win32_number_pad, (int));
E void NDECL(win32_delay_output);
#ifdef MAKE_SOUND
E void FDECL(win32_make_sound, (int));
#endif
#ifdef DISPLAY_EFFECT
E void FDECL(win32_display_effect, (winid,int,int,int));
#endif
E void NDECL(win32_start_screen);
E void NDECL(win32_end_screen);
E void FDECL(genl_outrip, (winid,int));

/* w_misc.c */
E void FDECL(PrintError, (const char *format, ...));
E void FDECL(GetModuleDirectory, (char *,int));
E WINCONTROL* FDECL(LoadControlFile, (char *, BOOL));
E WINCONTROL* FDECL(ListControlFiles, (char *));
E void FDECL(FreeControl, (WINCONTROL *));
E BOOL FDECL(InitDisplayMode, (WINCONTROL *, void (*callbackProc)(int,int)));
E BOOL FDECL(RegisterNetHackWindows, (HINSTANCE));
E BOOL FDECL(UnregisterNetHackWindows, (HINSTANCE));
E BOOL FDECL(LoadGlobalResources, (HINSTANCE));
E void NDECL(FreeGlobalResources);

/* w_map.c */
E LRESULT CALLBACK FDECL(MapWndProc, (HWND,UINT,WPARAM,LPARAM));
E LRESULT CALLBACK FDECL(MicroWndProc, (HWND,UINT,WPARAM,LPARAM));
E BOOL FDECL(MapWnd_init, (WINDESC*,int));
E void FDECL(MapWnd_clip, (int,int));

/* w_menu.c */
E LRESULT CALLBACK MenuWndProc(HWND,UINT,WPARAM,LPARAM);
E BOOL FDECL(MenuWnd_init, (WINDESC*,int));
E void FDECL(MenuWnd_startMenu, (WINDESC*));
E BOOL FDECL(MenuWnd_addMenu, (WINDESC*,int,const anything*,char,char,int,const char*,boolean));
E void FDECL(MenuWnd_endMenu, (WINDESC*,char*));
E int  FDECL(MenuWnd_selectMenu, (WINDESC*,int,menu_item**));
E void NDECL(MenuWnd_setDefault);

/* w_base.c */
E LRESULT CALLBACK BaseWndProc(HWND,UINT,WPARAM,LPARAM);
E HWND NDECL(BaseWnd_create);
E void NDECL(BaseWnd_update);

/* w_mesg.c */
E LRESULT CALLBACK MesgWndProc(HWND,UINT,WPARAM,LPARAM);
E BOOL MesgWnd_init(WINDESC*,int);
E void MesgWnd_cmdPrev(WINDESC*);
E void MesgWnd_property(WINDESC*);
E char FDECL(MesgWnd_ask, (WINDESC *, const char *, const char *, char));

/* w_stat.c */
E LRESULT CALLBACK FDECL(StatWndProc, (HWND,UINT,WPARAM,LPARAM));
E LRESULT CALLBACK FDECL(SubStatProc, (HWND,UINT,WPARAM,LPARAM));
E BOOL StatWnd_init(WINDESC *,int);

/* w_key.c */
E void FDECL(Key_put,(char));
E BOOL NDECL(Key_init);
E void NDECL(Key_uninit);
E int  NDECL(Key_getChar);
E int  NDECL(Key_getStatus);
E int  FDECL(Key_setStatus,(int));
E int  NDECL(Key_kbhit);
E void FDECL(NHWnd_OnKey, (HWND,UINT,BOOL,int,UINT));
E void FDECL(NHWnd_OnSysKey, (HWND,UINT,BOOL,int,UINT));
E void FDECL(NHWnd_OnChar, (HWND,TCHAR,int));

/* w_font.c */
E void FDECL(Font_select,(HWND,FONTINFO *,BOOL,BOOL,BOOL));
E void FDECL(Font_default,(FONTINFO *));
E void FDECL(Font_create,(FONTINFO *));
E void FDECL(Font_save,(FONTINFO *,char *,char *));
E void FDECL(Font_load,(FONTINFO *,char *,char *));
E void FDECL(Font_delete,(FONTINFO *));
E int  FDECL(Font_width,(FONTINFO *,HDC));
E int  FDECL(Font_height,(FONTINFO *,HDC));

/* w_dialog.c */
E char FDECL(AskWnd_doModal,(const char *,const char *,char));
E void FDECL(AskWnd_resize,(HWND));
E void FDECL(InputWnd_doModal,(const char *,char *,int));
E LRESULT CALLBACK FDECL(AskWndProc, (HWND,UINT,WPARAM,LPARAM));
E LRESULT CALLBACK FDECL(CmdWndProc, (HWND,UINT,WPARAM,LPARAM));
E BOOL CALLBACK FDECL(CopyrightProc, (HWND,UINT,UINT,LONG));
E void FDECL(DisplayProgress, (int,int));

/* w_common.c */
E void FDECL(NHWnd_show, (WINDESC *,BOOL));
E void FDECL(NHWnd_saveProperty,(char *,void *,int));
E BOOL FDECL(NHWnd_loadProperty,(char *,void *,int,void (*defaultProc)(void *)));
E void FDECL(NHWnd_moveCenter,(HWND,HWND));
E BOOL FDECL(NHWnd_OnCreate,(HWND,LPCREATESTRUCT));
E void FDECL(NHWnd_OnPaint,(HWND));
E BOOL FDECL(NHWnd_OnEraseBkgnd, (HWND,HDC));
E void FDECL(NHWnd_display, (WINDESC *wd));
E BOOL FDECL(NHWnd_isValid, (WINDESC *wd));
E void NDECL(NHWnd_newLayout);
E void FDECL(NHWnd_drawWall,(HDC,RECT *));
E void FDECL(NHWnd_drawShadeText,(HDC,RECT *,char *,COLORREF,UINT));
E void FDECL(NHWnd_more,(WINDESC *));
E void FDECL(NHWnd_destroyDesc, (WINDESC *));
E void NDECL(NHWnd_destroyAll);
E UINT FDECL(NHWnd_OnNCHitTest, (HWND,int,int));
E WINDESC* FDECL(NHWnd_createDesc, (int));

/* w_gdi3d.c */
E BOOL FDECL(GDI3D_init, (WINCONTROL *,void (*callbackProc)(int,int)));
E void FDECL(GDI3D_func, (DISPPROC*));

/* w_gdi2d.c */
E BOOL FDECL(GDI2D_init, (WINCONTROL *,void (*callbackProc)(int,int)));
E void FDECL(GDI2D_func, (DISPPROC*));

/* w_glyph.c */
E char  FDECL(Glyph_toChar, (int, int *));
E char  FDECL(Glyph_toType, (int));
E short FDECL(Glyph_toTile, (int));

#undef E

#endif /* W_MAIN_H */