/*
 * w_procs.c : NetHack display interfaces for win32 tile version
 *
 * Copyright (c) Yukihiko Aoki 1999
 * NetHack may be freely redistributed.  See license for details.
 *
 */

#include "hack.h"

#ifdef NH2K_EXTENDS

#include "win32api.h"
#include "w_main.h"
#include "func_tab.h"
#include "dlb.h"

#ifdef _DEBUG
static char dbuf[256];
#endif

/*
 *  Interface definition, for windows.c
 */
struct window_procs win32_procs = {
    "win32",
    win32_init_nhwindows,
    win32_player_selection,
    win32_askname,
    win32_get_nh_event,
    win32_exit_nhwindows,
    win32_suspend_nhwindows,
    win32_resume_nhwindows,
    win32_create_nhwindow,
    win32_clear_nhwindow,
    win32_display_nhwindow,
    win32_destroy_nhwindow,
    win32_curs,
    win32_putstr,
    win32_display_file,
    win32_start_menu,
    win32_add_menu,
    win32_end_menu,
    win32_select_menu,
    genl_message_menu,
    win32_update_inventory,
    win32_mark_synch,
    win32_wait_synch,
#ifdef CLIPPING
    win32_cliparound,
#endif
#ifdef POSITIONBAR
    donull,
#endif
    win32_print_glyph,
    win32_raw_print,
    win32_raw_print_bold,
    win32_nhgetch,
    win32_nh_poskey,
    win32_nhbell,
    win32_doprev_message,
    win32_yn_function,
    win32_getlin,
    win32_get_ext_cmd,
    win32_number_pad,
    win32_delay_output,
#ifdef MAKE_SOUND
    win32_make_sound,
#endif
#ifdef DISPLAY_EFFECT
    win32_display_effect,
#endif
    /* other defs that really should go away (they're tty specific) */
    win32_start_screen,
    win32_end_screen,
    genl_outrip
};

/*
 * init_nhwindows
 */
void
win32_init_nhwindows(argcp, argv)
int *argcp;
char **argv;
{
	/* register all window classes */
	RegisterNetHackWindows(g_hInstance);

	/* load resources */
	LoadGlobalResources(g_hInstance);

	/* allocate the input buffer */
	Key_init();

	/* create main window */
	g_baseHwnd = BaseWnd_create();

//DoPropertySheet(g_baseHwnd);

    /* load menu window property */
    MenuWnd_setDefault();

//    NHWnd_loadProperty("SYSTEM", &g_sysprop, sizeof(SYSTEMPROP), System_defaultProperty);

	/* hi-score must show in window */
	flags.toptenwin = TRUE;
/*    CmdWnd_create();*/
}

/***************************************************************************************
 * exit_nhwindows
 ***************************************************************************************/
void win32_exit_nhwindows(const char *str)
{
    /* free tiles */
    disp_procs.uninit();

    /* Destroy other windows if exist */
    NHWnd_destroyAll();

    /* Free input buffer */
    Key_uninit();

    /* Destroy main window */
    DestroyWindow(g_baseHwnd);

    /* free resources */
    FreeGlobalResources();

    /* Unregister window classes */
    UnregisterNetHackWindows(g_hInstance);
}

/***************************************************************************************
 * player_selection
 ***************************************************************************************/
void win32_player_selection()
{
    int i, j, k, n;
    char pick4u = 'n', thisch, lastch = 0;
    char pbuf[QBUFSZ];
    winid win;
    anything any;
    menu_item *selected = 0;

	/* Select a role, if necessary */
	if (flags.initrole < 0) {
/*JP	    const char *prompt = "Shall I pick a character for you? [ynq] ";*/
        const char *prompt = "KɐEƂIł悢łH ";

        pick4u = win32_yn_function(prompt, ynqchars, 'y');

        /* Process the choice */
        switch (pick4u) {
        case 'y':
            /* Pick a random role */
            flags.initrole = randrole();
            break;
        case 'n':
            /* Prompt for a role */
            win = create_nhwindow(NHW_MENU);
            start_menu(win);
            any.a_void = 0;         /* zero out all bits */
            for (i = 0; roles[i].name.m; i++) {
	            any.a_int = i+1;	/* must be non-zero */
	            thisch = lowc(roles[i].name.m[0]);
                if (thisch == lastch) {
                    thisch = highc(thisch);
                }
        /*JP
	        add_menu(win, NO_GLYPH, &any, thisch,
		        0, ATR_NONE, an(roles[i].name.m), MENU_UNSELECTED);
        */
	            add_menu(win, NO_GLYPH, &any, thisch,
		            0, ATR_NONE, jtrns_mon(roles[i].name.m, -1), MENU_UNSELECTED);
	            lastch = thisch;
            }
            any.a_int = randrole()+1;	/* must be non-zero */
            add_menu(win, NO_GLYPH, &any , '*', 0, ATR_NONE,
		        "Random", MENU_UNSELECTED);
            any.a_int = i+1;	/* must be non-zero */
            add_menu(win, NO_GLYPH, &any , 'q', 0, ATR_NONE,
		        "Quit", MENU_UNSELECTED);
            /*JP		end_menu(win, "Pick a role");*/
            end_menu(win, "EƂIĂH");
            n = select_menu(win, PICK_ONE, &selected);
            destroy_nhwindow(win);

            /* Process the choice */
            if (n != 1 || selected[0].item.a_int == any.a_int)
	            goto give_up;		/* Selected quit */

            flags.initrole = selected[0].item.a_int - 1;
            free((genericptr_t) selected),	selected = 0;
            break;
	    default:
	    case 'q':
give_up:	/* Quit */
    		if (selected) free((genericptr_t) selected);
//	    	bail((char *)0);
		    /*NOTREACHED*/
		    return;
	    }
	}

	/* Select a race */
	if (!validrace(flags.initrole, flags.initrace))
	    i = j = k = randrace(flags.initrole);
	else
	    i = j = k = flags.initrace;
	/* Count the number of valid races */
	n = 0;
	do {
	    if (validrace(flags.initrole, i)) n++;
	    else if ((i == k) && (!races[++k].noun)) k = 0;
	    if (!races[++i].noun) i = 0;
	} while (i != j);
	/* Permit the user to pick, if there is more than one */
	if (!validrace(flags.initrole, flags.initrace)) {
	    if (pick4u == 'n' && n > 1) {
		win = create_nhwindow(NHW_MENU);
		start_menu(win);
		any.a_void = 0;         /* zero out all bits */
		for (i = 0; races[i].noun; i++)
#if 0	/*JP*/
		    if (validrace(flags.initrole, i)) {
			any.a_int = i+1;	/* must be non-zero */
			add_menu(win, NO_GLYPH, &any, races[i].noun[0],
				0, ATR_NONE, races[i].noun, MENU_UNSELECTED);
		    }
#endif
		    if (validrace(flags.initrole, i)) {
			any.a_int = i+1;	/* must be non-zero */
			add_menu(win, NO_GLYPH, &any, races[i].noun[0],
				0, ATR_NONE, jtrns_mon(races[i].noun, -1), MENU_UNSELECTED);
		    }
		any.a_int = randrace(flags.initrole)+1;
		add_menu(win, NO_GLYPH, &any , '*', 0, ATR_NONE,
				"Random", MENU_UNSELECTED);
		any.a_int = i+1;	/* must be non-zero */
		add_menu(win, NO_GLYPH, &any , 'q', 0, ATR_NONE,
				"Quit", MENU_UNSELECTED);
/*JP		Sprintf(pbuf, "Pick the race of your %s",
				roles[flags.initrole].name.m);
*/
		Sprintf(pbuf, "%s̎푰IĂD",
			roles[flags.initrole].jname.m);
		end_menu(win, pbuf);
		n = select_menu(win, PICK_ONE, &selected);
		destroy_nhwindow(win);
		if (n != 1 || selected[0].item.a_int == any.a_int)
		    goto give_up;		/* Selected quit */

		k = selected[0].item.a_int - 1;
		free((genericptr_t) selected),	selected = 0;
	    }
	}
	flags.initrace = k;

	/* Select a gender */
	if (!validgend(flags.initrole, flags.initrace, flags.initgend))
	    /* Pick a random valid gender */
	    i = j = k = randgend(flags.initrole, flags.initrace);
	else
	    i = j = k = flags.initgend;
	/* Count the number of valid genders */
	n = 0;
	do {
	    if (validgend(flags.initrole, flags.initrace, i)) n++;
	    else if ((i == k) && (++k >= ROLE_GENDERS)) k = 0;
	    if (++i >= ROLE_GENDERS) i = 0;
	} while (i != j);
	/* Permit the user to pick, if there is more than one */
	if (!validgend(flags.initrole, flags.initrace, flags.initgend)) {
	    if (pick4u == 'n' && n > 1) {
		win = create_nhwindow(NHW_MENU);
		start_menu(win);
		any.a_void = 0;         /* zero out all bits */
		for (i = 0; i < ROLE_GENDERS; i++)
		    if (validgend(flags.initrole, flags.initrace, i)) {
			any.a_int = i+1;	/* must be non-zero */
			add_menu(win, NO_GLYPH, &any, genders[i].adj[0],
				0, ATR_NONE, genders[i].j, MENU_UNSELECTED);
		    }
		any.a_int = randgend(flags.initrole, flags.initrace)+1;
		add_menu(win, NO_GLYPH, &any , '*', 0, ATR_NONE,
				"Random", MENU_UNSELECTED);
		any.a_int = i+1;	/* must be non-zero */
		add_menu(win, NO_GLYPH, &any , 'q', 0, ATR_NONE,
				"Quit", MENU_UNSELECTED);
/*JP		Sprintf(pbuf, "Pick the gender of your %s %s",
				races[flags.initrace].adj,
				roles[flags.initrole].name.m);
*/
		Sprintf(pbuf, "%s%s̐ʂIł",
				races[flags.initrace].j,
				roles[flags.initrole].jname.m);
		end_menu(win, pbuf);
		n = select_menu(win, PICK_ONE, &selected);
		destroy_nhwindow(win);
		if (n != 1 || selected[0].item.a_int == any.a_int)
		    goto give_up;		/* Selected quit */

		k = selected[0].item.a_int - 1;
		free((genericptr_t) selected),	selected = 0;
	    }
	}
	flags.initgend = k;

	/* Select an alignment */
	if (!validalign(flags.initrole, flags.initrace, flags.initalign))
	    /* Pick a random valid alignment */
	    i = j = k = randalign(flags.initrole, flags.initrace);
	else
	    i = j = k = flags.initalign;
	/* Count the number of valid alignments */
	n = 0;
	do {
	    if (validalign(flags.initrole, flags.initrace, i)) n++;
	    else if ((i == k) && (++k >= ROLE_ALIGNS)) k = 0;
	    if (++i >= ROLE_ALIGNS) i = 0;
	} while (i != j);
	/* Permit the user to pick, if there is more than one */
	if (!validalign(flags.initrole, flags.initrace, flags.initalign)) {
	    if (pick4u == 'n' && n > 1) {
		win = create_nhwindow(NHW_MENU);
		start_menu(win);
		any.a_void = 0;         /* zero out all bits */
		for (i = 0; i < ROLE_ALIGNS; i++)
		    if (validalign(flags.initrole, flags.initrace, i)) {
			any.a_int = i+1;	/* must be non-zero */
			add_menu(win, NO_GLYPH, &any, aligns[i].adj[0],
				 0, ATR_NONE, aligns[i].j, MENU_UNSELECTED);
		    }
		any.a_int = randalign(flags.initrole, flags.initrace)+1;
		add_menu(win, NO_GLYPH, &any , '*', 0, ATR_NONE,
				"Random", MENU_UNSELECTED);
		any.a_int = i+1;	/* must be non-zero */
		add_menu(win, NO_GLYPH, &any , 'q', 0, ATR_NONE,
				"Quit", MENU_UNSELECTED);
/*JP		Sprintf(pbuf, "Pick the alignment of your %s %s %s",*/
		Sprintf(pbuf, "%s%s%s̑IĂ",
				genders[flags.initgend].j,
				races[flags.initrace].j,
				(flags.initgend && roles[flags.initrole].jname.f) ?
				roles[flags.initrole].jname.f :
				roles[flags.initrole].jname.m);
		end_menu(win, pbuf);
		n = select_menu(win, PICK_ONE, &selected);
		destroy_nhwindow(win);
		if (n != 1 || selected[0].item.a_int == any.a_int)
		    goto give_up;		/* Selected quit */

		k = selected[0].item.a_int - 1;
		free((genericptr_t) selected),	selected = 0;
	    }
	}
	flags.initalign = k;
	/* Success! */
//	tty_display_nhwindow(BASE_WINDOW, FALSE);
/*
	char		pc;
	int			selcount;
	winid		window;
	anything	ai;
	int			i;
	int			k;
	menu_item	*mitem = NULL;
	char		selch;
	char		selidx;
	int			idx = -1 ;

	pc = highc( pl_character[0] );
	if( pc != 0) {
		if( index(pl_classes, pc) != (char *)0 ) {
			pl_character[0] = pc;
			return;
		}
	}

	window = create_nhwindow( NHW_MENU );

	start_menu( window );

	ai.a_void = 0;
	add_menu(window, NO_GLYPH, &ai, 0, 0, ATR_NONE, 
        "vCLN^[IĉD", FALSE);
	add_menu(window, NO_GLYPH, &ai, 0, 0, ATR_NONE, " ", FALSE);

	for( k=0, i=0; roles[i] != 0; i++ ) {
		ai.a_void = (void*)roles[i][0];

		switch( roles[i][0] ) {
		case 'A':	idx = PM_ARCHEOLOGIST;	break;
		case 'B':	idx = PM_BARBARIAN;		break;
		case 'C':	idx = flags.female ? PM_CAVEWOMAN : PM_CAVEMAN; break;
		case 'E':	idx = PM_ELF; break;
#ifdef FIGHTER
		case 'F':	idx = PM_FIGHTER; 	break;
#endif
		case 'H':	idx = PM_HEALER;		break;
		case 'K':	idx = PM_KNIGHT;		break;
		case 'P':	idx = flags.female ? PM_PRIESTESS : PM_PRIEST; break;
		case 'R':	idx = PM_ROGUE;		break;
		case 'S':	idx = PM_SAMURAI;		break;
#ifdef TOURIST
		case 'T':	idx = PM_TOURIST;		break;
#endif
		case 'V':	idx = PM_VALKYRIE;	break;
		case 'W':	idx = PM_WIZARD;		break;
		default:
			break;
		}
		add_menu( window,
				(idx == -1 ) ? NO_GLYPH : what_mon(idx) + GLYPH_MON_OFF ,
				&ai,
				roles[i][0],
				tolower(roles[i][0]),
				ATR_NONE,
				jtrns_mon(roles[i], flags.female),
				FALSE);
	}

	ai.a_void = 0;
	add_menu(window,NO_GLYPH,&ai,0,0,ATR_NONE," ",FALSE);
	ai.a_void = (void*)'X';
	add_menu(window, NO_GLYPH, &ai, 'X', 'x', ATR_NONE, "_", FALSE);

	end_menu(window,"Character Selection");
	selcount = select_menu( window, PICK_ONE, &mitem);

	if( selcount > 0 ) {
		selch = (char)mitem[0].item.a_void;
		if( selch == 'X' ) {
			selidx = rn2((int)strlen(pl_classes));
			pline("̃Q[ł͂Ȃ%słD", jtrns_mon(roles[selidx], flags.female));
			display_nhwindow( WIN_MESSAGE, TRUE );
			pl_character[0] = roles[selidx][0];
		}
		else if( selch != 'Q' ) {
			pl_character[0] = selch;
		}
		free(mitem);
	}
	else if( selcount == 0 ) {
		selidx = rn2((int)strlen(pl_classes));
		pline("̃Q[ł͂Ȃ%słD", jtrns_mon(roles[selidx], flags.female));
		display_nhwindow( WIN_MESSAGE, TRUE );
		pl_character[0] = roles[selidx][0];
	}
*/
}

/***************************************************************************************
 * askname
 ***************************************************************************************/
void win32_askname()
{
    char buf[BUFSZ];
    int length;

    buf[0] = '\0';
    do{
        InputWnd_doModal("Ȃ͒NH", buf, BUFSZ - 1);
    }while(strcmp(buf,"\033\000") == 0);
    length=strlen(buf);
    if(length >= PL_NSIZ) {
        length = PL_NSIZ - 1;
    }
    strncpy(plname, buf, length);
    plname[length] = '\0';
}

/***************************************************************************************
 * get_nh_event
 ***************************************************************************************/
void win32_get_nh_event()
{
    MSG msg;

    if(PeekMessage(&msg, 0, 0, 0, PM_REMOVE)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
    }
}

/***************************************************************************************
 * suspend_nhwindows
 ***************************************************************************************/
void win32_suspend_nhwindows( const char *str )
{
#ifdef _DEBUG
	sprintf( dbuf, "win32_suspend_nhwindows: str=%s\n", str );
	OutputDebugString( dbuf );
#endif
}

/***************************************************************************************
 * create_nhwindow
 ***************************************************************************************/
void win32_resume_nhwindows()
{
	/* nothing to do */
}

/***************************************************************************************
 * create_nhwindow
 ***************************************************************************************/
winid win32_create_nhwindow(int type)
{
    WINDESC *wd;

    wd = NHWnd_createDesc(type);
    if(wd) {
        return (winid)wd;
    }else {
        raw_print( "Error: win32_create_nhwindow" );
    }

    return WIN_ERR;
}

/***************************************************************************************
 * clear_nhwindow
 ***************************************************************************************/
void win32_clear_nhwindow(winid window)
{
    WINDESC *wd = (WINDESC*)window;

    if(NHWnd_isValid(wd)) {
        if(wd->procClear) {
            wd->procClear(wd);
        }
    }else {
        raw_print( "Error: win32_clear_nhwindow" );
    }
}

/***************************************************************************************
 * display_nhwindow
 ***************************************************************************************/
void win32_display_nhwindow(winid window, boolean blocking)
{
	WINDESC *wd = (WINDESC*)window;

    if(NHWnd_isValid(wd)) {
        ShowWindow(wd->hwnd, SW_SHOW);
        if(wd->procDisplay) {
            wd->procDisplay(wd);
        }
        if(blocking) {
            NHWnd_more(wd);
        }
    }else {
        raw_print("Error: win32_display_nhwindow");
    }
}

/***************************************************************************************
 * destroy_nhwindow
 ***************************************************************************************/
void win32_destroy_nhwindow(winid window)
{
    WINDESC* wd = (WINDESC*)window;

    if(NHWnd_isValid(wd)) {
        NHWnd_destroyDesc(wd);
    }else {
        pline("Error: win32_destroy_nhwindow");
    }
}

/***************************************************************************************
 * curs
 ***************************************************************************************/
void win32_curs(winid window, register int col, register int row)
{
	WINDESC *wd = (WINDESC*)window;

    if(NHWnd_isValid(wd)) {
        if(wd->procSetCursor) {
            wd->procSetCursor(wd, col, row);
        }
    }else {
        raw_print("Error: win32_curs");
    }
}

/***************************************************************************************
 * putstr
 ***************************************************************************************/
void win32_putstr(winid window, int attr, const char *str)
{
	WINDESC *wd = (WINDESC*)window;

    if(NHWnd_isValid(wd)) {
        if(wd->procPutStr) {
            wd->procPutStr(wd, attr, str);
        }
    }else {
        win32_raw_print("Error: win32_putstr");
    }
}

/***************************************************************************************
 * display_file
 ***************************************************************************************/
void win32_display_file(const char *fname, boolean complain)
{
	char	buf[BUFSZ];
	dlb		*fp;
	int		yy=0;
	winid	window;
	int		length;

	fp = dlb_fopen(fname, "r");
	if(!fp) {
		if(complain) {
			pline("Cannot open \"%s\".", fname);
		}
    } else {
		window = create_nhwindow(NHW_TEXT);
	    while(dlb_fgets(buf, BUFSZ, fp)) {
			length = strlen(buf);
			if(length >= 2 && buf[length-2] == '\r') {
				buf[length-2] = '\0';
			}

			putstr(window, ATR_NONE, buf);
	    }
	    display_nhwindow(window, TRUE);
	    destroy_nhwindow(window);
	    dlb_fclose(fp);
	}
}

/***************************************************************************************
 * update_inventory
 ***************************************************************************************/
void win32_update_inventory()
{
#ifdef _DEBUG
	sprintf(dbuf,"win32_update_inventory:\n");
	OutputDebugString(dbuf);
#endif
}

/***************************************************************************************
 * mark_synch
 ***************************************************************************************/
void win32_mark_synch()
{
#ifdef _DEBUG
	sprintf(dbuf,"win32_mark_synch:\n");
	OutputDebugString(dbuf);
#endif
}

/***************************************************************************************
 * wait_synch
 ***************************************************************************************/
void win32_wait_synch()
{
#ifdef _DEBUG
	sprintf(dbuf,"win32_wait_synch:\n");
	OutputDebugString(dbuf);
#endif
}

/***************************************************************************************
 * cliparound
 ***************************************************************************************/
void win32_cliparound(int x, int y)
{
    WINDESC *wd = (WINDESC*)WIN_MAP;

    if(NHWnd_isValid(wd)) {
        MapWnd_clip(x,y);
    }
}

/***************************************************************************************
 * print_glyph
 ***************************************************************************************/
void win32_print_glyph(winid window, xchar col, xchar row, int glyph)
{
    WINDESC *wd = (WINDESC*)window;
    int fg, bg;

    if(glyph == cmap_to_glyph(S_stone)) {
        bg = fg = glyph;
    }else {
        /****  *****/
        if(Blind || (viz_array && !cansee(col, row))) {
            struct rm *lev = &levl[col][row];
            bg = lev->glyph;
            if(glyph_is_object(bg)) {
                if(!lev->waslit) {
                    bg = cmap_to_glyph(S_stone);
                }else {
                    bg = back_to_glyph(col, row);
                }
            }
        }else {
            /***** ܂Œǉ *****/
            bg = back_to_glyph(col, row);
        }
        if(bg == glyph) {
            fg = cmap_to_glyph(S_stone);
        }else {
            fg = glyph;
        }
    }
/*
    if(glyph == cmap_to_glyph(S_stone)) {
        bg = fg = glyph;
    }else {
        bg = back_to_glyph(col, row);
        if(bg == glyph) {
            fg = cmap_to_glyph(S_stone);
        }else {
            fg = glyph;
        }
    }
*/

    if(NHWnd_isValid(wd) && wd->type == NHW_MAP) {
        MapWnd_setGlyph(window, col,row, bg, fg);
    }else {
        /* Unsupported type of window */
        win32_raw_print( "print_glyph to bad window type." );
    }
}


/***************************************************************************************
 * raw_print
 ***************************************************************************************/
void win32_raw_print( const char *str )
{
    MessageBox(NULL, str, "NetHack", MB_OK);
}

/***************************************************************************************
 * raw_print_bold
 ***************************************************************************************/
void win32_raw_print_bold(const char *str)
{
    raw_print(str);
}

/***************************************************************************************
 * nhgetch
 ***************************************************************************************/
int win32_nhgetch()
{
    return Key_getChar();
}

/***************************************************************************************
 * nh_poskey
 ***************************************************************************************/
int win32_nh_poskey( int *x, int *y, int *mod )
{
    return Key_getChar();
}

/***************************************************************************************
 * doprev_message
 ***************************************************************************************/
int win32_doprev_message()
{
    WINDESC *wd = (WINDESC*)WIN_MESSAGE;

    if(NHWnd_isValid(wd)) {
        MesgWnd_cmdPrev(wd);
    }

    return 0;
}

/***************************************************************************************
 * yn_function
 ***************************************************************************************/
char win32_yn_function(const char *query, const char *choices,	char def)
{
    WINDESC *wd = (WINDESC *)WIN_MESSAGE;
    char     ch;
    int      keyStat;

    keyStat = Key_setStatus(KEYSTAT_MENUSELECT);

    if(!g_sysprop.ask_popup && NHWnd_isValid(wd)) {

        ch = MesgWnd_ask(wd, query, choices, def);

    }else {
        ch = AskWnd_doModal(query, choices, def);
    }

    Key_setStatus(keyStat);

    return ch;
}

/***************************************************************************************
 * delay_output
 ***************************************************************************************/
void win32_delay_output()
{
    int i;

    for(i = 0; i < 5; i++) {
        get_nh_event();
        Sleep(10);
    }
}

/***************************************************************************************
 * end_screen
 ***************************************************************************************/
void win32_end_screen()
{
#ifdef _DEBUG
    sprintf(dbuf,"win32_end_screen:\n");
    OutputDebugString(dbuf);
#endif
}

/***************************************************************************************
 * get_ext_cmd
 ***************************************************************************************/
int win32_get_ext_cmd()
{
	extern struct ext_func_tab extcmdlist[];
	char	buf[256];
	int		i=0;
	int		j;
	winid	id;
	int		max_len=0;
	anything ident;
	menu_item *selected;
	int		retn;
	int		selid;

#ifdef _DEBUG
	sprintf( dbuf, "[called] get_ext_cmd:\n" );
	OutputDebugString( dbuf );
#endif

	id = create_nhwindow(NHW_MENU);
	start_menu( id );
	while( extcmdlist[i].ef_txt != NULL ) {
		if( strlen( extcmdlist[i].ef_txt ) > max_len ) {
			max_len = strlen( extcmdlist[i].ef_txt );
		}
		i++;
	}

	i=0;
	while( extcmdlist[i].ef_txt != NULL )
	{
		strncpy( buf, extcmdlist[i].ef_txt, strlen(extcmdlist[i].ef_txt) );
		for( j=strlen(extcmdlist[i].ef_txt);j<=max_len; j++ ) {
			buf[j] = ' ';
		}
		sprintf( &buf[j], "%s", extcmdlist[i].ef_desc );
		ident.a_void = (char*)i;
		add_menu(id,NO_GLYPH,&ident,extcmdlist[i].ef_txt[0],0,ATR_NONE,buf,FALSE );
		i++;
	}
	end_menu(id,NULL);
	retn = select_menu( id,PICK_ONE,&selected);
	if( retn <= 0) {
		return -1;
	}

	selid = (int)selected->item.a_void;
	free( selected );
	destroy_nhwindow( id );

	return selid;
}

/***************************************************************************************
 * getlin
 ***************************************************************************************/
void win32_getlin(const char *ques, char *input)
{
    int keyStat;

    keyStat = Key_setStatus(KEYSTAT_DIALOGINPUT);
	flush_screen(1);
	InputWnd_doModal(ques, input, BUFSZ);
    Key_setStatus(keyStat);
}

/***************************************************************************************
 * nhbell
 ***************************************************************************************/
void win32_nhbell()
{
#ifdef _DEBUG
	sprintf(dbuf,"win32_nhbell:\n");
	OutputDebugString(dbuf);
#endif
}

/***************************************************************************************
 * number_pad
 ***************************************************************************************/
void win32_number_pad( int x )
{
#ifdef _DEBUG
	sprintf(dbuf,"win32_number_pad: x=%d\n",x);
	OutputDebugString(dbuf);
#endif
}

/***************************************************************************************
 * start_screen
 ***************************************************************************************/
void win32_start_screen()
{
#ifdef _DEBUG
	sprintf(dbuf,"win32_start_screen:\n");
	OutputDebugString(dbuf);
#endif
}

/***************************************************************************************
 * start_menu
 ***************************************************************************************/
void win32_start_menu( winid window )
{
	WINDESC *wd = (WINDESC*)window;

	if(NHWnd_isValid(wd) && (wd->type==NHW_MENU || wd->type==NHW_TEXT)) {
		MenuWnd_startMenu( wd );
	}
	else {
		pline( "Error: win32_start_menu" );
	}
}

/***************************************************************************************
 * add_menu
 ***************************************************************************************/
void win32_add_menu(
    winid window,
    int glyph,
    const anything *identifier,
    char ch,
    char gch,
    int attr,
    const char *str,
    boolean preselected)
{
    WINDESC *wd = (WINDESC*)window;

    if(NHWnd_isValid(wd) && (wd->type==NHW_MENU || wd->type==NHW_TEXT) ) {
        MenuWnd_addMenu(wd,glyph,identifier,ch,gch,attr,str,preselected);
    }else {
        pline("Error: win32_add_menu");
	}
}

/***************************************************************************************
 * end_menu
 ***************************************************************************************/
void win32_end_menu( winid window, char *prompt)
{
    WINDESC *wd = (WINDESC*)window;

    if(NHWnd_isValid(wd) && (wd->type==NHW_MENU || wd->type==NHW_TEXT)) {
        MenuWnd_endMenu(wd, prompt);
    }else {
        pline("Error: win32_end_menu");
    }
}

/***************************************************************************************
 * select_menu
 ***************************************************************************************/
int win32_select_menu(winid window, int how, menu_item **menu_list)
{
    WINDESC *wd  = (WINDESC*)window;
    int      ret = -1;
    int	     keyStat;

    if(NHWnd_isValid(WIN_MESSAGE)) {
        clear_nhwindow(WIN_MESSAGE);
    }

    keyStat = Key_setStatus(KEYSTAT_MENUSELECT);
    if(NHWnd_isValid(wd) && (wd->type==NHW_MENU || wd->type==NHW_TEXT)) {
        ret = MenuWnd_selectMenu(wd, how, menu_list);
    }else {
        pline("Error: win32_select_menu");
    }
    Key_setStatus(keyStat);

    return ret;
}

/***************************************************************************************
 * display_effect
 ***************************************************************************************/
#ifdef DISPLAY_EFFECT
void win32_display_effect(winid window, int col, int row, int type)
{
    if(NHWnd_isValid(window)) {
        MapWnd_cmdEffect(window, col, row, type);
    }
}
#endif /* DISPLAY_EFFECT */

/***************************************************************************************
 * make_sound
 ***************************************************************************************/
#ifdef MAKE_SOUND
void win32_make_sound(int type)
{
    char *filename;

    if(filename = Sound_getFilename(type)) {
		if(_access(filename, 00) == 0) {
			PlaySound(filename, NULL, SND_FILENAME|SND_ASYNC);
		}
    }
}
#endif /* MAKE_SOUND */

/***************************************************************************************
 * init_proc
 ***************************************************************************************/
void win_win32_init()
{
    nt_kbhit = Key_kbhit;
}

#endif /* NH2K_EXTENDS */
