/*
 * w_sound.c : sound id file name mapping
 *
 * Copyright (c) Yukihiko Aoki 1999
 * NetHack may be freely redistributed.  See license for details.
 *
 */

#include "hack.h"

#ifdef NH2K_EXTENDS

#include "win32api.h"
#include "w_main.h"
#include "res/resource.h"

static const char *sound_map[] = {
    NULL,                      /* NO_SOUND */
    "Breath.wav",              /* SOUND_BREATH */
    "Clunk.wav",               /* SOUND_CLUNK */
    "Coin.wav",                /* SOUND_COIN */
    "Cursing.wav",             /* SOUND_CURSING */
    "Death.wav",               /* SOUND_DEATH */
    "Destroy.wav",             /* SOUND_DESTROY */
    "Doorclos.wav",            /* SOUND_DOORCLOS */
    "Dooropen.wav",            /* SOUND_DOOROPEN */
    "Drop.wav",                /* SOUND_DROP */
    "Fountain.wav",            /* SOUND_FOUNTAIN */
    "Hallu.wav",               /* SOUND_HALLU */
    "Hit.wav",                 /* SOUND_HIT */
    "Landmine.wav",            /* SOUND_LANDMINE */
    "Level.wav",               /* SOUND_LEVEL */
    "Memor.wav",               /* SOUND_MEMOR */
    "Miss.wav",                /* SOUND_MISS */
    "Ouch.wav",                /* SOUND_OUCH */
    "Register.wav",            /* SOUND_REGISTER */
    "Thump.wav",               /* SOUND_THUMP */
    "Trapdoor.wav",            /* SOUND_TRAPDOOR */
    "Vomit.wav",               /* SOUND_VOMIT */
    "Whistle.wav",             /* SOUND_WHISTLE */
    "bee.wav",                 /* SOUND_BEE */
    "bee2.wav",                /* SOUND_BEE2 */
    "bee3.wav",                /* SOUND_BEE3 */
    "blast.wav",               /* SOUND_BLAST */
    "bubble.wav",              /* SOUND_BUBBLE */
    "cat.wav",                 /* SOUND_CAT */
    "cat2.wav",                /* SOUND_CAT2 */
    "creaking.wav",            /* SOUND_CREAKING */
    "dog.wav",                 /* SOUND_DOG */
    "doorkick.wav",            /* SOUND_DOORKICK */
    "eii.wav",                 /* SOUND_EII */
    "explosion2.wav",          /* SOUND_EXPLOSION2 */
    "footsteps.wav",           /* SOUND_FOOTSTEPS */
    "keikei.wav",              /* SOUND_KEIKEI */
    "key.wav",                 /* SOUND_KEY */
    "laughing.wav",            /* SOUND_LAUGHING */
    "mournfully.wav",          /* SOUND_MOURNFULLY */
    "noises.wav",              /* SOUND_NOISES */
    "noises2.wav",             /* SOUND_NOISES2 */
    "pile.wav",                /* SOUND_PILE */
    "ringdrop.wav",            /* SOUND_RINGDROP */
    "screaming.wav",           /* SOUND_SCREAMING */
    "whammm.wav",              /* SOUND_WHAMMM */
    "dooropen2.wav",           /* SOUND_DOOROPEN2 */
    "explosion.wav",           /* SOUND_EXPLOSION */
    NULL,                      /* SOUND_CAMERA */
    NULL,                      /* SOUND_SPLASH */
    NULL,                      /* SOUND_HELLFIRE */
    NULL,                      /* SOUND_HEART */
    NULL,                      /* SOUND_TYPING */
    NULL,                      /* SOUND_WHISTLE1 */
    NULL,                      /* SOUND_WHISTLE2 */
    NULL,                      /* SOUND_BELL1 */
    NULL,                      /* SOUND_BELL2 */
    NULL,                      /* SOUND_FIRE */
    NULL,                      /* SOUND_COLD */
    NULL,                      /* SOUND_LIGHTNING */
    "sh_moster.wav",           /* SOUND_ARROW */
    NULL,                      /* SOUND_BALLFALL */
    NULL,                      /* SOUND_UPDBRIDGE */
    NULL,                      /* SOUND_CRUSH */
    NULL,                      /* SOUND_DOWNDBRIDGE */
    NULL,                      /* SOUND_BIGSPLASH */
    NULL,                      /* SOUND_BIGCRASH */
    NULL,                      /* SOUND_GROAN */
    NULL,                      /* SOUND_KICK */
    NULL,                      /* SOUND_LOSEEXP */
    NULL,                      /* SOUND_NEWEXP */
    NULL,                      /* SOUND_FLUTE */
    NULL,                      /* SOUND_HORN */
    NULL,                      /* SOUND_HARP */
    NULL,                      /* SOUND_DRUM */
    "se-drop1.wav",            /* SOUND_SINK */
    NULL,                      /* SOUND_LADY */
    "be-funny1.wav",           /* SOUND_FUNNY */
    "sh-freshtear2.wav",       /* SOUND_EAT */
    "se-drink.wav",            /* SOUND_DRINK */
    "se-guns1.wav"             /* SOUND_GUN */
};

/***************************************************************************************/
/*
/***************************************************************************************/
const char *Sound_getFilename(int type)
{
    static char buf[MAX_PATH + 1];
    char *filename = NULL;

    if(sound_map[type]) {
        GetModuleDirectory(buf, MAX_PATH);
        strcat(buf, "\\" WAVEDIR "\\");
        strcat(buf, sound_map[type]);
        filename = buf;
    }

    return filename;
}

#endif /* NH2K_EXTENDS */
