/*
**
**	$Id: jconj.c,v 1.4 1996/07/17 06:03:45 issei Exp issei $
**
*/

/* Copyright (c) Issei Numata 1994-1996 */
/* JNetHack may be freely redistributed.  See license for details. */

#include <stdio.h>
#include <ctype.h>
#include "hack.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/select.h>
#include <sys/time.h>

#ifdef REPORTSCORE

static char	*errstr;

static int
soc_write_str(int sd, char *buf)
{
  return write(sd, buf, strlen(buf));
}

int
soc_read(int sd, char *buf, int len)
{
  fd_set		readfds, writefds, exceptfds;
  struct timeval	timeout;
  int			ret = 0;

  FD_ZERO(&readfds);
  FD_ZERO(&writefds);
  FD_ZERO(&exceptfds);
  FD_SET(sd, &readfds);

  timeout.tv_sec = 5;
  timeout.tv_usec = 0;
  if(!select(32, &readfds, &writefds, &exceptfds, &timeout)){
    errstr = "error: timeout!\n";
    return -1;
  }

  if(FD_ISSET(sd, & readfds)){
    ret = read(sd, buf, len);
    /*
    write(1, buf, ret);
    */
  }
  return ret;
}

int
soc_wait(int sd)
{
  char	buf[4097];
  int len;

  len = soc_read(sd, buf, 4096);
  buf[len] = '\0';
  
  return atoi(buf);
}

int
connect_scoreserver()
{
  int			sd;
  struct sockaddr_in	to;
  struct hostent	*hp;
  char			buf[4097];
  int			len;

  if((hp = gethostbyname(SCORE_SERVER)) == NULL){
    errstr = "error: bad score server!\n";
    return -1;
  }

  bzero(&to, sizeof(to));
  bcopy(hp->h_addr_list[0], &to.sin_addr, hp->h_length);

  to.sin_family = AF_INET;
  to.sin_port = htons(SCORE_PORT);
  
  if((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0){
    errstr = "error: cannot create socket!\n";
    return -1;
  }

  if(connect(sd, (struct sockaddr *)&to, sizeof(to)) < 0){
    errstr = "error: bad score server!\n";
    return -1;
  }

  len = soc_read(sd, buf, 4096);
  if(len <= 0 && buf[0] != '2'){
    errstr = "error: score server error!\n";
    return -1;
  }

  return sd;
}

char *
remote_err()
{
  return errstr;
}

#endif
