/*	SCCS Id: @(#)mcastu.c	3.2	96/05/01	*/
/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1985. */
/* NetHack may be freely redistributed.  See license for details. */

/*
**	Japanese version Copyright
**	(c) Issei Numata, Naoki Hamada, Shigehiro Miyashita, 1994-1999
**	changing point is marked `JP' (94/6/7)
**	JNetHack may be freely redistributed.  See license for details. 
*/

#include "hack.h"

STATIC_DCL void FDECL(cursetxt,(struct monst *));

#ifdef OVL0

extern const char *flash_types[];	/* from zap.c */

STATIC_OVL
void
cursetxt(mtmp)
	register struct monst *mtmp;
{
	if(canseemon(mtmp)) {
	    if ((Invis && !perceives(mtmp->data) &&
				(mtmp->mux != u.ux || mtmp->muy != u.uy))
			|| u.usym == S_MIMIC_DEF || u.uundetected)
/*JP		pline("%s points and curses in your general direction.",*/
		pline("%sϤʤΤ뤢غ򤫤",
				Monnam(mtmp));
	    else if (Displaced && (mtmp->mux != u.ux || mtmp->muy != u.uy))
/*JP		pline("%s points and curses at your displaced image.",*/
		pline("%sϤʤƤغ򤫤",
				Monnam(mtmp));
	    else
/*JP		pline("%s points at you, then curses.", Monnam(mtmp));*/
		pline("%sϤʤغ򤫤", Monnam(mtmp));
	} else if((!(moves%4) || !rn2(4)) && flags.soundok)
/*JP		Norep("You hear a mumbled curse.");*/
		Norep("θդĤ֤䤯ʹ");
}

#endif /* OVL0 */
#ifdef OVLB

int
castmu(mtmp, mattk)	/* monster casts spell at you */
	register struct monst *mtmp;
	register struct attack *mattk;
{
	int	dmg, ml = mtmp->m_lev;

	if(mtmp->mcan || mtmp->mspec_used || !ml) {  /* could not attack */
	    cursetxt(mtmp);
	    return(0);
	} else {
	    nomul(0);
	    if(rn2(ml*10) < (mtmp->mconf ? 100 : 20)) {	/* fumbled attack */
		if (canseemon(mtmp) && flags.soundok)
/*JP		    pline_The("air crackles around %s.", mon_nam(mtmp));*/
		    pline("%sβζϥԥԥꤷƤ롥", mon_nam(mtmp));
		return(0);
	    }
	}
/*
 *	As these are spells, the damage is related to the level
 *	of the monster casting the spell.
 */
	if (mattk->damd)
		dmg = d((int)((ml/3) + mattk->damn), (int)mattk->damd);
	else dmg = d((int)((ml/3) + 1), 6);
	if (Half_spell_damage) dmg = (dmg+1) / 2;

	switch(mattk->adtyp)   {

	    case AD_FIRE:
/*JP		pline("You're enveloped in flames.");*/
		You("ˤĤĤޤ줿");
		if(Fire_resistance) {
			shieldeff(u.ux, u.uy);
/*JP			pline("But you resist the effects.");*/
			pline("ʤϱƶʤ");
			dmg = 0;
		}
		break;
	    case AD_COLD:
/*JP		pline("You're covered in frost.");*/
		You("ɹʤ줿");
		if(Cold_resistance) {
			shieldeff(u.ux, u.uy);
/*JP			pline("But you resist the effects.");*/
			pline("ʤϱƶʤ");
			dmg = 0;
		}
		break;
	    case AD_MAGM:
/*JP		You("are hit by a shower of missiles!");*/
		You("ˡ򤯤ä");
		if(Antimagic) {
			shieldeff(u.ux, u.uy);
/*JP			pline_The("missiles bounce off!");*/
			pline("ˡȿͤ");
			dmg = 0;
		} else dmg = d((int)mtmp->m_lev/2 + 1,6);
		break;
	    case AD_SPEL:	/* random spell */

		mtmp->mspec_used = 10 - mtmp->m_lev;
		if (mtmp->mspec_used < 2) mtmp->mspec_used = 2;
		switch(rn2((int)mtmp->m_lev)) {
		    case 22:
		    case 21:
		    case 20:
/*JP			pline("Oh no, %s's using the touch of death!",
			      humanoid(mtmp->data)
				  ? (mtmp->female ? "she" : "he")
				  : "it"
			     );*/
			pline("ʤƤä%sϻȤäƤ롪",
			      Monnam(mtmp));
			if (nonliving(uasmon) || is_demon(uasmon))
/*JP			    You("seem no deader than before.");*/
			    You("ʤʤΤΤ褦");
			else if (!Antimagic && rn2(ml) > 12) {

			    if(Hallucination)
/*JP				You("have an out of body experience.");*/
				You("ͩΥæθ򤷤");
			    else  {
				killer_format = KILLED_BY_AN;
/*JP				killer = "touch of death";*/
				killer = "";
				done(DIED);
			    }
			} else {
				if(Antimagic) shieldeff(u.ux, u.uy);
/*JP				pline("Lucky for you, it didn't work!");*/
				pline("Τ褤ȤˤʤȤʤä");
			}
			dmg = 0;
			break;
		    case 19:
		    case 18:
			if(mtmp->iswiz && flags.no_of_wizards == 1) {
/*JP				pline("Double Trouble...");*/
				pline("Ŷ");
				clonewiz();
				dmg = 0;
				break;
			} /* else fall into the next case */
		    case 17:
		    case 16:
		    case 15:
			if(mtmp->iswiz)
/*JP			    verbalize("Destroy the thief, my pets!");*/
			    verbalize("±򻦤ͤ衪");
			nasty(mtmp);	/* summon something nasty */
			/* fall into the next case */
		    case 14:		/* aggravate all monsters */
		    case 13:
			aggravate();
			dmg = 0;
			break;
		    case 12:		/* curse random items */
		    case 11:
		    case 10:
			rndcurse();
			dmg = 0;
			break;
		    case 9:
		    case 8:		/* destroy armor */
			if (Antimagic) {
				shieldeff(u.ux, u.uy);
/*JP				pline("A field of force surrounds you!");*/
				pline("Ի׵ĤϤʤȤ꤫");
			} else if(!destroy_arm(some_armor()))
/*JP				Your("skin itches.");*/
				Your("ϥॺॺ");
			dmg = 0;
			break;
		    case 7:
		    case 6:		/* drain strength */
			if(Antimagic) {
			    shieldeff(u.ux, u.uy);
/*JP			    You_feel("momentarily weakened.");*/
			    You("ּ夯ʤä褦ʵ");
			} else {
/*JP			    You("suddenly feel weaker!");*/
			    You("夯ʤä褦ʵ");
			    dmg = ml - 6;
			    if(Half_spell_damage) dmg = (dmg+1) / 2;
			    losestr(rnd(dmg));
			    if(u.uhp < 1)
				done_in_by(mtmp);
			}
			dmg = 0;
			break;
		    case 5:		/* make invisible if not */
		    case 4:
			if (!mtmp->minvis && !mtmp->invis_blkd) {
			    if(canseemon(mtmp) && !See_invisible)
/*JP				pline("%s suddenly disappears!", Monnam(mtmp));*/
				pline("%sä", Monnam(mtmp));
			    mon_set_minvis(mtmp);
			    dmg = 0;
			    break;
			} /* else fall into the next case */
		    case 3:		/* stun */
			if(Antimagic) {
			    shieldeff(u.ux, u.uy);
			    if(!Stunned)
/*JP				You_feel("momentarily disoriented.");*/
				You("Ф򼺤ä");
			    make_stunned(1L, FALSE);
			} else {
			    if (Stunned)
/*JP				You("struggle to keep your balance.");*/
				You("Х󥹤Ȥ⤬");
			    else
/*JP				You("reel...");*/
				You("ᤤ");
			    dmg = d(ACURR(A_DEX) < 12 ? 6 : 4, 4);
			    if(Half_spell_damage) dmg = (dmg+1) / 2;
			    make_stunned(HStun + dmg, FALSE);
			}
			dmg = 0;
			break;
		    case 2:		/* haste self */
			if(mtmp->mspeed == MSLOW)	mtmp->mspeed = 0;
			else				mtmp->mspeed = MFAST;
			dmg = 0;
			break;
		    case 1:		/* cure self */
			if(mtmp->mhp < mtmp->mhpmax) {
			    if((mtmp->mhp += rnd(8)) > mtmp->mhpmax)
				mtmp->mhp = mtmp->mhpmax;
			    dmg = 0;
			    break;
			} /* else fall through to default case */
		    default:		/* psi bolt */
			if(Antimagic) {
			    shieldeff(u.ux, u.uy);
/*JP			    You("get a slight %sache.",body_part(HEAD));*/
			    You("ä%sˤ",body_part(HEAD));
			    dmg = 1;
			} else {
			    if (dmg <= 10)
/*JP				Your("brain is on fire!");*/
			      You("ܤˤĤĤޤ줿");
/*JP			    else Your("%s suddenly aches!", body_part(HEAD));*/
			    else Your("%sˤߤ򴶤", body_part(HEAD));
			}
			break;
		}
		break;
		
	    case AD_CLRC:	/* clerical spell */

		mtmp->mspec_used = 10 - mtmp->m_lev;
		if (mtmp->mspec_used < 2) mtmp->mspec_used = 2;
		switch(rn2((int)mtmp->m_lev)) {
		    /* Other ideas: lightning bolts, towers of flame,
				    gush of water  -3. */

		    default:		/* confuse */
			if(Antimagic) {
			    shieldeff(u.ux, u.uy);
/*JP			    You_feel("momentarily dizzy.");*/
			    You("֤ޤ");
			} else {
			    dmg = (int)mtmp->m_lev;
			    if(Half_spell_damage) dmg = (dmg+1) / 2;
			    make_confused(HConfusion + dmg, TRUE);
			}
			dmg = 0;
			break;
		    case 12:		/* curse random items */
		    case 11:
		    case 10:
			rndcurse();
			dmg = 0;
			break;
		    case 9:
		    case 8:		/* insects */
			/* Try for insects, and if there are none
			   left, go for (sticks to) snakes.  -3. */
			{
			int i;
			struct permonst *pm = mkclass(S_ANT,0);
			struct monst *mtmp2;
			char let = (pm ? S_ANT : S_SNAKE);

			for (i = 0; i <= (int) mtmp->m_lev; i++)
			   if ((pm = mkclass(let,0)) &&
			(mtmp2 = makemon(pm, u.ux, u.uy, NO_MM_FLAGS))) {
				mtmp2->msleep = mtmp2->mpeaceful =
					mtmp2->mtame = 0;
				set_malign(mtmp2);
			    }
			}			
			dmg = 0;
			break;
		    case 6:
		    case 7:		/* blindness */
			/* note: resists_blnd() doesn't apply here */
			if (!Blinded) {
/*JP			    pline("Scales cover your eyes!");*/
			    pline("ڤʤܤʤä");
			    make_blinded(Half_spell_damage ? 100L:200L, FALSE);
			    dmg = 0;
			    break;
			}
		    case 4:
		    case 5:		/* wound */
			if(Antimagic) {
			    shieldeff(u.ux, u.uy);
/*JP			    Your("skin itches badly for a moment.");*/
			    Your("ϰ֡ॹॹäȤ");
			    dmg = 0;
			} else {
/*JP			    pline("Wounds appear on your body!");*/
			    pline("ʤΤ˽褿");
			    dmg = d(2,8) + 1;
			    if (Half_spell_damage) dmg = (dmg+1) / 2;
			}
			break;
		    case 3:		/* hold */
			if(Antimagic) {
			    shieldeff(u.ux, u.uy);
			    if(multi >= 0)
/*JP				You("stiffen briefly.");*/
				You("ֹľ");
			    nomul(-1);
			} else {
			    if (multi >= 0)
/*JP				You("are frozen in place!");*/
				You("ξưʤʤä");
			    dmg = 4 + (int)mtmp->m_lev;
			    if (Half_spell_damage) dmg = (dmg+1) / 2;
			    nomul(-dmg);
			}
			dmg = 0;
			break;
		    case 2:
		    case 1:		/* cure self */
			if(mtmp->mhp < mtmp->mhpmax) {
			    if((mtmp->mhp += rnd(8)) > mtmp->mhpmax)
				mtmp->mhp = mtmp->mhpmax;
			    dmg = 0;
			    break;
			} /* else fall through to default case */
		}
	}
	if(dmg) mdamageu(mtmp, dmg);
	return(1);
}

#endif /* OVLB */
#ifdef OVL0

/* convert 1..10 to 0..9; add 10 for second group (spell casting) */
#define ad_to_typ(k) (10 + (int)k - 1)

int
buzzmu(mtmp, mattk)		/* monster uses spell (ranged) */
	register struct monst *mtmp;
	register struct attack  *mattk;
{
	if(mtmp->mcan || mattk->adtyp > AD_SPC2) {
	    cursetxt(mtmp);
	    return(0);
	}
	if(lined_up(mtmp) && rn2(3)) {
	    nomul(0);
	    if(mattk->adtyp && (mattk->adtyp < 11)) { /* no cf unsigned >0 */
		if(canseemon(mtmp))
/*JP		    pline("%s zaps you with a %s!", Monnam(mtmp),*/
		    pline("%s%s򤢤ʤ˸ä", Monnam(mtmp),
			  flash_types[ad_to_typ(mattk->adtyp)]);
		buzz(-ad_to_typ(mattk->adtyp), (int)mattk->damn,
		     mtmp->mx, mtmp->my, sgn(tbx), sgn(tby));
	    } else impossible("Monster spell %d cast", mattk->adtyp-1);
	}
	return(1);
}

#endif /* OVL0 */

/*mcastu.c*/
