/*
  lbg[NSl
  Satofumi KAMIMURA
  $Id$
*/

#include "nettyping.h"
#include "screenCtrl.h"
#include "fontCtrl.h"
#include "ttfResource.h"
#include "titleSelect.h"
#include "typingPractice.h"
#include "kimarijiPractice.h"
#include "wakaResource.h"
#include "gameOption.h"
#include "soundCtrl.h"
#include "rankingAccess.h"
#include "drawUtils.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>


//////////////////////////////////////////////////////////////////////
// IvV

// IvV̏
static void optionModeInitialize(GameOption& opt) {

  gameOption_t data;
  data.selected = 0;

  // â̓͐
  static Uint16 *pra[] = { optPracticeTTF,
			   n6TTF, n12TTF, n25TTF, n50TTF, n100TTF };
  static char pra_tag[] = "number";
  data.max = 6;
  data.titles = pra;
  data.tag = pra_tag;
  data.selected = 0;
  opt.addData(&data);

  // ϊ
  static Uint16 *con[] = { optConvertTTF, romanTTF, kanaTTF };
  static char con_tag[] = "convert";
  data.max = 3;
  data.titles = con;
  data.tag = con_tag;
  data.selected = 0;
  opt.addData(&data);

  // o悤
  static Uint16 *rem[] = { optRememberTTF, ariTTF, nasiTTF };
  static char rem_tag[] = "learn";
  data.max = 3;
  data.titles = rem;
  data.tag = rem_tag;
  data.selected = 0;
  opt.addData(&data);

  // Webo^AȂ
  static Uint16 *web[] = { optWebEntryTTF, sinaiTTF, suruTTF };
  static char web_tag[] = "web";
  data.max = 3;
  data.titles = web;
  data.tag = web_tag;
  data.selected = 0;
  opt.addData(&data);

  // ʃTCY
  static Uint16 *win[] = { optScreenTTF, fullTTF, normalTTF };
  static char win_tag[] = "win";
  data.max = 3;
  data.titles = win;
  data.tag = win_tag;
  data.selected = 1;
  opt.addData(&data);

  // o̘aID
  static char id_tag[] = "id";
  data.max = 100;
  data.titles = NULL;
  data.tag = id_tag;
  data.selected = 0;
  opt.addData(&data);

  // IvVt@C̓ǂݏo
  opt.loadOption();
}


// IvV[h̊Ǘ
static void optionMode(ScreenCtrl& scr, FontCtrl& ttf, GameOption& opt,
		       SoundCtrl& snd) {

  opt.resetTitleSelected();
  scr.fillBack();

  SDL_Rect pos;
  pos.x = 20;
  pos.y = MENU_FS;
  opt.setSpaceHeight(20);
  scr.initFrameRateCtrl();
  while (1) {
    opt.drawSurface(scr, &pos, ttf, 200);
    
    scr.update();
    scr.frameRateWait();
    unsigned int optState = opt.changeSelect();
    if (optState & UP_DOWN_CHANGE) {
      snd.playEffect(SELECT_EFFECT);
    }
    if (optState & RIGHT_LEFT_CHANGE) {
      snd.playEffect(TYPE_EFFECT);
    }
    if (optState) {
      scr.fillBack();
    }
    userInput_t ui = scr.eventHandler();
    if (ui.quit) {
      gameExit();

    } else if (ui.enter || ui.escape) {
      snd.playEffect(DECIDE_EFFECT);
      opt.saveOption();
      return;
    }
  }
}


//////////////////////////////////////////////////////////////////////
// ^CsOK[h̉

static void typingModeInitialize(titleResource_t *tResource,
				 ScreenCtrl& scr) {
  tResource->ptSize = MENU_FS;
  tResource->color = BLACK;
  tResource->spaceHeight = 11;
  tResource->spaceWidth = 10;
  tResource->title.push_back(toTypeModeTTF);
  tResource->title.push_back(toKimarijiModeTTF);
  tResource->title.push_back(toggleUserTTF);
  tResource->title.push_back(backTTF);
}


// AJEg̕`
void drawAccount(ScreenCtrl& scr, FontCtrl& ttf, string account) {

  int length = account.find(' ');
  Uint16 str[length + 1];
  for (int i = 0; i < length; ++i) {
    str[i] = account[i];
  }
  str[length] = '\0';
  SDL_Surface *text = ttf.createSurface(str, RESULT_FS, BLACK);
  SDL_Rect pos;
  pos.x = scr.w() - RESULT_FS/2;
  pos.y = 0;
  scr.blitSurface(text, NULL, scr.screen(), &pos, RIGHT | TOP);
  SDL_FreeSurface(text);
}


//////////////////////////////////////////////////////////////////////
// ŏ̃^Cg

// Iڃ\[X̏
static void firstTitleInitialize(titleResource_t *tResource,
				       ScreenCtrl& scr) {
  tResource->ptSize = MENU_FS;
  tResource->color = BLACK;
  tResource->spaceHeight = 11;
  tResource->spaceWidth = 10;
  tResource->title.push_back(typeModeTTF);
  tResource->title.push_back(netModeTTF);
  tResource->title.push_back(optionTTF);
  tResource->title.push_back(exitTTF);
}


// ^Cgʂ̍ĕ`
static void redrawSelection(ScreenCtrl& scr, TitleSelect& title) {
  
  // wip^[̓hԂ
  SDL_Rect backArea = title.getDrawArea();
  scr.fillBack(&backArea);

  // Iڂ̕`
  title.drawSurface(scr);
}


static void drawTitle(ScreenCtrl& scr, FontCtrl& ttf) {

  SDL_Rect pos;
  pos.x = scr.w() / 2;
  pos.y = scr.h() / 4;
  SDL_Surface *mainTitle = ttf.createSurface(mainTitleTTF, TITLE_FS, BLACK);
  scr.blitSurface(mainTitle, NULL, scr.screen(), &pos, MIDDLE | CENTER);
  SDL_FreeSurface(mainTitle);
}

  
static void drawVersion(ScreenCtrl& scr, FontCtrl& ttf) {
  char charVersion[] = "Ver." VERSION;
  int length = strlen(charVersion);
  Uint16 *uint16version = new Uint16[length];
  for (int i = 0; i <= length; ++i) {
    uint16version[i] = charVersion[i];
  }
  SDL_Rect pos;
  pos.x = 0;
  pos.y = 0;
  SDL_Surface *versionTTF = ttf.createSurface(uint16version, RUBI_FS, BLACK);
  scr.blitSurface(versionTTF, NULL, scr.screen(), &pos);
  SDL_FreeSurface(versionTTF);
  delete uint16version;
}


// ^Cgʂ̕\
static void firstTitle(ScreenCtrl& scr, FontCtrl& ttf,
		       GameOption& opt, WakaResource& waka,
		       SoundCtrl& snd, RankingAccess& rank,
		       string& data_path) {
  enum GameMode {
    FIRST_TITLE_VIEW,
    TYPING_MODE_VIEW,
    NETWORK_MODE_VIEW,
    OPTION_MODE_VIEW,
    EXIT,
  };

  userInput_t userInput;
  int gameMode = FIRST_TITLE_VIEW;
  int selected = 0;
  while (1) {
    // wip^[̓hԂ
    scr.fillBack();
    
    // ^Cg̕\
    drawTitle(scr, ttf);

    // o[W̕\
    if (gameMode == FIRST_TITLE_VIEW) {
      drawVersion(scr, ttf);
    }

    // I̕\
    titleResource_t tResource;
    TitleSelect *title = NULL;
    SDL_Rect selectPos;

    // Iڃ\[X̏
    string iconFile = data_path;
    iconFile += "selectIcon.bmp";
    switch (gameMode) {
    case FIRST_TITLE_VIEW:
      firstTitleInitialize(&tResource, scr);
      title = new TitleSelect(iconFile.c_str(),
			      &tResource, ttf, selected);
      selectPos.x = scr.w() / 2;
      selectPos.y = scr.h() / 2 - 30;
      snd.playMusic(TITLE_MUSIC);
      break;

    case TYPING_MODE_VIEW:
      typingModeInitialize(&tResource, scr);
      title = new TitleSelect(iconFile.c_str(),
			      &tResource, ttf, selected);
      selectPos.x = scr.w() / 2;
      selectPos.y = scr.h() / 2 - 30;
      snd.playMusic(TITLE_MUSIC);
      break;
    }
    
    // Iڕ\̐ݒ
    title->setDrawPosition(&selectPos, TOP | CENTER);

    // Iڂ̕`
    redrawSelection(scr, *title);

    // ^CsOK Webo^ꍇAAJEg\
    if ((gameMode == TYPING_MODE_VIEW) && rank.isActive() &&
	(opt.getSelected("web") == 1)) {
      drawAccount(scr, ttf, rank.getAccount());
    }

    // Cxg[v
    int pre_selected = selected;
    scr.initFrameRateCtrl();
    while (1) {    
      // Iڂ̍ĕ`
      if (selected != pre_selected) {
	pre_selected = selected;
	redrawSelection(scr, *title);
	if (selected != -1) {
	  snd.playEffect(SELECT_EFFECT);
	}
      }

      // XV
      snd.update();
      scr.update();
      
      // t[[g̊Ǘ
      scr.frameRateWait();
      
      // [UCxg̏
      selected = title->selectChange();
      userInput = scr.eventHandler();
      if (userInput.quit) {
	// Q[̏I
	gameExit();
	
      } else if (userInput.escape) {
	// Ỏʂɖ߂
	selected = title->getMaxSelection();
	break;

      } else if (userInput.enter || userInput.leftclick) {
	// IĂ郂[hɑJ
	break;
      }
    }
    
    // Iڕwi摜ɂăNA
    pre_selected = 0;
    SDL_Rect backArea = title->getDrawArea();
    scr.fillBack(&backArea);
    
    // Iڂɂ镪򏈗
    if (gameMode == FIRST_TITLE_VIEW) {
      if (selected == 0) {	// u^CsOKv
	gameMode = TYPING_MODE_VIEW;
	selected = 0;
	snd.playEffect(DECIDE_EFFECT);
	
      } else if (selected == 1){ // ulbgΐ탂[hv
	selected = 0;
	fprintf(stderr, "net battle mode\n");
	snd.playEffect(DECIDE_EFFECT);

      } else if (selected == 2) { // uIvVύXv[h
	selected = 0;
	snd.playEffect(DECIDE_EFFECT);
	optionMode(scr, ttf, opt, snd);

      } else if (selected == 3) { // I
	gameExit();
      }
      
    } else if (gameMode == TYPING_MODE_VIEW) {
      if (selected == 0) {	// ̋^CsO
	snd.playMusic(-1);
	typingPractice(scr, opt, ttf, waka, snd, rank);
      } else if (selected == 1) { // ܂̗K
	snd.playMusic(-1);
	kimarijiPractice(scr, opt, ttf, waka, snd, rank);
      } else if (selected == 2) { // [UύX
	snd.playEffect(DECIDE_EFFECT);
	if (rank.toggleUserInfo()) {
	  rank.save();
	}
      } else if (selected == 3) { // ߂
	gameMode = FIRST_TITLE_VIEW;
	selected = 0;
	snd.playEffect(CANCEL_EFFECT);
      }
    }

    delete title;
  }
}


//////////////////////////////////////////////////////////////////////

// ʉf[^̏
void soundDataInit(SoundCtrl& snd) {

  // ʉ
  snd.loadEffect("select.wav");
  snd.loadEffect("decide.wav");
  snd.loadEffect("cancel.wav");
  snd.loadEffect("begin.wav");
  snd.loadEffect("key.wav");
  snd.loadEffect("clear.wav");

  // 
  snd.loadMusic("music1.mp3");
  snd.loadMusic("music2.mp3");
}


int main(int argc, char *argv[]) {

  // nꂽ̉
  int screen_mode = 0;
  int sound_mode = USE_SOUND;
  try {
    string data_path;
#ifdef __MINGW32__
    data_path = "data/";
#else
    data_path += PKGDATADIR;
    data_path += "/";
#endif
    
    // Q[IvV̓ǂݍ
#ifdef __MINGW32__
    GameOption opt("options.txt");
#else
    // \[Xꏊ̒`
    string userFileDir = getenv("HOME");
    userFileDir += '/';
    string optFile = userFileDir;
    optFile += ".nettypingrc";
    GameOption opt(optFile.c_str());
#endif
    optionModeInitialize(opt);
    screen_mode |= (opt.getSelected("win") == 0) ? SDL_FULLSCREEN : 0;

    // IvV̐ݒR}hCɂď㏑
    for (int i = 1; i < argc; ++i) {
      if (!strcmp("-fs", argv[i])) {
	// ÑtXN[[hw
	screen_mode |= SDL_FULLSCREEN;
	
      } else if (!strcmp("-nosound", argv[i])) {
	// TEhȂ
	sound_mode = NO_SOUND;
      }
    }

    // ʎ̏
    ScreenCtrl scr(screen_mode);
    scr.setFPS(FPS);
    SDL_WM_SetCaption("netTyping", "netTyping");
    
    // J[\ʒuIɁAɕύX
    SDL_WarpMouse(32, 32);

    // ʉ̏
    SoundCtrl snd((sound_mode == NO_SOUND) ? NO_SOUND : 22050);
    snd.loadDirectory(data_path.c_str());
    soundDataInit(snd);

    // ãf[^̓ǂݍ
    WakaResource waka;
    
    // tHg̏
    string fontFile = data_path;
    fontFile += "font.ttf";
    FontCtrl ttf(fontFile.c_str());

    // wi摜̐ݒ
    string backImageFile = data_path;
    backImageFile += "back.bmp";
    scr.setBackImage(backImageFile.c_str());

    // LOp̃AJEgm
#ifdef __MINGW32__
    RankingAccess rank("web_ranking.txt");
#else
    string rankFile = userFileDir;
    rankFile += ".nettypingrc_web";
    RankingAccess rank(rankFile.c_str());
#endif

    // ^Cgʂ
    firstTitle(scr, ttf, opt, waka, snd, rank, data_path);

  } catch (...) {
    fprintf(stderr, "Unknown error.\n");
  }
  
  return 0;
}
