#ifndef TITLE_SELECT_H
#define TITLE_SELECT_H

/*
  ڑI̊Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include <vector>
#include "fontCtrl.h"
#include "screenCtrl.h"


// ^Cg̃\[X
typedef struct {
  vector<Uint16 *> title;	// \ Unicode ւ̃|C^
  int ptSize;			// TCY
  Uint32 color;			// F
  int spaceHeight;		// ڂ̊Ԋu
  int spaceWidth;		// ACRƍڂ̊Ԋu
} titleResource_t;


// 쐬^Cg̃}EXIp
typedef struct {
  SDL_Surface *icon;		// ACR
  vector<SDL_Surface *> title;	// \
} titleSurfaceInfo_t;


// ڑI̊Ǘ
class TitleSelect {
  titleSurfaceInfo_t titleSurface;
  SDL_Rect position;		// T[tFXŜ̕\ʒu
  int spaceHeight;		// ڂ̊Ԋu
  int spaceWidth;		// ACRƍڂ̊Ԋu
  int selected;			// I𒆂̔ԍ
  int maxSelection;		// Iڂ̍őID
  int maxSurfaceWidth;		// ڃT[tFX̍ő咷
  int totalSurfaceHeight;	// \̒

  TitleSelect(void);

public:
  // ACRAڏw肵ď
  TitleSelect(const char *iconFile, titleResource_t *tResource, FontCtrl& fnt,
	      int defaultSelect);
  ~TitleSelect(void);

  // T[tFX̕\ʒuݒ
  void setDrawPosition(SDL_Rect *pos, int align);

  // T[tFX̕`͈͂̎擾
  SDL_Rect getDrawArea(void);

  // T[tFX̕\
  void drawSurface(ScreenCtrl& scr);
  
  // }EXAL[͂ɂI̐ݒ
  int selectChange(void);

  // Iڂ̍őID擾
  int getMaxSelection(void);
};


class TitleSelectError {
public:
  virtual void debug_print(void) const {
    fprintf(stderr, "TitleSelect error\n");
  }
};


class No_Icon_File : public TitleSelectError {
  const char *imageFile;
  
public:
  No_Icon_File(const char *fName) { imageFile = fName; }
  virtual void degug_print(void) const {
    fprintf(stderr, "not such file : %s\n", imageFile);
 }
};

#endif /* !TITLE_SELECT_H */
	  
