/*
  ʉ̊ǗNX
  Satofumi KAMIMURA
  $Id$
*/

#include "soundCtrl.h"
#include <SDL.h>


// Ȃo^
int SoundCtrl::loadMusic(const char *fname) {
  if (!initialized) {
    return -1;
  }

  string path = dir;
  path += fname;
  Mix_Music *mus = Mix_LoadMUS(path.c_str());
  int id = music.size();
  music.push_back(mus);
  if (!mus) {
    fprintf(stderr, "Mix_LoadMUS fail: %s\n", fname);
    return -1;
  }
  
  return id;
}


// o^ĂȂɐ؂ւ
void SoundCtrl::playMusic(int id) {
  if (!initialized) {
    return;
  }

  nextPlay = id;
  if ((id < 0) || (id >= (int)music.size()) || (!music[id])) {
    nextPlay = -1;
  }
}


// ʉo^
int SoundCtrl::loadEffect(const char *fname) {
  if (!initialized) {
    return -1;
  }

  string path = dir;
  path += fname;
  Mix_Chunk *eff = Mix_LoadWAV(path.c_str());
  int id = effect.size();
  effect.push_back(eff);
  if (!eff) {
    fprintf(stderr, "Mix_LoadWAV fail: %s\n", fname);
    return -1;
  }
  
  return id;
}


// o^Ăʉ炷
void SoundCtrl::playEffect(int id) {
  if (!initialized) {
    return;
  }

  if (id == -1) {
    Mix_FadeOutChannel(-1, 750);
    return;
  }
  
  if ((id < 0) || (id >= (int)effect.size()) || (!effect[id])) {
    return;
  }
  if (effect[id]) {
    Mix_PlayChannel(-1, effect[id], 0);
  }
}


// Ȃ̐؂ւȂǂ̏
void SoundCtrl::update(void) {
  if (!initialized) {
    return;
  }

  if (nowPlaying == nextPlay) {
    return;
    
  } else if (Mix_FadingMusic()) {
    // tF[h́A؂ւȂ
    return;
    
  } else if (nowPlaying == -1) {

    // tF[hC
    if (music[nextPlay]) {
      Mix_FadeInMusic(music[nextPlay], -1, 1000);
    }
    nowPlaying = nextPlay;
    
  } else {
    nowPlaying = -1;
    // tF[hAEg
    Mix_FadeOutMusic(1000);
  }
  return;
}


// f[^ǂݏofBNgw肷
void SoundCtrl::loadDirectory(const char *dirname) {
  dir = dirname;
}


// SDL_mixer ̏
SoundCtrl::SoundCtrl(int frequency)
  : nowPlaying(-1), nextPlay(-1), initialized(false), dir("./") {

  if (frequency == NO_SOUND) {
    return;
  }

  // AUDIO ɏς݂̏ꍇ
  if (SDL_WasInit(SDL_INIT_AUDIO) != 0) {
    return;
  }

  if (SDL_InitSubSystem(SDL_INIT_AUDIO) < 0) {
    fprintf(stderr, "SDL_SubsystemInit: %s\n", SDL_GetError());
    exit(1);
  }

  if (Mix_OpenAudio(frequency, MIX_DEFAULT_FORMAT, 2, 1024) < 0) {
    fprintf(stderr, "Mix_OpenAudio: %s\n", Mix_GetError());
    exit(1);
  }
  atexit(Mix_CloseAudio);

  Mix_AllocateChannels(8);

  effect.clear();
  music.clear();

  initialized = true;
}


// SDL_mixer ̉
SoundCtrl::~SoundCtrl(void) {
  // ̉
  for (vector<Mix_Music *>::iterator it = music.begin();
       it != music.end(); ++it) {
    Mix_FreeMusic(*it);
  }
  for (vector<Mix_Chunk *>::iterator it = effect.begin();
       it != effect.end(); ++it) {
    Mix_FreeChunk(*it);
  }
}
