/*
  ^CsOK̏
  Satofumi KAMIMURA
  $Id$
*/

#include "typingPractice.h"
#include "nettyping.h"
#include "wakaDraw.h"
#include "convert.h"
#include "keyType.h"
#include "timer.h"
#include "resultData.h"
#include "rankingAccess.h"
#include "drawUtils.h"


extern Uint16 toTypeModeTTF[];
extern Uint16 resultTitleTTF[];
extern Uint16 resultWakaNumTTF[];
extern Uint16 resultInputAverageTTF[];
extern Uint16 resultDelayAverageTTF[];
extern Uint16 resultTypeSpeedTTF[];
extern Uint16 resultUseDeleteTTF[];
extern Uint16 resultTotalTTF[];

extern Uint16 syuTTF[];
extern Uint16 secTTF[];
extern Uint16 perSecTTF[];
extern Uint16 perMinTTF[];
extern Uint16 kaiTTF[];
extern Uint16 tenTTF[];


enum TypingModePractice {
  BEFORE_TYPE,			// ^CsOO
  TYPE_FIRST,			// ̋P̃^CsO
  TYPE_SECAND,			// ̋Q̃^CsO
  AFTER_TYPE,			// ^CsO
  VIEW_RESULT,			// ʕ\

  SIMO_NONE,
  SIMO_FIRST = 3,
  SIMO_SECAND = 4,

  TYPING_AREA_SIZE = 19,
  
  ESCAPE_QUIT_TIMES = 2,	// AłŃ^CsO[h𔲂

  WAKA_DRAW_TIME = 10000, 	// â̕`ɂ鎞
  RESULT_DRAW_TIME = 2000,	// ʕ\ɂ鎞
  END_DELAY_TIME = 4000,	// ͌̋xe
};


// ^CsǑʕ\
static void resultDrawMode(ScreenCtrl& scr, FontCtrl& ttf, SoundCtrl& snd,
			   ResultData& result, RankingAccess& rank,
			   GameOption& opt) {
  
  result.profile();

  // WebT[oɓo^
  if (rank.isActive() && (opt.getSelected("web") == 1)) {
    rank.sendTypingInfo(result, opt.getSelected("convert"));
  }

  SDL_Rect titlePos, resultPos;
  enum { SPACE = 10, UP = 6, };
  
  // ^Cg\
  scr.fillBack();
  titlePos.x = scr.w()/2;
  titlePos.y = RESULT_FS;

  SDL_Surface *text = ttf.createSurface(resultTitleTTF, MENU_FS, BLACK);
  scr.blitSurface(text, NULL, scr.screen(), &titlePos, CENTER);
  titlePos.y += text->h + SPACE;
  SDL_FreeSurface(text);

  char char_str[15];
  titlePos.x = MENU_FS/2 * 4;
  titlePos.y += RESULT_FS/2 * 4;
  resultPos.x = scr.w() - MENU_FS/2*7;
  resultPos.y = titlePos.y - UP;

  int counter = 0;
  int percentage = 0;
  int draw = false;
  scr.initFrameRateCtrl();
  while (1) {
    ++counter;
    int pre_percentage = percentage;
    percentage = (counter * (1000/FPS +1) > RESULT_DRAW_TIME) ? 100
      : (int)(100.0 * counter * (1000/FPS +1) / RESULT_DRAW_TIME);
    draw = (pre_percentage == percentage) ? false : true;

    // u͂â̐v xx[]
    if (draw && percentage == 14) {
      snd.playEffect(TYPE_EFFECT);
      sprintf(char_str, "%3d", result.getDataNum());
      char_str[3] = '\0';
      drawResultText(scr, ttf, resultWakaNumTTF, char_str, syuTTF,
		     &titlePos, &resultPos);
      titlePos.y += RESULT_FS + SPACE;
      resultPos.y = titlePos.y - UP;
    }

    // uâ̕ϓ͎ԁv xx [b]
    if (draw && percentage == 14 * 2) {
      snd.playEffect(TYPE_EFFECT);
      sprintf(char_str, "%11.1f",
	      result.getTotalSpentTime() / 1000.0 / result.getDataNum());
      char_str[14] = '\0';
      drawResultText(scr, ttf, resultInputAverageTTF, char_str, secTTF,
		     &titlePos, &resultPos);
      titlePos.y += RESULT_FS + SPACE;
      resultPos.y = titlePos.y - UP;
    }

    // uς̓͊Jnԁv xx [b]
    if (draw && percentage == 14 * 3) {
      snd.playEffect(TYPE_EFFECT);
      sprintf(char_str, "%11.1f",
	      result.getStartDelayTotal() / 1000.0 / result.getDataNum());
      char_str[14] = '\0';
      drawResultText(scr, ttf, resultDelayAverageTTF, char_str, secTTF,
		     &titlePos, &resultPos);
      titlePos.y += RESULT_FS + SPACE;
      resultPos.y = titlePos.y - UP;
    }

    // u^CsOxv xx [/]
    if (draw && percentage == 14 * 4) {
      snd.playEffect(TYPE_EFFECT);
      sprintf(char_str, "%11.1f", result.getPressedNumPerMinute());
      char_str[14] = '\0';
      drawResultText(scr, ttf, resultTypeSpeedTTF, char_str, perMinTTF,
		     &titlePos, &resultPos);
      titlePos.y += RESULT_FS + SPACE;
      resultPos.y = titlePos.y - UP;
    }

    // u^CsOxv xx [/b]
    if (draw && percentage == 14 * 5) {
      snd.playEffect(TYPE_EFFECT);
      sprintf(char_str, "%11.1f", result.getPressedNumPerMinute() / 60.0);
      char_str[14] = '\0';
      drawResultText(scr, ttf, NULL, char_str, perSecTTF,
		     &titlePos, &resultPos);
      titlePos.y += RESULT_FS + SPACE;
      resultPos.y = titlePos.y - UP;
    }

    // u폜L[̗pv
    if (draw && percentage == 14 * 6) {
      snd.playEffect(TYPE_EFFECT);
      sprintf(char_str, "%3d/%d\n",
	      result.getTotalMiss(), result.getTotalPressedNum());
      int i;
      for (i = 0; char_str[i] != '\n'; ++i)
	;
      char_str[i] = '\0';
      drawResultText(scr, ttf, resultUseDeleteTTF, char_str, kaiTTF,
		     &titlePos, &resultPos);
      titlePos.y += RESULT_FS + SPACE;
      resultPos.y = titlePos.y - UP;
    }

    // uv
    if (draw && percentage == 14 * 7) {
      snd.playEffect(DECIDE_EFFECT);
      titlePos.y += MENU_FS;
      resultPos.y = titlePos.y;
      SDL_Rect line;
      line.h = 4;
      line.w = scr.w() - MENU_FS * 2;
      line.x = MENU_FS;
      line.y = titlePos.y;
      scr.fillColor(&line, BLACK);
      text = ttf.createSurface(resultTotalTTF, TYPE_FS, BLACK);
      scr.blitSurface(text, NULL, scr.screen(), &titlePos, BOTTOM);
      titlePos.y += text->h + SPACE;
      SDL_FreeSurface(text);
      
      // _
      Uint16 str[13];
      sprintf(char_str, "%12d", result.getTotalScore());
      for (int i = 0; i < 12; ++i) {
	str[i] = char_str[i];
      }
      str[12] = '\0';
      text = ttf.createSurface(str, TYPE_FS, BLACK);
      scr.blitSurface(text, NULL, scr.screen(), &resultPos, RIGHT | BOTTOM);
      SDL_FreeSurface(text);
      
      // [_]
      text = ttf.createSurface(tenTTF, RUBI_FS, BLACK);
      scr.blitSurface(text, NULL, scr.screen(), &resultPos, LEFT | BOTTOM);
      SDL_FreeSurface(text);
    }

    snd.update();
    scr.update();
    scr.frameRateWait();
    userInput_t ui = scr.eventHandler();
    if (ui.quit) {
      gameExit();
    } else if (ui.escape || ui.enter || ui.leftclick) {
      snd.playMusic(-1);
      snd.playEffect(-1);
      return;
    }
  }
}


// ͌̕\
static void drawSample(ScreenCtrl& scr, FontCtrl& ttf,
		       int draw_sample, wakaResource_t *wakaData,
		       const SDL_Rect *position) {
  
  // `̈̃NA
  SDL_Rect pos = *position;
  pos.h = TYPE_FS;
  pos.w = TYPE_FS * 8;
  scr.fillBack(&pos);
  if (draw_sample == SIMO_NONE) {
    return;
  }

  // Tv̕`
  SDL_Surface *ku =
    ttf.createSurface(wakaData->yomi[draw_sample], TYPE_FS, BLACK);
  scr.blitSurface(ku, NULL, scr.screen(), &pos);
  SDL_FreeSurface(ku);
}


// ű^CsOṽXg[[Ǘ
void typingPractice(ScreenCtrl& scr, GameOption& opt,
		    FontCtrl& ttf, WakaResource& waka,
		    SoundCtrl& snd, RankingAccess& rank) {

  // Jňʉ
  Timer soundTimer;
  snd.playEffect(BEGIN_EFFECT);

  // â̎擾
  int wakaIdMax = 100;
  for (int i = 0, to = 4 - opt.getSelected("number"); i < to; ++i) {
    wakaIdMax >>= 1;
  }
  
  // ȁ̎擾
  waka.clearWakaInfo();
  waka.unsort();
  if (opt.getSelected("learn") == 0) {
    waka.setLearnIdSet(opt.getSelected("id"), wakaIdMax);
  }
  
  resultData_t rd[100];
  ResultData result;

  // Ԃ̊Ǘ
  int mode = BEFORE_TYPE;
  
  // ̓Tv̕\ꏊA͈͂ݒ
  SDL_Rect inputSample;
  inputSample.x = scr.w()/2 - TYPE_FS*7/2 - TYPE_FS/2;
  inputSample.y = scr.h()/2 + TYPE_FS * 2;
  inputSample.w = TYPE_FS * 8;
  inputSample.h = TYPE_FS;
    
  // ͗̕\ꏊA͈
  SDL_Rect inputArea = inputSample;
  inputArea.y += TYPE_FS/2 * 3;
  inputArea.w = TYPE_FS * TYPING_AREA_SIZE/2;
  inputArea.h = TYPE_FS;

  // ʉ̏I҂
  if (!waitFirstMusicEnd(5000, scr, ttf, snd, soundTimer, toTypeModeTTF)) {
    return;
  }
  snd.playMusic(TYPE_MUSIC);

  Convert cnv( (opt.getSelected("convert") == 0) ?
	       ROMAN_CONVERT : KANA_CONVERT );
  KeyType type;
  bool wiped = false;
  // â̕\
  for (int number = 0; number < wakaIdMax; ++number) {
    // ʂ̓hԂ
    scr.fillBack();

    // â̐`
    drawTotalWakaTyped(scr, ttf, number+1, wakaIdMax);

    wakaResource_t wResource = waka.getUnsortedWakaInfo();
    WakaDraw wd(&wResource);

    SDL_Rect base = wd.createSurface(ttf);

    // â̕\ꏊ
    SDL_Rect wakaPos = base;
    wakaPos.x = scr.w()/2 - base.w/2;
    wakaPos.y = TYPE_FS/2 + TYPE_FS * 2;

    mode = TYPE_FIRST;

    cnv.clearBuffer();
    result.clearResultStruct(&rd[number], wResource.id, wResource.kimariji);

    int counter = 0;
    int percentage = 0;
    int draw_sample = SIMO_NONE;
    int pre_draw_sample = draw_sample;
    bool inputAreaRedraw = true;
    Timer nextModeTimer;
    Timer inputTimer;
    int escape_count = 0;
    scr.initFrameRateCtrl();
    while (1) {
      ++counter;
      percentage = (counter * (1000/FPS +1) > WAKA_DRAW_TIME) ? 100
	: (int)(100.0 * counter * (1000/FPS +1) / WAKA_DRAW_TIME);
      if (mode == AFTER_TYPE) {
	percentage = 100;
      }

      // ̓Tv̕\
      if ((percentage == 60) && (mode == TYPE_FIRST)) {
	draw_sample = SIMO_FIRST;
      } else if ((percentage == 80) && (mode == TYPE_SECAND)) {
	draw_sample = SIMO_SECAND;
      }

      if ((pre_draw_sample != draw_sample) &&
	  ((mode == TYPE_FIRST) || (mode == TYPE_SECAND))) {
	drawSample(scr, ttf, draw_sample, &wResource, &inputSample);
	pre_draw_sample = draw_sample;
	--percentage;
	
      } else {
	// â̕\
	if (percentage < 100) {
	  wd.drawSurface(&wakaPos, scr, ttf, percentage);
	}
      }

      // ͗̕\
      if (inputAreaRedraw && ((mode == TYPE_FIRST) || (mode == TYPE_SECAND))) {
	inputAreaRedraw = false;
	drawInputArea(scr, ttf, &inputArea, cnv, DRAW);
      }

      // XV
      snd.update();
      scr.update();

      // t[[gnh
      scr.frameRateWait();

      // ͕̏nh
      if (((mode == TYPE_FIRST) || (mode == TYPE_SECAND))) {
	inputAreaRedraw = type.inputHandler(scr, cnv, TYPING_AREA_SIZE-2,
					    &rd[number],
					    (mode == TYPE_FIRST) ?
					    inputTimer.getTime() : 0);
      }
      userInput_t ui = scr.eventHandler();
#ifndef __MINGW32__
      if (inputAreaRedraw) {
	snd.playEffect(TYPE_EFFECT);
      }
#endif
      // ͂̐
      int ku_index = (mode == TYPE_FIRST) ? 3 : 4;
      if (((mode == TYPE_FIRST) || (mode == TYPE_SECAND)) &&
	  type.compareBuffer((Uint16 *)wResource.yomi[ku_index],
			     cnv.getConvertBuffer())) {
	snd.playEffect(DECIDE_EFFECT);
	cnv.clearBuffer();
	
	if (mode == TYPE_FIRST) {
	  mode = TYPE_SECAND;
	  // Tv\̕ύX
	  if (percentage >= 80) {
	    draw_sample = SIMO_SECAND;
	  } else {
	    draw_sample = SIMO_NONE;
	  }
	  
	} else if (mode == TYPE_SECAND) {
	  mode = AFTER_TYPE;
	  nextModeTimer.reset();
	  percentage = 100;
	  counter = 0;
	  inputAreaRedraw = false;
	  
	  // ͎Ԃ̊m
	  rd[number].spentTime = inputTimer.getTime();
	  
	  // ^CsOʂɃf[^ǉ
	  result.addData(&rd[number]);
	  
	  // â݂̂`
	  scr.fillBack(&inputSample);
	  drawInputArea(scr, ttf, &inputArea, cnv, CLEAR);
	  wd.drawSurface(&wakaPos, scr, ttf, DRAW_ALL);
	  
	  // WIɊoĂâf͂łǂ
	  if ((opt.getSelected("learn") == 0) &&
	      (opt.getSelected("id") == wResource.id) && 
	      ((rd[number].startDelay-rd[number].kimariji*2000/5) < 2000)) {
	    int next_id = (opt.getSelected("id") + 1 >= 100) ?
	      0 : opt.getSelected("id") + 1;
	    opt.setSelected("id", next_id);
	    opt.saveOption();
	  }
	}
      }
      
      if (ui.quit) {
	// Q[̏I
	gameExit();
	
      } else if (ui.escape) {
	// ϊobt@̃NA
	if (cnv.getBufLen()) {
	  cnv.clearBuffer();
	  ++(rd[number].pressedNum);
	  ++(rd[number].deletePressed);
	  inputAreaRedraw = true;
	  escape_count = 0;
	  
	} else if (++escape_count >= ESCAPE_QUIT_TIMES) {
	  // obt@̏Ԃ ESC AłƁA
	  snd.playMusic(-1);
	  snd.playEffect(-1);
	  // Ỏʂɖ߂
	  return;
	}
	
      } else if (mode == AFTER_TYPE) {
	if (!wiped && (nextModeTimer.getTime() > END_DELAY_TIME/4)) {
	  scr.wipeBack(END_DELAY_TIME/2);
	  wiped = true;
	}
	if (nextModeTimer.isOver(END_DELAY_TIME)) {
	  wiped = false;
	  break;
	}
      }
    }
  }
  // ^CsOǏʕ\
  resultDrawMode(scr, ttf, snd, result, rank, opt);

  if (opt.getSelected("learn") == 0) {    
    // uo悤v[h
    int ids[5];
    int max = (result.getDataNum() > 5) ? 5 : result.getDataNum();
    result.getSlowInputWakaId(ids, max);
    learnMode(scr, ttf, snd, waka, ids, max);
  }
}
