#ifndef WAKA_DRAW_H
#define WAKA_DRAW_H

/*
  â̕\Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include <SDL.h>
#include <vector>
#include "nettyping.h"
#include "screenCtrl.h"
#include "wakaResource.h"
#include "fontCtrl.h"

enum WakaDrawEnum {
  DRAW_ALL = 119,
};


// r̍\
typedef struct {
  int ku;			// 
  int start;			// Jn̕Ԗ
  int end;			// I̕Ԗ
  Uint16 rubi[8];		// r Unicode 
} rubiInfo_t;


class WakaDraw {
  wakaResource_t *wakaResource;
  SDL_Rect base;		// a̕\̃T[tFXTCY
  SDL_Surface *moji[8];
  vector<rubiInfo_t> rubiInfo;
  unsigned int rubiInfo_index;

  int getUniLen(Uint16 line[]);
  bool isHiragana(Uint16 wch);
  void createRubiInfo(int ku_index, Uint16 ku_kanji[], Uint16 ku_yomi[]);
  void drawSubSurface(ScreenCtrl& scr, SDL_Rect *position,
		      FontCtrl& ttf, Uint16 line[], int percentage);
  void drawRubi(ScreenCtrl& scr, SDL_Rect *position, FontCtrl& ttf,
		int percentage);
  WakaDraw(void);
  
public:
  SDL_Rect createSurface(FontCtrl& ttf);
  void drawSurface(const SDL_Rect *position, ScreenCtrl& scr,
		   FontCtrl& ttf, int percentage);

  WakaDraw(wakaResource_t *wResource);
};


#endif /* !WAKA_DRAW_H */
