<?php
/**
@breif View Class for newbb 
@author yoshis
@version $Id: NewbbViewForm.class.php,v 1.73 2007/03/16 09:48:26 yoshis Exp $
*/
define("FORUMDATA_SELECTIONS","t.topic_id, t.topic_title, t.topic_time, t.topic_status, t.topic_sticky, t.topic_last_post_id, f.forum_id, f.forum_name, f.forum_access, f.forum_type, f.allow_html, f.allow_sig, f.posts_per_page, f.hot_threshold, f.topics_per_page");

include_once 'class.forumposts.php';

class NewbbViewForm extends ForumPosts{
	var $viewmode;
	var $order;
	var $forumdata;
	var $bbImage;
	var $can_post;
	var $show_reg;
	var $accesserror;
	var $isadminormod;
	var $foundusers;
	var $err_url;
	var $err_msg;

	function NewbbViewForm(){
		global $xoopsDB,$xoopsTpl,$xoopsUser,$xoopsModule,$xoopsConfig;
		$this->can_post = 0;
		$this->show_reg = 0;
		$this->foundusers = array();	// for cache as ShowTree
		
		$forum_id = isset($_GET['forum']) ? intval($_GET['forum']) : 0;
		$topic_id = isset($_GET['topic_id']) ? intval($_GET['topic_id']) : 0;
		$topic_time = (isset($_GET['topic_time'])) ? intval($_GET['topic_time']) : 0;
		if ( empty($forum_id) ) {
			$this->err_url = XOOPS_URL."/modules/".$xoopsModule->getVar('dirname')."/index.php";
			$this->err_msg = _MD_ERRORFORUM;
			return;
		} elseif ( empty($topic_id) ) {
			$this->err_url = 'viewforum.php?forum='.$forum_id;
			$this->err_msg = _MD_ERRORTOPIC;
			return;
		}
		//use users preferences
		if (is_object($xoopsUser)) {
			$this->viewmode = $xoopsUser->getVar('umode');
			$this->order = ($xoopsUser->getVar('uorder') == 1) ? 'DESC' : 'ASC';
		} else {
			$this->viewmode = $xoopsConfig['com_mode'];						// 'flat' or 'thread';
			$this->order = $xoopsConfig['com_order']==1 ? 'DESC' : 'ASC';		// 'ASC';
		}
		// newbb does not have nested mode
		if ($this->viewmode == 'nest') {
			$this->viewmode = 'thread';
		}
		// override mode/order if any requested
		if (isset($_GET['viewmode']) && ($_GET['viewmode'] == 'flat' || $_GET['viewmode'] == 'thread')) {
			$this->viewmode = $_GET['viewmode'];
		}
		if (isset($_GET['order']) && ($_GET['order'] == 'ASC' || $_GET['order'] == 'DESC')) {
			$this->order = $_GET['order'];
		}
		if ( isset($_GET['move']) && 'next' == $_GET['move'] ) {
			$sql = 'SELECT ' . FORUMDATA_SELECTIONS .' FROM '.$xoopsDB->prefix('bb_topics')
				.' t LEFT JOIN '.$xoopsDB->prefix('bb_forums').' f ON f.forum_id = t.forum_id'
				.' WHERE t.topic_time > '.$topic_time.' AND t.forum_id = '.$forum_id.' ORDER BY t.topic_time ASC LIMIT 1';
		} elseif ( isset($_GET['move']) && 'prev' == $_GET['move']) {
			$sql = 'SELECT ' . FORUMDATA_SELECTIONS .' FROM '.$xoopsDB->prefix('bb_topics')
				.' t LEFT JOIN '.$xoopsDB->prefix('bb_forums').' f ON f.forum_id = t.forum_id'
				.' WHERE t.topic_time < '.$topic_time.' AND t.forum_id = '.$forum_id.' ORDER BY t.topic_time DESC LIMIT 1';
		} else {
			$sql = 'SELECT ' . FORUMDATA_SELECTIONS .' FROM '.$xoopsDB->prefix('bb_topics')
				.' t LEFT JOIN '.$xoopsDB->prefix('bb_forums').' f ON f.forum_id = t.forum_id'
				.' WHERE t.topic_id = '.$topic_id.' AND t.forum_id = '.$forum_id;
		}
		if ( !$result = $xoopsDB->query($sql) ) {
			$this->err_url = 'viewforum.php?forum='.$forum_id;
			$this->err_msg = _MD_ERROROCCURED;
			return;
		}
		if ( !$this->forumdata = $xoopsDB->fetchArray($result) ) {
			$this->err_url = 'viewforum.php?forum='.$forum_id;
			$this->err_msg = _MD_FORUMNOEXIST;
			return;
		}
		parent::setForum($this->forumdata['forum_id']);
		parent::setSubject($this->forumdata['topic_title']);
		parent::setTopicId($this->forumdata['topic_id']);
		$xoopsTpl->assign('topic_id', $this->forumdata['topic_id']);
		$xoopsTpl->assign('forum_id', $this->forumdata['forum_id']);
	}
	function order(){
		return $this->order;
	}
	function ErrorOccured(){
		if(isset($this->err_msg)) return true;
		else return false;
	}
	function forum_type(){
		return $this->forumdata['forum_type'];
	}
	function forum_access(){
		return $this->forumdata['forum_access'];
	}
	function topic_id(){
		return $this->forumdata['topic_id'];
	}
	function forum_id(){
		return $this->forumdata['forum_id'];
	}
	function posts_per_page(){
		return $this->forumdata['posts_per_page'];
	}
	function allow_sig(){
		return $this->forumdata['allow_sig'];
	}
	function topic_time(){
		return $this->forumdata['topic_time'];
	}
	function SetUserStatus(){
		global $xoopsUser,$xoopsModule;
		if ( $this->forum_type() == 1 ) {
			// this is a private forum.
			$accesserror = 0;
			if ( $xoopsUser ) {
				if ( !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
					if ( !check_priv_forum_auth($xoopsUser->getVar('uid'), $this->forum_id(), false) ) {
						$accesserror = 1;
					}
				}
			} else {
				$accesserror = 1;
			}
			if ( $accesserror == 1 ) {
				redirect_header("index.php",2,_MD_NORIGHTTOACCESS);
				exit();
			}
			$this->can_post = 1;
			$this->show_reg = 1;
		} else {
			// this is not a priv forum
			if ( $this->forum_access() == 1 ) {
				// this is a reg user only forum
				if ( $xoopsUser ) {
					$this->can_post = 1;
				} else {
					$this->show_reg = 1;
				}
			} elseif ( $this->forum_access() == 2 ) {
				// this is an open forum
				$this->can_post = 1;
			} else {
				// this is an admin/moderator only forum
			}
		}
		$this->isadminormod = 0;
		if ( $xoopsUser ) {
			if ( $xoopsUser->isAdmin($xoopsModule->mid()) || is_moderator($this->forum_id(), $xoopsUser->getVar('uid')) ) {
				$this->can_post = 1;
				$this->show_reg = 1;
				$this->isadminormod = 1;
			}
		}
		$this->AssignCanPost();
	}
	function AssignCanPost(){
		global $xoopsTpl,$bbImage;
		if ( $this->can_post == 1 ) {
			$xoopsTpl->assign(array(
				'viewer_can_post' => true, 
				'forum_post_or_register' => 
					"<a href=\"newtopic.php?forum=".$this->forum_id()."\"><img src=\""
					.$bbImage['post']."\" alt=\""._MD_POSTNEW."\" /></a>")
			);
		} else {
			$xoopsTpl->assign('viewer_can_post', false);
			if ( $this->show_reg == 1 ) {
				$xoopsTpl->assign(
					'forum_post_or_register', '<a href="'.XOOPS_URL.'/user.php?xoops_redirect='.htmlspecialchars($xoopsRequestUri).'">'._MD_REGTOPOST.'</a>');
			} else {
				$xoopsTpl->assign('forum_post_or_register', '');
			}
		}
	}
	function SanitizeHeaderInfo(){
		$myts =& MyTextSanitizer::getInstance();
		$this->forumdata['topic_title'] = $myts->makeTboxData4Show($this->forumdata['topic_title']);
		$this->forumdata['forum_name'] = $myts->makeTboxData4Show($this->forumdata['forum_name']);
	}
	function XTplHeaderInfo(){
		global $xoopsTpl,$bbUrl,$bbImage;
		$xoopsTpl->assign(array(
		'topic_title' => '<a href="'.$bbUrl['root'].'viewtopic.php?viewmode='
			.$this->viewmode.'&amp;topic_id='.$this->topic_id().'&amp;forum='.$this->forum_id().'">'.$this->forumdata['topic_title'].'</a>',
		'forum_name' => $this->forumdata['forum_name'], 
		'topic_time' => $this->forumdata['topic_time'], 
		'lang_nexttopic' => _MD_NEXTTOPIC, 
		'lang_prevtopic' => _MD_PREVTOPIC,
		'img_option' => $bbImage['option'],
		"lang_option" => _MD_OPTION
		));
	}
	function XTplIconImages(){
		global $xoopsTpl,$xoopsUser,$xoopsModule,$bbUrl,$bbImage,$xoopsDB; // BY MAKINOSUKE @2008/4/29
;
		// add image links to admin page if the user viewing this page is a forum admin
		if ( $xoopsUser ) {
			$xoopsTpl->assign('viewer_userid', $xoopsUser->getVar('uid'));
			if ( !empty($this->isadminormod) || $xoopsUser->isAdmin($xoopsModule->mid()) || is_moderator( $this->forum_id(), $xoopsUser->getVar('uid')) ) {
				// yup, the user is admin
				// the forum is locked?
				if ( $this->forumdata['topic_status'] != 1 ) {
					// nope
					$xoopsTpl->assign('tplsig_viewtopic_islocked', 0); // BY MAKINOSUKE @2008/4/29
					$xoopsTpl->assign('lang_viewtopic_lock', _MD_LOCKTOPIC); // BY MAKINOSUKE @2008/4/29
					$xoopsTpl->assign('lang_viewtopic_desc_lock', _MD_OYPTLBATBOTFTTY); // BY MAKINOSUKE @2008/4/29
					//$xoopsTpl->assign('topic_lock_image', '<a href="'.$bbUrl['root'].'topicmanager.php?mode=lock&amp;topic_id='.$this->topic_id().'&amp;forum='.$this->forum_id().'"><img src="'.$bbImage['locktopic'].'" alt="'._MD_LOCKTOPIC.'" /></a>'); // BY MAKINOSUKE @2008/4/29
				} else {
					// yup, it is..
					$xoopsTpl->assign('tplsig_viewtopic_islocked', 1); // BY MAKINOSUKE @2008/4/29
					$xoopsTpl->assign('lang_viewtopic_unlock', _MD_UNLOCKTOPIC); // BY MAKINOSUKE @2008/4/29
					$xoopsTpl->assign('lang_viewtopic_desc_unlock', _MD_OYPTUBATBOTFTTY); // BY MAKINOSUKE @2008/4/29
					//$xoopsTpl->assign('topic_lock_image', '<a href="'.$bbUrl['root'].'topicmanager.php?mode=unlock&amp;topic_id='.$this->topic_id().'&amp;forum='.$this->forum_id().'"><img src="'.$bbImage['unlocktopic'].'" alt="'._MD_UNLOCKTOPIC.'" /></a>'); // BY MAKINOSUKE @2008/4/29
				}
				//$xoopsTpl->assign('topic_move_image', '<a href="'.$bbUrl['root'].'topicmanager.php?mode=move&amp;topic_id='.$this->topic_id().'&amp;forum='.$this->forum_id().'"><img src="'.$bbImage['movetopic'].'" alt="'._MD_MOVETOPIC.'" /></a>'); // BY MAKINOSUKE @2008/4/29
				$xoopsTpl->assign('lang_viewtopic_mov', _MD_MOVETOPIC); // BY MAKINOSUKE @2008/4/29
				$xoopsTpl->assign('lang_viewtopic_desc_mov', _MD_OYPTMBATBOTFTTY); // BY MAKINOSUKE @2008/4/29

				// ********** BY MAKINOSUKE @2008/4/29 **********
				$newbb_thcontrol_select = '<select name="newforum">';
				$forum = isset($_GET['forum']) ? intval($_GET['forum']) : 0; 
				$sql = "SELECT forum_id, forum_name FROM ".$xoopsDB->prefix("bb_forums")." WHERE forum_id != $forum ORDER BY forum_id";
				if ( $result = $xoopsDB->query($sql) ) {
					if ( $myrow = $xoopsDB->fetchArray($result) ) {
						do {
							$newbb_thcontrol_select .= "<option value='".$myrow['forum_id']."'>".$myrow['forum_name']."</option>\n";
						} while ( $myrow = $xoopsDB->fetchArray($result) );
					} else {
						$newbb_thcontrol_select .= "<option value='-1'>"._MD_NOFORUMINDB."</option>\n";
					}
				} else {
					$newbb_thcontrol_select .= "<option value='-1'>"._MD_DATABASEERROR."</option>\n";
				}
				$newbb_thcontrol_select .= '</select>';
				$xoopsTpl->assign('xhstr_viewtopic_mov_select', $newbb_thcontrol_select); // BY MAKINOSUKE
				// ********** BY MAKINOSUKE @2008/4/29 **********

				//$xoopsTpl->assign('topic_delete_image', '<a href="'.$bbUrl['root'].'topicmanager.php?mode=del&amp;topic_id='.$this->topic_id().'&amp;forum='.$this->forum_id().'"><img src="'.$bbImage['deltopic'].'" alt="'._MD_DELETETOPIC.'" /></a>'); // BY MAKINOSUKE @2008/4/29
				$xoopsTpl->assign('lang_viewtopic_del', _MD_DELTOPIC); // BY MAKINOSUKE @2008/4/29
				$xoopsTpl->assign('lang_viewtopic_desc_del', _MD_OYPTDBATBOTFTTY); // BY MAKINOSUKE @2008/4/29
				// is the topic sticky?
				if ( $this->forumdata['topic_sticky'] != 1 ) {
					// nope, not yet..
					$xoopsTpl->assign('tplsig_viewtopic_issticky', 0); // BY MAKINOSUKE @2008/4/29
					$xoopsTpl->assign('lang_viewtopic_sticky', _MD_STICKYTOPIC); // BY MAKINOSUKE @2008/4/29
					$xoopsTpl->assign('lang_viewtopic_desc_sticky', _MD_OYPTSBATBOTFTTY); // BY MAKINOSUKE @2008/4/29
					//$xoopsTpl->assign('topic_sticky_image', '<a href="'.$bbUrl['root'].'topicmanager.php?mode=sticky&amp;topic_id='.$this->topic_id().'&amp;forum='.$this->forum_id().'"><img src="'.$bbImage['sticky'].'" alt="'._MD_STICKYTOPIC.'" /></a>'); // BY MAKINOSUKE @2008/4/29
				} else {
					// yup it is sticking..
					$xoopsTpl->assign('tplsig_viewtopic_issticky', 1); // BY MAKINOSUKE @2008/4/29
					$xoopsTpl->assign('lang_viewtopic_unsticky', _MD_UNSTICKYTOPIC); // BY MAKINOSUKE @2008/4/29
					$xoopsTpl->assign('lang_viewtopic_desc_unsticky', _MD_OYPTTBATBOTFTTY); // BY MAKINOSUKE @2008/4/29
					//$xoopsTpl->assign('topic_sticky_image', '<a href="'.$bbUrl['root'].'topicmanager.php?mode=unsticky&amp;topic_id='.$this->topic_id().'&amp;forum='.$this->forum_id().'"><img src="'.$bbImage['unsticky'].'" alt="'._MD_UNSTICKYTOPIC.'" /></a>'); // BY MAKINOSUKE @2008/4/29
				}
				// need to set this also
				$xoopsTpl->assign('viewer_is_admin', true);
			} else {
				// nope, the user is not a forum admin..
				$xoopsTpl->assign('viewer_is_admin', false);
			}
		} else {
			// nope, the user is not a forum admin, not even registered
			$xoopsTpl->assign(array('viewer_is_admin' => false, 'viewer_userid' => 0));
		}
	}
	function XTplOrderInfo(){
		global $xoopsTpl;
		if ($this->order == 'DESC') {
			$xoopsTpl->assign(array('order_current' => 'DESC', 'order_other' => 'ASC', 'lang_order_other' => _OLDESTFIRST));
		} else {
			$xoopsTpl->assign(array('order_current' => 'ASC', 'order_other' => 'DESC', 'lang_order_other' => _NEWESTFIRST));
		}
	}
	function SetAnonymous(){
		global $xoopsConfig;
		return array(
		'poster_uid' =>0, 
		'poster_uname' => $xoopsConfig['anonymous'], 
		'poster_avatar' => '', 
		'poster_from' => '', 
		'poster_regdate' => '', 
		'poster_postnum' => '', 
		'poster_sendpmtext' => '', 
		'poster_rank_title' => '', 
		'poster_rank_image' => '');
	}
	function GetPostersInfo($eachpost){
		global $xoopsModuleConfig,$xoopsUser;
		if ( 0 != $eachpost->uid() ) {
			if (!isset($foundusers['user'.$eachpost->uid()])) {
				$eachposter = new XoopsUser($eachpost->uid());
				$foundusers['user'.$eachpost->uid()] =& $eachposter;
			} else {
				$eachposter =& $foundusers['user'.$eachpost->uid()];
			}
			$poster_rank = $eachposter->rank();
			if ( isset($poster_rank['image']) ) {
				$poster_rank['image'] = "<img src='".XOOPS_UPLOAD_URL."/".$poster_rank['image']."' alt='' />";
			}
			if ( $eachposter->isActive() ) {
				$poster_status = $eachposter->isOnline() ? _MD_ONLINE : '';
				// Modify By Y.Sakai
				$username = XoopsUser::getUnameFromId($eachpost->uid(),$xoopsModuleConfig['show_name']);
				if (!$username) $username = XoopsUser::getUnameFromId($eachpost->uid());
				// Modify End
				$posterarr =  array(
					'poster_uid' => $eachpost->uid(), 
					'poster_uname' => '<a href="'.XOOPS_URL.'/userinfo.php?uid='.$eachposter->getVar('uid').'">'.$username.'</a>', 
					'poster_avatar' => $eachposter->getVar('user_avatar'), 
					'poster_from' => $eachposter->getVar('user_from'), 
					'poster_regdate' => formatTimestamp($eachposter->getVar('user_regdate'), 's'), 
					'poster_postnum' => $eachposter->getVar('posts'), 
					'poster_sendpmtext' => sprintf(_SENDPMTO,$eachposter->getVar('uname')), 
					'poster_rank_title' => $poster_rank['title'], 
					'poster_rank_image' => $poster_rank['image'], 
					'poster_status' => $poster_status);
				if ( 1 == $this->allow_sig() && $eachpost->attachsig() == 1 && $eachposter->attachsig() == 1 ) {
					$myts =& MytextSanitizer::getInstance();
					$post_text = (isset($post_text) ? $post_text : '')."<p><br />----------------<br />". $myts->makeTareaData4Show($eachposter->getVar("user_sig", "N"), 0, 1, 1)."</p>";
				}
			} else {
				$posterarr = $this->SetAnonymous();
			}
		} else {
			$posterarr = $this->SetAnonymous();
		}
		return $posterarr;
	}
	function XTplEachPost($eachpost,$posterarr){
		global $xoopsTpl,$xoopsUser;

		if ( $eachpost->uid() ){
			if( is_object( @$xoopsUser ) ) {
				$can_edit = ( $this->isadminormod || $eachpost->uid() == $xoopsUser->getVar('uid') ) ? true : false ;
				$can_delete = ( $this->isadminormod ) ? true : false ;
			} else {
				$can_edit = $can_delete = false ;
			}
			$can_reply = $this->can_post;
		}else{
			// this is a post from guests
			if( $posterarr->poster_uid==0 ) {
				$can_edit = $this->isadminormod ? true : false ;
				$can_delete = $this->isadminormod ? true : false ;
				$can_reply = $this->can_post;
			}
		}
		// locked topic
		if( $this->forumdata['topic_status'] == 1 ) $can_edit = $can_delete = $can_reply = false ;
		// invisible topic
		if ($eachpost->invisible()){
			$can_reply = false;
			if (!$xoopsUser) return 0;
			if ( !$this->isadminormod && $eachpost->uid()!=$xoopsUser->uid() ) return 0;
		}
		$posticon = $eachpost->icon();
		if ( isset($posticon) && $posticon != '' ) {
			$post_image = '<a name="'.$eachpost->postid().'"><img src="'
				.XOOPS_URL.'/images/subject/'.$eachpost->icon().'" alt="" /></a>';
		} else {
			$post_image =  '<a name="'.$eachpost->postid().'"><img src="'
				.XOOPS_URL.'/images/icons/no_posticon.gif" alt="" /></a>';
		}
		$post_text = $this->phpBBsmiley($eachpost->text(),$eachpost->uid());
		// signature
		$eachposter = new XoopsUser($eachpost->uid());
		if( $this->allow_sig()==1 && $eachposter->attachsig()==1 ) {
			$myts =& MytextSanitizer::getInstance();
			$signature4disp = $myts->displayTarea( $eachposter->getVar('user_sig', 'N'), 0, 1, 1 ) ;
		} else {
			$signature4disp = '' ;
		}
//		$post_date = $eachpost->invisible() ? _MD_NOWEDITING."&nbsp;" : ""; // BY MAKINOSUKE
		$xoopsTpl->assign("lang_nowediting", _MD_NOWEDITING); // BY MAKINOSUKE
		$post_date = formatTimestamp($eachpost->posttime(), 'm');
		$xoopsTpl->append('topic_posts',array_merge($posterarr, array(
			'post_id' => $eachpost->postid(), 
			'post_parent_id' => $eachpost->parent(), 
			'post_date' => $post_date,
			'post_poster_ip'=> $eachpost->posterip(), 
			'post_image' => $post_image, 
			'post_invisible' => $eachpost->invisible(), 
			'post_invisible' => $eachpost->invisible(), 
			'post_title' => $eachpost->subject(), 
			'post_text' => $post_text,
			'signature' => $signature4disp ,
			'can_edit' => @$can_edit,
			'can_delete' => @$can_delete,
			'can_reply' => @$can_reply
		)));
	}
	function XTplCreateJumpBox(){
		global $xoopsTpl,$xoopsConfig;
		$forum_jumpbox = "<form action=\"viewforum.php\" method=\"get\">"
			.make_jumpbox($this->forum_id())."<input type=\"submit\" class=\"formButton\" value=\""._MD_GO."\" />\n</form>";
		$xoopsTpl->assign(array(
			'forum_jumpbox' => $forum_jumpbox, 
			'lang_forum_index' => sprintf(_MD_FORUMINDEX,$xoopsConfig['sitename']), 
			'lang_from' => _MD_FROM, 'lang_joined' => _MD_JOINED, 
			'lang_posts' => _MD_POSTS, 'lang_poster' => _MD_POSTER, 
			'lang_thread' => _MD_THREAD, 'icon_read' => _MD_READ_IMG, 
			'lang_read' => _MD_READ, 'lang_edit' => _EDIT, 
			'lang_delete' => _DELETE, 
			'lang_reply' => _REPLY, 
			'lang_postedon' => _MD_POSTEDON));
	}
	function showTree(&$arr, $current=0, $key=0, $prefix='', $foundusers=array()){
		global $xoopsConfig,$xoopsUser,$xoopsModuleConfig;
		if ($key){
			if ( 0 != $arr[$key]['obj']->uid() ) {
				if (!isset($foundusers[$arr[$key]['obj']->uid()])) {
					$eachposter = new XoopsUser($arr[$key]['obj']->uid());
					$foundusers[$arr[$key]['obj']->uid()] =& $eachposter;
				} else {
					$eachposter =& $foundusers[$arr[$key]['obj']->uid()];
				}
				$poster_rank = $eachposter->rank();
				if ( $poster_rank['image'] != '' ) {
					$poster_rank['image'] = '<img src="'.XOOPS_UPLOAD_URL.'/'.$poster_rank['image'].'" alt="" />';
				}
				if ( $eachposter->isActive() ) {
					// Modify By Y.Sakai
					$username = $eachposter->getUnameFromId($eachposter->getVar('uid'),$xoopsModuleConfig['show_name']);
					if (!$username) $username = $eachposter->getUnameFromId($eachposter->getVar('uid'));
					// Modify End
					$posterarr =  array(
						'poster_uid' => $eachposter->getVar('uid'), 
						'poster_uname' => '<a href="'.XOOPS_URL.'/userinfo.php?uid='.$eachposter->getVar('uid').'">'.$username.'</a>'
					);
				} else {
					$posterarr = array('poster_uid' =>0, 'poster_uname' => $xoopsConfig['anonymous']);
				}
			} else {
				$posterarr = array('poster_uid' =>0, 'poster_uname' => $xoopsConfig['anonymous']);
			}
			$posticon = $arr[$key]['obj']->icon();
			if ( $posticon ) {
				$post_image = '<img src="'.XOOPS_URL.'/images/subject/'.$posticon.'" alt="" />';
			} else {
				$post_image =  '<img src="'.XOOPS_URL.'/images/icons/no_posticon.gif" alt="" />';
			}
			$uid = $xoopsUser ? $xoopsUser->uid() : 0;
			if ( $arr[$key]['obj']->invisible()==0 || $this->isadminormod || ($uid>0 and $arr[$key]['obj']->uid()==$uid) ){
				if ($current != $key) {
					$subject = '<a href="viewtopic.php?viewmode=thread&amp;topic_id='.$arr[$key]['obj']->topic().
						'&amp;forum='.$arr[$key]['obj']->forum().'&amp;post_id='.$arr[$key]['obj']->postid().'#'.$arr[$key]['obj']->postid().'">'
						.$arr[$key]['obj']->subject().'</a>';
					$GLOBALS['xoopsTpl']->append("topic_trees", array_merge($posterarr, array(
						"post_id" => $arr[$key]['obj']->postid(), 
						"post_parent_id" => $arr[$key]['obj']->parent(), 
						"post_date" => formatTimestamp($arr[$key]['obj']->posttime(), "m"), 
						"post_image" => $post_image, 
						"post_title" => $subject, 
						"post_invisible" => $arr[$key]['obj']->invisible(), 
						"post_prefix" => $prefix)));
				} else {
					$subject = '<em>'.$arr[$key]['obj']->subject().'</em>'; // by makinosuke
					$thisprefix = substr($prefix, 0, -6)."&raquo;";
					$GLOBALS['xoopsTpl']->append("topic_trees", array_merge($posterarr, array(
						"post_id" => $arr[$key]['obj']->postid(), 
						"post_parent_id" => $arr[$key]['obj']->parent(), 
						"post_date" => formatTimestamp($arr[$key]['obj']->posttime(), "m"), 
						"post_image" => $post_image, 
						"post_title" => $subject, 
						"post_invisible" => $arr[$key]['obj']->invisible(),
						"post_prefix" => $thisprefix)));
				}
			}
		}
		if ( isset($arr[$key]['replies']) && !empty($arr[$key]['replies']) ){
			$prefix .= "&nbsp;&nbsp;";
			foreach($arr[$key]['replies'] as $replykey) {
				$current = ( $current == 0 ) ? $replykey : $current;
				$this->showTree($arr, $current, $replykey, $prefix, $foundusers);
			}
		}
	}
	// 2004-1-12 GIJOE <gij@peak.ne.jp> Added routine to move to the correct
	// starting position within a topic thread
	function &getAllPosts( $perpage=0, &$start, $post_id=0){	
		$db =& Database::getInstance();
		if( $this->order == "DESC" ) {
			$operator_for_position = '>' ;
		} else {
			$this->order = "ASC" ;
			$operator_for_position = '<' ;
		}
		if ($perpage <= 0) {
			 $perpage = 10;
		}
		if (empty($start)) {
			$start = 0;
		}
		if (!empty($post_id)) {
			$sql="SELECT COUNT(post_id) FROM "
				.$db->prefix('bb_posts')." WHERE topic_id=".$this->topic_id()." AND post_id $operator_for_position $post_id";
			list($position) = $db->fetchRow($db->query($sql));
			$start = intval($position / $perpage) * $perpage;
		}
		$sql = 'SELECT p.*, t.post_text FROM '.$db->prefix('bb_posts').' p, '
			.$db->prefix('bb_posts_text')." t WHERE p.topic_id=".$this->topic_id()." AND p.post_id = t.post_id ORDER BY p.post_id ".$this->order;
		$result = $db->query($sql,$perpage,$start);
		$ret = array();
		while ($myrow = $db->fetchArray($result)) {
			$ret[] = new ForumPosts($myrow);
		}
		return $ret;
	}
	/**
	* Add Delete URL for uploaded files
	*/
	function AddDeleteURL( &$str ) {
		global $xoopsUser;
		preg_match_all("/http:\/\/?[^ ]+/i",$str,$lnk);
		$size = sizeof($lnk[0]);
		$i = 0;
		while ($i < $size) {
			$ahref = $lnk[0][$i];
			$ret = preg_match("/download.php\?url=\/(.*)\"/i",$ahref,$matches);
			if (isset($matches[1])){
				$returl = "&topic_id=" . $this->topic_id . "&forum=" . parent::forum()."&order=" . $this->order;
				$delurl = "<A HREF='download.php?url=/" . $matches[1] 
					. "&deleteby=" . $xoopsUser->uname() . $returl . "'>:filedelete:</A>";
				$returl = "download.php?url=/" . $matches[1] . $returl . "\"";
				$str = str_replace(":download:<a href=\"$ahref","$delurl :download:<a href=\"$returl",$str);
			}
			$i++;
		}
		return $str;
	}
	/**
	* Replace emoticons in the message with phpBB images
	* @param	string  $message
	* @return	string
	*/
	function phpBBsmiley(&$message,$uid){
		global $thumb_ext,$xoopsUser;
		// Show the delete url link for poster and admin.
		// Hopefully, support this future... is_moderator(parent::forum(), $xoopsUser->uid())
		if ($xoopsUser){
			if ( $uid == $xoopsUser->uid() || $xoopsUser->isadmin() ){
				$this->AddDeleteURL($message);
			}
		}
		$message = str_replace(":download:", "<img src=./images/attachment.gif alt='' /> ", $message);
		$message = str_replace(":filedelete:", "<img src=./images/edittrash.png alt='' /> ", $message);
		$message = str_replace(":readsign:", "<img src=./images/readsign.gif alt='' /> ", $message);
		return $message;
	}	
	function CountUpTopicViews(){
		global $xoopsDB;
		// count up
		$xoopsDB->queryF( "UPDATE ".$xoopsDB->prefix("bb_topics")
			." SET topic_views = topic_views + 1 WHERE topic_id ='" . $this->topic_id . "'" ) ;
	}
	function UpdateUsersReadHistry($uid){
		global $xoopsDB;
		// already read
		$sql = 'SELECT u2t_time,u2t_marked FROM '
			.$xoopsDB->prefix('bb_users2topics')." WHERE uid='$uid' AND topic_id='".$this->topic_id()."'";
		$result = $xoopsDB->query( $sql ) ;
		if( $xoopsDB->getRowsNum( $result ) ) {
			list( $u2t_time , $u2t_marked ) = $xoopsDB->fetchRow( $result ) ;
		} else {
			list( $u2t_time , $u2t_marked ) = array( 0 , 0 ) ;
		}
		if( $u2t_time <= $this->topic_time() ) {
			// update/insert u2t table
			$sql = 'UPDATE '.$xoopsDB->prefix('bb_users2topics')
				." SET u2t_time=".time()." WHERE uid='$uid' AND topic_id='".$this->topic_id."'";
			$xoopsDB->queryF( $sql ) ;
			if( ! $xoopsDB->getAffectedRows() ) {
				$sql = "INSERT INTO ".$xoopsDB->prefix('bb_users2topics')
					." SET uid='$uid',topic_id='".$this->topic_id."',u2t_time=".time();
				$xoopsDB->queryF( $sql ) ;
			}
		}
	}

}
?>
