<?php
// $Id: delete.php,v 1.2 2005/10/29 13:31:35 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.myweb.ne.jp/, http://www.xoops.org/, http://jp.xoops.org/ //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //

include 'header.php';

foreach (array('forum', 'topic_id', 'post_id', 'pid' ) as $getint) {
	${$getint} = isset($_GET[$getint]) ? intval($_GET[$getint]) : 0;
}
$viewmode = (isset($_GET['viewmode']) && $_GET['viewmode'] != 'flat') ? 'thread' : 'flat';
$order = (!isset($_GET['order']) || $_GET['order'] != "ASC") ? "DESC" : "ASC";

extract($_POST, EXTR_OVERWRITE);
if ( empty($forum) ) {
	redirect_header("index.php", 2, _MD_ERRORFORUM);
	exit();
} elseif ( empty($post_id) ) {
	redirect_header("viewforum.php?forum=$forum", 2, _MD_ERRORPOST);
	exit();
}

if ( $xoopsUser ) {
	if ( !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
		if ( !is_moderator($forum, $xoopsUser->uid()) ) {
			redirect_header("viewtopic.php?topic_id=$topic_id&order=$order&viewmode=$viewmode&pid=$pid&forum=$forum", 2, _MD_DELNOTALLOWED);
			exit();
		}
	}
} else {
	redirect_header("viewtopic.php?topic_id=$topic_id&order=$order&viewmode=$viewmode&pid=$pid&forum=$forum", 2, _MD_DELNOTALLOWED);
	exit();
}

include_once 'class/class.forumposts.php';

$post = new ForumPosts($post_id);
if( ! empty( $_POST['deletepostsok'] ) ) {
	if ( !empty($post_id) ) {
		$post->delete();
		sync($post->forum(), "forum");
		sync($post->topic(), "topic");
	}
	if ( $post->istopic() ) {
		redirect_header("viewforum.php?forum=$forum", 2, _MD_POSTSDELETED);
		exit();
	} else {
		redirect_header("viewtopic.php?topic_id=$topic_id&order=$order&viewmode=$viewmode&pid=$pid&forum=$forum", 2, _MD_POSTSDELETED);
		exit();
	}
} else {
//	include XOOPS_ROOT_PATH."/header.php";
//	xoops_confirm(array('post_id' => $post_id, 'viewmode' => $viewmode, 'order' => $order, 'forum' => $forum, 'topic_id' => $topic_id, 'ok' => 1), 'delete.php', _MD_AREUSUREDEL);
	// FORM PART
	include XOOPS_ROOT_PATH."/header.php";
	$xoopsOption['template_main'] = 'newbb_delete.html' ;

	// references to confirm the post will be deleted
	$reference_message4html = $post->text('Show');
	$reference_date4html = formatTimestamp( $post->posttime() ) ;
	$reference_name4html = $post->uid() ? XoopsUser::getUnameFromId( $post->uid() ) : $xoopsConfig['anonymous'] ;
	$reference_subject4html = $post->subject('Show');

	// count children
	include_once XOOPS_ROOT_PATH."/class/xoopstree.php" ;
	$mytree = new XoopsTree( $xoopsDB->prefix("bb_posts") , "post_id" , "pid" ) ;
	$children = $mytree->getAllChildId( $post_id ) ;

	$xoopsTpl->assign( array(
		'post_id' => $post_id ,
		'pid' => $pid ,
		'topic_id' => $topic_id ,
		'forum' => $forum ,
		'order' => $order ,
		'viewmode' => $viewmode ,
		'reference_subject' => @$reference_subject4html ,
		'reference_message' => @$reference_message4html ,
		'reference_name' => @$reference_name4html ,
		'reference_date' => @$reference_date4html ,
		'children_count' => count( $children ) ,
		'mod_url' => XOOPS_URL.'/modules/newbb' ,
		'img_hotfolder' => $bbImage['newposts_forum'] ,
	) ) ;

	$xoopsTpl->assign( array( 
		"xoops_module_header" => "<link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"style.css\" />" . $xoopsTpl->get_template_vars( "xoops_module_header" ) , 
		"xoops_pagetitle" => _DELETE ) ) ;
}
$xoopsTpl->assign('forum_index_title', sprintf(_MD_FORUMINDEX,$xoopsConfig['sitename']));//by makinosuke

include XOOPS_ROOT_PATH.'/footer.php';
?>
