<?php
// $Id: reply.php,v 1.2 2005/10/29 13:31:36 yoshis Exp $
//  ------------------------------------------------------------------------ //
//                XOOPS - PHP Content Management System                      //
//                    Copyright (c) 2000 XOOPS.org                           //
//                       <http://www.xoops.org/>                             //
//  ------------------------------------------------------------------------ //
//  This program is free software; you can redistribute it and/or modify     //
//  it under the terms of the GNU General Public License as published by     //
//  the Free Software Foundation; either version 2 of the License, or        //
//  (at your option) any later version.                                      //
//                                                                           //
//  You may not change or alter any portion of this comment or credits       //
//  of supporting developers from this source code or any supporting         //
//  source code which is considered copyrighted (c) material of the          //
//  original comment or credit authors.                                      //
//                                                                           //
//  This program is distributed in the hope that it will be useful,          //
//  but WITHOUT ANY WARRANTY; without even the implied warranty of           //
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            //
//  GNU General Public License for more details.                             //
//                                                                           //
//  You should have received a copy of the GNU General Public License        //
//  along with this program; if not, write to the Free Software              //
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA //
//  ------------------------------------------------------------------------ //
// Author: Kazumi Ono (AKA onokazu)                                          //
// URL: http://www.myweb.ne.jp/, http://www.xoops.org/, http://jp.xoops.org/ //
// Project: The XOOPS Project                                                //
// ------------------------------------------------------------------------- //
include 'header.php';
foreach (array('forum', 'topic_id', 'post_id', 'order', 'pid', 'msgview') as $getint) {
	${$getint} = isset($_GET[$getint]) ? intval($_GET[$getint]) : 0;
}
$viewmode = (isset($_GET['viewmode']) && $_GET['viewmode'] != 'flat') ? 'thread' : 'flat';
$order = (!isset($_GET['order']) || $_GET['order'] != "ASC") ? "DESC" : "ASC";
$msgview = (isset($_GET['msgview']) && $_GET['msgview'] == '0') ? 0 : 1;

if ( empty($forum) ) {
	redirect_header("index.php", 2, _MD_ERRORFORUM);
	exit();
} elseif ( empty($topic_id) ) {
	redirect_header("viewforum.php?forum=$forum", 2, _MD_ERRORTOPIC);
	exit();
} elseif ( empty($post_id) ) {
	redirect_header("viewtopic.php?topic_id=$topic_id&order=$order&viewmode=$viewmode&pid=$pid&forum=$forum", 2, _MD_ERRORPOST);
	exit();
} else {
	if ( is_locked($topic_id) ) {
		redirect_header("viewtopic.php?topic_id=$topic_id&order=$order&viewmode=$viewmode&pid=$pid&forum=$forum", 2, _MD_TOPICLOCKED);
		exit();
	}
	$sql = "SELECT forum_type, forum_name, forum_access, allow_html, allow_sig, posts_per_page, hot_threshold, topics_per_page FROM ".$xoopsDB->prefix("bb_forums")." WHERE forum_id = $forum";
	if ( !$result = $xoopsDB->query($sql) ) {
		redirect_header('index.php',1,_MD_ERROROCCURED);
		exit();
	}
	$forumdata = $xoopsDB->fetchArray($result);
	$myts =& MyTextSanitizer::getInstance();
	if ( $forumdata['forum_type'] == 1 ) {
		// To get here, we have a logged-in user. So, check whether that user is allowed to post in
		// this private forum.
		$accesserror = 0; //initialize
		if ( $xoopsUser ) {
			if ( !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
				if ( !check_priv_forum_auth($xoopsUser->uid(), $forum, true) ) {
					$accesserror = 1;
				}
			}
		} else {
			$accesserror = 1;
		}
		if ( $accesserror == 1 ) {
			redirect_header("viewtopic.php?topic_id=$topic_id&post_id=$post_id&order=$order&viewmode=$viewmode&pid=$pid&forum=$forum",2,_MD_NORIGHTTOPOST);
			exit();
		}
		// Ok, looks like we're good.
	} else {
		$accesserror = 0;
		if ( $forumdata['forum_access'] == 3 ) {
			if ( $xoopsUser ) {
				if ( !$xoopsUser->isAdmin($xoopsModule->mid()) ) {
					if ( !is_moderator($forum, $xoopsUser->uid()) ) {
						$accesserror = 1;
					}
				}
			} else {
				$accesserror = 1;
			}
		} elseif ( $forumdata['forum_access'] == 1 && !$xoopsUser ) {
			$accesserror = 1;
		}
		if ( $accesserror == 1 ) {
			redirect_header("viewtopic.php?topic_id=$topic_id&post_id=$post_id&order=$order&viewmode=$viewmode&pid=$pid&forum=$forum",2,_MD_NORIGHTTOPOST);
			exit();
		}
    }
	include XOOPS_ROOT_PATH.'/header.php';
	include_once 'class/class.forumposts.php';
	$forumpost = new ForumPosts($post_id);
	$r_message = $forumpost->text();
	$xoopsTpl->assign("xhstr_edit_ref_message", $r_message); // BY MAKINOSUKE @2008/4/17
	$r_date = formatTimestamp($forumpost->posttime());
	$xoopsTpl->assign("lang_edit_ref_date", $r_date); // BY MAKINOSUKE @2008/4/17
	$r_name = XoopsUser::getUnameFromId($forumpost->uid(),$xoopsModuleConfig['show_name']);
	if (!$r_name) $r_name = XoopsUser::getUnameFromId($forumpost->uid());
	$xoopsTpl->assign("lang_edit_ref_name", $r_name); // BY MAKINOSUKE @2008/4/17
	$r_content = _MD_BY." ".$r_name." "._MD_ON." ".$r_date."<br /><br />";
	$r_content .= $r_message;
	$r_subject=$forumpost->subject();
	$xoopsTpl->assign("lang_edit_ref_subject", $r_subject); // BY MAKINOSUKE @2008/4/17
	$xoopsTpl->assign("lang_edit_editpost", sprintf(_MD_EDIT_RESTO, $r_subject)); // BY MAKINOSUKE @2008/4/17
	if (!preg_match("/^Re:/i",$r_subject)) {
		$subject = 'Re: '.$myts->htmlSpecialChars($r_subject);
	} else {
		$subject = $myts->htmlSpecialChars($r_subject);
	}
	$q_message = $forumpost->text("Quotes");
	$hidden = "[quote]";// BY MAKINOSUKE @2008/4/27
//	$hidden .= sprintf(_MD_USERWROTE,$r_name);
	$hidden .= $q_message."[/quote]";// BY MAKINOSUKE @2008/4/27
	$message = "";
//	themecenterposts($r_subject,$r_content); // BY MAKINOSUKE @2008/4/17
	$pid=$post_id;
	unset($post_id);
	$topic_id=$forumpost->topic();
	$forum=$forumpost->forum();
	$isreply =1;
	$istopic = 0;
	if ($msgview == 1)
		$form_url= " [ <a href='reply.php?forum=".$forum."&amp;post_id=".$pid."&amp;topic_id=".$topic_id."&amp;viewmode=".$viewmode."&amp;msgview=0&amp;order=".$order."'>DHTML</a> ]";
	else
		$form_url= " [ <a href='reply.php?forum=".$forum."&amp;post_id=".$pid."&amp;topic_id=".$topic_id."&amp;viewmode=".$viewmode."&amp;msgview=1&amp;order=".$order."'>markItUp!</a> ]";
//	include $BB_CNF['spaw_path'].'spaw_control.class.php' ;

// ******************** BY MAKINOSUKE @2008/4/17 ********************
$xoopsOption['template_main'] =  'newbb_edit.html';
$xoopsTpl->assign("lang_edit_pagetitle", _MD_EDIT_RES); // BY MAKINOSUKE @2008/4/17
// ******************** BY MAKINOSUKE @2008/4/17 ********************

$xoopsTpl->assign( 'xoops_module_header', 
  '<link rel="stylesheet" type="text/css" media="screen,tv,print" href="style.css" />
  <!-- jQuery -->
  <script type="text/javascript" src="js/jquery-1.2.6.min.js"></script>
  <!-- markItUp! -->
  <script type="text/javascript" src="js/markitup/jquery.markitup.pack.js"></script>
  <!-- markItUp! toolbar settings -->
  <script type="text/javascript" src="js/markitup/sets/bbcode/set.js"></script>
  <!-- markItUp! skin -->
  <link rel="stylesheet" type="text/css" href="js/markitup/skins/simple/style.css" />
  <!--  markItUp! toolbar skin -->
  <link rel="stylesheet" type="text/css" href="js/markitup/sets/bbcode/style.css" />
'); //BY MAKINOSUKE @2008/5/8

	include 'include/forumform.inc.php';
	include XOOPS_ROOT_PATH.'/footer.php';
}
?>
