/*  $Id$
 *
 *  Copyright (C) 2005 mueki <>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * Functions are described using gtk-doc style comments, even though no actual
 * documentation is extracted. The format should be self-explanatory.
 *
 * The 'xfce_control_class_init' function is the only direct access to the module
 * from the panel. It is probably easiest to start reading from there. It's
 * the last function definition in this file.
 **/

#ifndef NEWSREADER_H
#define NEWSREADER_H

#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/xfce_iconbutton.h>

#include <panel/xfce.h>
#include <panel/plugins.h>

#include "xmlparse.h"
#include "config_gui.h"

/**
 * newsreader_t
 *
 * This struct contains all relevant information about the plugin. A pointer
 * to a newly allocated newsreader_t struct is added to every new newsreader #Control.
 *
 * See also xfce_plugin_init().
 **/

typedef struct feeddata_t
{
	feed_t* pFeed;
	gchar* pchURI;	/* feed$B$N(BURI */
	time_t tmLastModified; /* feed$B$N99?7F|;~(B(Last-Modified$B%X%C%@$+$i<hF@(B) */
	GdkPixbuf* pIcon; 
	gint iValidHours; /* $B5-;v$NI=<(4|8B(B(config$B$G@_Dj(B) */ 
}feeddata_t;

typedef struct newsreader_t
{
	unsigned int iTimerID; /* $BI=<(99?7MQ%?%$%^!<(BID */
	unsigned int iFeedTimerID; /* $B5-;v<hF@MQ%?%$%^!<(BID*/
  
	int labelWidth;
	int feedUpdateMin;
	int itemUpdateSec;
  
	GList* poOutlineList;
	GList* poMenuItemList;
	GList* poIconList;

	GtkWidget *widget;
	GtkLabel *wLblItem;
	GtkEventBox *wEvItem;
	GtkButton *wBtnMenu;
	GtkMenu *wMenu;
	GtkMenuItem *wItmFeedList;
	GtkMenuItem *wItmUpdate;
	GtkEntry *wEntBrowserCmd;
	GtkImage *wIcon;

	GString* strItemFontName;
	gchar* pchBrowserCmd;
	Control* control;

	GList* g_pFeedList;
	GList* g_pCurFeed;
	GList* g_pCurItem;

	struct gui_t oGUI;

	gchar* pchURI; /* Drag and Drop$B;~(B feed$B$r<hF@$9$k(BURI$B$r3JG<(B */

} newsreader_t;

typedef struct favicon_t
{
	gchar* uri;
	GdkPixbuf* pIconPixbuf;
}favicon_t;

typedef struct itemuri_t
{
	GtkMenuItem* wItem;
	gchar* pchURI;

}itemuri_t;

#endif
