/* xfce4-newsreader-plugin - A lightweight RSS/Atom news feed reader on xfce4-panel
 * $Id:$
 * 
 * Copyright 2005 mueki <mueki@users.sourceforge.jp>
 * Written for rssreader.
 *
 * xmlparse.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef XMLPARSER_H
#define XMLPARSER_H
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/HTMLparser.h>

#include <glib.h>
#include <time.h>

typedef struct outline_t
{
	GString* strTitle;
	GString* strURL;
	gboolean bAvailable;
	gint iValidHours;
} outline_t;

typedef struct feed_t
{
	GString* title;
	GString* url;
	GList* items;
	time_t tmModified;
}feed_t;

typedef struct item_t
{
	GString* title;
	GString* url;
	time_t tmModified;
}item_t;

void free_feed(feed_t* pfeed);
feed_t* get_feed(xmlDocPtr doc, xmlNode * node);
void print_feed(feed_t* pfeed);
gboolean storeFeedList_XBEL(GList* poOutlineList, gchar* filename);
GList* getFeedList_XBEL(xmlDocPtr doc, GList* poList);
GList* getOutlineList(xmlDocPtr doc, GList* poList);
gboolean storeOutlineList(GList* poOutlineList, gchar* filename);
item_t* create_new_item();
feed_t* create_new_feed();
gchar* get_favicon_path(xmlDocPtr doc);

#endif
