// Config.h: interface for the CConfig class.
//
//////////////////////////////////////////////////////////////////////

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_CONFIG_H__3DA7F4F9_7082_41C5_BB2F_1BAEA3D1EDFF__INCLUDED_)
#define AFX_CONFIG_H__3DA7F4F9_7082_41C5_BB2F_1BAEA3D1EDFF__INCLUDED_

#include "DnsblEntry.h"
#include "WhitelistEntry.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CConfig  
{
public:
	void SaveConfig();
	CConfig();
	virtual ~CConfig();

	// Parameters
	BOOL m_sso;
	BOOL m_debug;
	BOOL m_informNewMail;
	BOOL m_dSpamFilter;
	int  m_dSpam_trainMode;
	BOOL m_dnsblFilter;
	CString m_mailBox;
	CString m_mailBoxServer;
	CString m_notesPath;
	CString m_notesIniFilename;
	CString m_instpath;
	CString m_userpath;
	CArray<CDnsblEntry,CDnsblEntry&> m_dnsbl;
	CArray<CWhitelistEntry,CWhitelistEntry&> m_whitelist;
protected:
	CString GetLNIniFilename();
public:
	unsigned int m_schedule;
};

#endif // !defined(AFX_CONFIG_H__3DA7F4F9_7082_41C5_BB2F_1BAEA3D1EDFF__INCLUDED_)
