// ConfigDSpamDlg.cpp : implementation file
//
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "ConfigDSpamDlg.h"
#include "dspam/libdspam.h"
#include ".\configdspamdlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigDSpamDlg dialog


CConfigDSpamDlg::CConfigDSpamDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigDSpamDlg::IDD, pParent)
	, m_trainMode(0)
{
	//{{AFX_DATA_INIT(CConfigDSpamDlg)
	//}}AFX_DATA_INIT

	m_myApp=(CNotesAntiSpamApp*)AfxGetApp();
}


void CConfigDSpamDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigDSpamDlg)
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigDSpamDlg, CDialog)
	//{{AFX_MSG_MAP(CConfigDSpamDlg)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_RADIO_TEFT, OnBnClickedRadioTeft)
	ON_BN_CLICKED(IDC_RADIO_TOE, OnBnClickedRadioToe)
	ON_BN_CLICKED(IDC_RADIO_TUM, OnBnClickedRadioTum)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigDSpamDlg message handlers


void CConfigDSpamDlg::OnOK() 
{
	UpdateData();

	m_myApp->m_config.m_dSpam_trainMode=m_trainMode;
	
	/*
	 * Save Config
	 */
	m_myApp->m_config.SaveConfig();

	
	CDialog::OnOK();
}

void CConfigDSpamDlg::OnBnClickedRadioTeft()
{
	m_trainMode=DST_TEFT;
}

void CConfigDSpamDlg::OnBnClickedRadioToe()
{
	m_trainMode=DST_TOE;
}

void CConfigDSpamDlg::OnBnClickedRadioTum()
{
	m_trainMode=DST_TUM;
}

BOOL CConfigDSpamDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	switch(m_myApp->m_config.m_dSpam_trainMode)
	{
	case DST_TEFT:
		SendDlgItemMessage(IDC_RADIO_TEFT, BM_SETCHECK, 1, 0);
		break;
	case DST_TOE:
		SendDlgItemMessage(IDC_RADIO_TOE, BM_SETCHECK, 1, 0);
		break;
	case DST_TUM:
		SendDlgItemMessage(IDC_RADIO_TUM, BM_SETCHECK, 1, 0);
		break;
	}
	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}
