// ConfigGeneralDlg.cpp : implementation file
//

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "ConfigGeneralDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigGeneralDlg dialog


CConfigGeneralDlg::CConfigGeneralDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigGeneralDlg::IDD, pParent)
	, m_schedule(0)
{
	//{{AFX_DATA_INIT(CConfigGeneralDlg)
	m_debug = FALSE;
	m_sso = FALSE;
	m_dSpamFilter = FALSE;
	m_dnsblFilter = FALSE;
	m_informNewMail = FALSE;
	m_mailBox = _T("");
	m_mailBoxServer = _T("");
	//}}AFX_DATA_INIT

	myApp=(CNotesAntiSpamApp*)AfxGetApp();
	m_debug=myApp->m_config.m_debug;
	m_sso=myApp->m_config.m_sso;
	m_schedule=myApp->m_config.m_schedule/1000;
	m_informNewMail=myApp->m_config.m_informNewMail;
	m_dnsblFilter=myApp->m_config.m_dnsblFilter;
	m_dSpamFilter=myApp->m_config.m_dSpamFilter;
	m_mailBox=myApp->m_config.m_mailBox;
	m_mailBoxServer=myApp->m_config.m_mailBoxServer;
}


void CConfigGeneralDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigGeneralDlg)
	DDX_Check(pDX, IDC_DEBUG_CHECK, m_debug);
	DDX_Check(pDX, IDC_SSO_CHECK, m_sso);
	DDX_Check(pDX, IDC_DPSPAM_CHECK, m_dSpamFilter);
	DDX_Check(pDX, IDC_DNSBL_CHECK, m_dnsblFilter);
	DDX_Check(pDX, IDC_IFORM_CHECK, m_informNewMail);
	DDX_Text(pDX, IDC_MAILBOX, m_mailBox);
	DDX_Text(pDX, IDC_MAILBOXSERVER, m_mailBoxServer);
	//}}AFX_DATA_MAP
	DDX_Text(pDX, IDC_SCHEDULE, m_schedule);
}


BEGIN_MESSAGE_MAP(CConfigGeneralDlg, CDialog)
	//{{AFX_MSG_MAP(CConfigGeneralDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigGeneralDlg message handlers

void CConfigGeneralDlg::OnOK() 
{
	UpdateData();

	if(myApp->m_config.m_debug!=m_debug)
	{
		myApp->debugger.SetState(m_debug);
		myApp->m_config.m_debug=m_debug;
	}
	if(myApp->m_config.m_sso!=m_sso)
	{
		myApp->m_config.m_sso=m_sso;
		
		CString notesIni = "notes.ini";
		char szBuffer[1024];
		CString tmp;
		
		notesIni=myApp->m_config.m_notesIniFilename;
		// Read Addins
		GetPrivateProfileString("Notes",
		                        "EXTMGR_ADDINS",
								"",
								szBuffer,
								sizeof(szBuffer)-1,
								notesIni);
		tmp=szBuffer;

		if(m_sso)
		{
			if(tmp.GetLength()>0)
			{
				if(tmp.Find("NASExtPwd")<0)
					tmp+=",NASExtPwd";
			}
			else
			{
				tmp="NASExtPwd";
			}
		}
		else
		{
			if(tmp.CompareNoCase("NASExtPwd")==0)
			{
				tmp="";
			}
			else
			{
				tmp.MakeUpper();
				tmp.Replace("NASEXTPWD","");
				tmp.Replace(",,",",");
				if(tmp[tmp.GetLength()-1]==',')
				{
					tmp=tmp.Left(tmp.GetLength()-1);
				}
			}
		}
		
		WritePrivateProfileString("Notes",
		                          "EXTMGR_ADDINS",
								  tmp,
								  notesIni);
	}
	myApp->m_config.m_informNewMail=m_informNewMail;
	if(myApp->m_config.m_schedule!=(m_schedule*1000))
	{
		myApp->m_config.m_schedule=m_schedule*1000;
		AfxMessageBox(IDS_CHANGESCHEDULEEFFECT,MB_OK|MB_ICONINFORMATION);
	}
	myApp->m_config.m_dSpamFilter=m_dSpamFilter;
	myApp->m_config.m_dnsblFilter=m_dnsblFilter;
	if((myApp->m_config.m_mailBox!=m_mailBox)||(myApp->m_config.m_mailBoxServer!=m_mailBoxServer))
	{
		myApp->m_config.m_mailBox=m_mailBox;
		myApp->m_config.m_mailBoxServer=m_mailBoxServer;
		AfxMessageBox(IDS_CHANGEMAILBOXEFFECT,MB_OK|MB_ICONINFORMATION);
	}

	/*
	 * Save Config
	 */
	myApp->m_config.SaveConfig();

	CDialog::OnOK();
}


BOOL CConfigGeneralDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
