// ConfigWhitelistDlg.cpp : implementation file
//
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "ConfigWhitelistDlg.h"
#include "ConfigWhitelistEntryDlg.h"
#include "WhitelistEntry.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigWhitelistDlg dialog


CConfigWhitelistDlg::CConfigWhitelistDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigWhitelistDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigWhitelistDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	myApp=(CNotesAntiSpamApp*)AfxGetApp();
}


void CConfigWhitelistDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigWhitelistDlg)
	DDX_Control(pDX, IDC_WHITELIST, m_whiteListCtrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigWhitelistDlg, CDialog)
	//{{AFX_MSG_MAP(CConfigWhitelistDlg)
	ON_NOTIFY(NM_DBLCLK, IDC_WHITELIST, OnDblclkWhitelist)
	ON_BN_CLICKED(IDC_BUTTON_NEW, OnButtonNew)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigWhitelistDlg message handlers

BOOL CConfigWhitelistDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// Set Header of Listbox
	m_whiteListCtrl.InsertColumn(0,"Name",LVCFMT_LEFT,200, 0);
	m_whiteListCtrl.InsertColumn(1,"Address", LVCFMT_LEFT,200, 1);

	// select full rows
	m_whiteListCtrl.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	// fill Listbox
	for(int i=myApp->m_config.m_whitelist.GetSize()-1; i>=0; i--)
	{
		addListEntry(myApp->m_config.m_whitelist[i]);

	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConfigWhitelistDlg::OnDblclkWhitelist(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int item;
	CConfigWhitelistEntryDlg dlg;

	UpdateData();
	
	item=m_whiteListCtrl.GetSelectionMark();
	if(item>=0)
	{
		dlg.m_entry=getListEntry(item);
		
		if(dlg.DoModal()==IDOK)
		{
			setListEntry(item,dlg.m_entry);
		}
	}
	
	*pResult = 0;
}

void CConfigWhitelistDlg::OnButtonNew() 
{
	CConfigWhitelistEntryDlg dlg;

	UpdateData();
	
	if(dlg.DoModal()==IDOK)
	{
		addListEntry(dlg.m_entry);
	}
}

void CConfigWhitelistDlg::OnButtonDelete() 
{
	int item;
	CString tmp;
	CWhitelistEntry entry;

	UpdateData();
	
	item=m_whiteListCtrl.GetSelectionMark();
	if(item>=0)
	{
		entry=getListEntry(item);
		
		tmp.Format(IDS_REALLYDELETEWHITELISTENTRY,entry.m_name);
		if(MessageBox(tmp,NULL,MB_ICONQUESTION|MB_YESNO)==IDYES)
		{
			m_whiteListCtrl.DeleteItem(item);
		}
		m_whiteListCtrl.RedrawItems(0,m_whiteListCtrl.GetItemCount()-1);
		UpdateWindow();
	}
}

void CConfigWhitelistDlg::OnOK() 
{
	CWhitelistEntry newEntry;

	// flush list
	myApp->m_config.m_whitelist.RemoveAll();

	// fill list with items
	for(int i=0; i<m_whiteListCtrl.GetItemCount(); i++)
	{
		newEntry=getListEntry(i);
		myApp->m_config.m_whitelist.Add(newEntry);
	}

	/*
	 * Save Config
	 */
	myApp->m_config.SaveConfig();
	
	
	CDialog::OnOK();
}

int CConfigWhitelistDlg::addListEntry(const CWhitelistEntry &entry)
{
	int     item;
	CString itemText;
	CString tempStr;

	item=m_whiteListCtrl.InsertItem(LVIF_TEXT | LVIF_PARAM, 0, entry.m_name, 0, 0, 0, (LPARAM )0);
	m_whiteListCtrl.SetItemText(item,0,entry.m_name);
	m_whiteListCtrl.SetItemText(item,1,entry.m_address);

	return item;
}

CWhitelistEntry CConfigWhitelistDlg::getListEntry(int item)
{
	CWhitelistEntry retVal;

	retVal.m_name=m_whiteListCtrl.GetItemText(item,0);
	retVal.m_address=m_whiteListCtrl.GetItemText(item,1);

	return retVal;
}

void CConfigWhitelistDlg::setListEntry(int item,const CWhitelistEntry &entry)
{
	m_whiteListCtrl.SetItemText(item,0,entry.m_name);
	m_whiteListCtrl.SetItemText(item,1,entry.m_address);
}
