// Debugger.h: interface for the CDebugger class.
//
//////////////////////////////////////////////////////////////////////

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_DEBUGGER_H__DD6D8972_143A_11D3_BEDA_00609740E6FE__INCLUDED_)
#define AFX_DEBUGGER_H__DD6D8972_143A_11D3_BEDA_00609740E6FE__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CDebugger  
{
public:
	void Reset();
	BOOL GetState();
	void Add(const CString& file, const int line, const CString& message);
	void SetState(BOOL state);
	CDebugger(const CString& filename);
	virtual ~CDebugger();

protected:
	CString m_logFile;
	BOOL m_state;
};

#endif // !defined(AFX_DEBUGGER_H__DD6D8972_143A_11D3_BEDA_00609740E6FE__INCLUDED_)
