// IPAddress.cpp: implementation of the CIPAddress class.
//
//////////////////////////////////////////////////////////////////////

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "IPAddress.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CIPAddress::CIPAddress()
{

}

CIPAddress::CIPAddress(const CString& ipStr)
{
	splitIp(ipStr,m_ip1,m_ip2,m_ip3,m_ip4);
}

CIPAddress::~CIPAddress()
{

}

void CIPAddress::splitIp(const CString &ip, BYTE &ip1, BYTE &ip2, BYTE &ip3, BYTE &ip4) const
{
	CString temp;
	int pos1=0;
	int pos2=0;

	pos1=ip.Find(".",0);
	temp=ip.Left(pos1);
	ip1=atoi(temp);

	pos1++;
	pos2=ip.Find(".",pos1);
	temp=ip.Mid(pos1,pos2-pos1);
	ip2=atoi(temp);
	pos1=pos2+1;

	pos2=ip.Find(".",pos1);
	temp=ip.Mid(pos1,pos2-pos1);
	ip3=atoi(temp);
	pos1=pos2+1;

	temp=ip.Right(ip.GetLength()-pos1);
	ip4=atoi(temp);
}

void CIPAddress::joinIp(BYTE ip1, BYTE ip2, BYTE ip3, BYTE ip4, CString& ip) const
{
	ip.Format("%i.%i.%i.%i",ip1,ip2,ip3,ip4);
}

CString CIPAddress::toString() const
{
	CString str;
	joinIp(m_ip1,m_ip2,m_ip3,m_ip4,str);
	return str;
}

CString CIPAddress::reverseIPString() const
{
	CString str;
	joinIp(m_ip4,m_ip3,m_ip2,m_ip1,str);
	return str;
}

BOOL CIPAddress::operator==(const CIPAddress& ip)
{
	if((ip.m_ip1==m_ip1) && (ip.m_ip2==m_ip2) && (ip.m_ip3==m_ip3) && (ip.m_ip4==m_ip4))
		return TRUE;
	return FALSE;
}