// NASExtHelper.cpp : Defines the initialization routines for the DLL.
//

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NASExtHelper.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/*
 * Global Data
 */
HEMREGISTRATION hEmHandlerCb = 0;
WORD            gRecursionID;
BOOL            initialized=FALSE;

//
//	Note!
//
//		If this DLL is dynamically linked against the MFC
//		DLLs, any functions exported from this DLL which
//		call into MFC must have the AFX_MANAGE_STATE macro
//		added at the very beginning of the function.
//
//		For example:
//
//		extern "C" BOOL PASCAL EXPORT ExportedFunction()
//		{
//			AFX_MANAGE_STATE(AfxGetStaticModuleState());
//			// normal function body here
//		}
//
//		It is very important that this macro appear in each
//		function, prior to any calls into MFC.  This means that
//		it must appear as the first statement within the 
//		function, even before any object variable declarations
//		as their constructors may generate calls into the MFC
//		DLL.
//
//		Please see MFC Technical Notes 33 and 58 for additional
//		details.
//

/////////////////////////////////////////////////////////////////////////////
// CNASExtHelperApp

BEGIN_MESSAGE_MAP(CNASExtHelperApp, CWinApp)
	//{{AFX_MSG_MAP(CNASExtHelperApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNASExtHelperApp construction

CNASExtHelperApp::CNASExtHelperApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CNASExtHelperApp object

CNASExtHelperApp theApp;

/*
 *  Architecture
 *  ------------
 *
 *  An Extension Manager DLL contains the following major components:
 *
 *    1)  DLL startup and shutdown (in platform DLL file, e.g., extwin.c):
 *        Under Win32: the -DllEntryPoint function, here DllMain
 *        Under Win16: LibMain & WEP
 *
 *    2)  Notes entry point at ordinal 1:  MainEntryPoint
 *
 *    3)  Extension manager callback:  ExtHandler
 */

/* Extension manager entry point */
NASEXTHELPER_API STATUS LNPUBLIC MainEntryPoint (void)
{
	STATUS  status=NOERROR;
	char    msgBuf [256];

	if(!initialized)
	{
		initialized=TRUE;
		
		status = EMCreateRecursionID( &gRecursionID );
		
		if (status)
			MessageBox(NULL,"EMCreateRecursionID Failed","NASExtHelper.dll",MB_ICONERROR|MB_OK);
		else
		{
			status = EMRegister(EM_NIFUPDATECOLLECTION, EM_REG_BEFORE, EmHandler, gRecursionID, &hEmHandlerCb);
			if (NOERROR != status)
			{
				wsprintf (msgBuf, "Could not register extension handler for EM_NIFUPDATECOLLECTION - status: 0x%lX",status);
				MessageBox(NULL,msgBuf,"NASExtHelper.dll",MB_ICONERROR|MB_OK);
				return (status);
			}

			status = EMRegister(EM_NSFNOTECREATE, EM_REG_BEFORE, EmHandler, gRecursionID, &hEmHandlerCb);
			if (NOERROR != status)
			{
				wsprintf (msgBuf, "Could not register extension handler for EM_NSFNOTECREATE - status: 0x%lX",status);
				MessageBox(NULL,msgBuf,"NASExtHelper.dll",MB_ICONERROR|MB_OK);
				return (status);
			}

			status = EMRegister(EM_NSFDBFILTER, EM_REG_BEFORE, EmHandler, gRecursionID, &hEmHandlerCb);
			if (NOERROR != status)
			{
				wsprintf (msgBuf, "Could not register extension handler for EM_NSFDBGETMODIFIEDNOTETABLE - status: 0x%lX",status);
				MessageBox(NULL,msgBuf,"NASExtHelper.dll",MB_ICONERROR|MB_OK);
				return (status);
			}
			
			
			MessageBox(NULL,"Initialized!","NASExtHelper.dll",MB_OK);
		}
	}
	
	return (status);
}

/* Deregister extensions */
NASEXTHELPER_API STATUS LNPUBLIC ExtClear (void)
{
	STATUS  status;

	if (0 != hEmHandlerCb)
		status = EMDeregister (hEmHandlerCb);
	else
		status = NOERROR;

	return (status);
}



/*
 * UpdateMailbox callback handler
 */
STATUS LNCALLBACK EmHandler (EMRECORD far *pRecord)
{
	/* for MFC */
	AFX_MANAGE_STATE(AfxGetStaticModuleState());
	CString tmpStr;

	/* Notes Arguments */
	VARARG_PTR  pArgs;

    /* Function arguments */
	NOTEHANDLE noteHandle;
	WORD       updateFlags;

	MessageBox(NULL,"EMHandler called","NASExtPwd.dll",MB_ICONERROR|MB_OK);

	switch(pRecord->EId)
	{
	case EM_NIFUPDATECOLLECTION:
		MessageBox(NULL,"Collection updated","NASExtPwd.dll",MB_ICONERROR|MB_OK);
	break;
	case EM_NSFNOTECREATE:
		MessageBox(NULL,"Note created","NASExtPwd.dll",MB_ICONERROR|MB_OK);
	break;
	case EM_NSFDBFILTER:
		MessageBox(NULL,"DB filter","NASExtPwd.dll",MB_ICONERROR|MB_OK);
	break;

//	case EM_NSFNOTEUPDATE:
//	    /* Fetch the arguments */
//	    pArgs   = pRecord->Ap;
//	//	noteHandle  = VARARG_GET (pArgs, NOTEHANDLE);
//	//	updateFlags = VARARG_GET (pArgs, WORD);
//		MessageBox(NULL,"Note updated","NASExtPwd.dll",MB_ICONERROR|MB_OK);
//	break;
	default:
		tmpStr.Format("Unregistered Handler %i",pRecord->EId);
		MessageBox(NULL,tmpStr,"NASExtPwd.dll",MB_ICONERROR|MB_OK);
	}

	return (ERR_EM_CONTINUE);
}
