// NotesAntiSpam.cpp : Defines the class behaviors for the application.
//

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include <afxpriv.h>
#include "NotesAntiSpam.h"
#include "NotesAntiSpamDlg.h"
#include "Debugger.h"
#include "SearchThread.h"
#include "FileVersionInfo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Handle for searchTimer
static UINT uIdSearchTimer=0;

/*
 * Our Debugger
 */
CDebugger CNotesAntiSpamApp::debugger=CDebugger("NotesAntiSpam.LOG");

/////////////////////////////////////////////////////////////////////////////
// CNotesAntiSpamApp

BEGIN_MESSAGE_MAP(CNotesAntiSpamApp, CWinApp)
	//{{AFX_MSG_MAP(CNotesAntiSpamApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNotesAntiSpamApp construction

CNotesAntiSpamApp::CNotesAntiSpamApp()
{
	m_pSearchWorkerThread=NULL;
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CNotesAntiSpamApp object

CNotesAntiSpamApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CNotesAntiSpamApp initialization

BOOL CNotesAntiSpamApp::InitInstance()
{
	UINT uIdTimer ;

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

//#ifdef _AFXDLL
//	Enable3dControls();			// Call this when using MFC in a shared DLL
//#else
//	Enable3dControlsStatic();	// Call this when linking to MFC statically
//#endif

	/* Test if we are already running, if so stop */
#ifdef WIN32
	CreateMutex (NULL, FALSE, "NOTESANTISPAM") ;
	if (GetLastError () == ERROR_ALREADY_EXISTS) return FALSE;
#endif

	// activate and reset Debugger
	debugger.SetState(m_config.m_debug);
	if(m_config.m_debug)
		debugger.Reset();
	/*
	 * Dump Version and additional information
	 */
	if(debugger.GetState())
	{
		CFileVersionInfo  fvi;
		CString versionStr;
		// Retrieve version information for this module
		if (fvi.Create())
		{
			// Print version information
			versionStr=_T("Product: ")+fvi.GetProductName();
			debugger.Add(__FILE__,__LINE__, versionStr);
			versionStr=_T("File Version Label: ")+fvi.GetFileVersion();
			debugger.Add(__FILE__,__LINE__, versionStr);
		}
	}


	CNotesAntiSpamDlg dlg;
	m_pMainWnd = &dlg;

	dlg.Create(IDD_NOTESANTISPAM_DIALOG);

	/*
	 * Create SearchThread
	 */
	debugger.Add(__FILE__,__LINE__,"Creating SearchThread ...");
	
	m_hEventStartSearch = CreateEvent(NULL, FALSE, FALSE, NULL); // auto reset, initially reset
	m_hEventStartTrainDSpam = CreateEvent(NULL, FALSE, FALSE, NULL); // auto reset, initially reset
	m_hEventStartPurgeDSpam = CreateEvent(NULL, FALSE, FALSE, NULL); // auto reset, initially reset
	m_hEventSearchDone = CreateEvent(NULL, TRUE, TRUE, NULL);    // manual reset, initially set
	m_hEventKillSearchThread = CreateEvent(NULL, FALSE, FALSE, NULL);   // auto reset, initially reset
	m_hEventSearchThreadKilled = CreateEvent(NULL, FALSE, FALSE, NULL); // auto reset, initially reset

	m_searchThreadInfo.m_hEventStartSearch = m_hEventStartSearch;
	m_searchThreadInfo.m_hEventStartTrainDSpam = m_hEventStartTrainDSpam;
	m_searchThreadInfo.m_hEventStartPurgeDSpam = m_hEventStartPurgeDSpam;
	m_searchThreadInfo.m_hEventSearchDone = m_hEventSearchDone;
	m_searchThreadInfo.m_hEventKillSearchThread = m_hEventKillSearchThread;
	m_searchThreadInfo.m_hEventSearchThreadKilled = m_hEventSearchThreadKilled;
	m_searchThreadInfo.m_hwndNotifySearch = AfxGetMainWnd()->m_hWnd;
	m_searchThreadInfo.m_hwndNotifyProgress = AfxGetMainWnd()->m_hWnd;

	if (m_pSearchWorkerThread == NULL)
	{
		// Begin the worker thread.  It is ok to fill in the CThreadInfo
		// structure after the thread has started, because the thread
		// waits for the "start recalc" event before referring to the structure.
		m_pSearchWorkerThread =	AfxBeginThread(SearchThreadProc, &m_searchThreadInfo);
	}

	// Start first search
	debugger.Add(__FILE__,__LINE__,"Start first search ...");
	SetEvent(m_hEventSearchDone);
	ResetEvent(m_hEventKillSearchThread);
	ResetEvent(m_hEventSearchThreadKilled);
	ResetEvent(m_hEventStartTrainDSpam);
	ResetEvent(m_hEventStartPurgeDSpam);
	SetEvent(m_hEventStartSearch);

	/****
	 * Create a timer for Mail-Search every Minute.
	 ****/
	debugger.Add(__FILE__,__LINE__,"Starting search-timer ...");
	uIdTimer = SetTimer (NULL, 0, (UINT)m_config.m_schedule, (TIMERPROC)TimerSearchProc) ;
	if (uIdTimer == 0)
	{	
		AfxMessageBox(IDS_ERROR_TIMER_SEARCH,MB_OK|MB_ICONSTOP);
		return FALSE;
	}
	else
	{
		uIdSearchTimer=uIdTimer;
		Run();
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

/* Called when Application closes */
int CNotesAntiSpamApp::ExitInstance() 
{
	debugger.Add(__FILE__,__LINE__,"Exiting Application...");
	if(uIdSearchTimer!=0)
	{
		debugger.Add(__FILE__,__LINE__,"Killing searchTimer...");
		if(KillTimer(NULL,uIdSearchTimer)==0)
			debugger.Add(__FILE__,__LINE__,"...error killing Timer.");
		uIdSearchTimer=0;
	}

	DWORD dwExitCode;
	if (m_pSearchWorkerThread != NULL &&
		GetExitCodeThread(m_pSearchWorkerThread->m_hThread, &dwExitCode) &&
		dwExitCode == STILL_ACTIVE)
	{
		// Kill the worker thread by setting the "kill thread" event.
		// See comment in OnKillWorkerThread for explanation of the sequence
		// of the "kill thread" and "start recalc" events.
		SetEvent(m_hEventKillSearchThread);
		SetEvent(m_hEventStartSearch);
		WaitForSingleObject(m_hEventSearchThreadKilled, INFINITE);
	}

	debugger.Add(__FILE__,__LINE__,"\n***************************************************************************");

	return CWinApp::ExitInstance();
}

void CALLBACK CNotesAntiSpamApp::TimerSearchProc(HWND hWnd, UINT uMsg, UINT uIdTimer, DWORD dwTime)
{
	CNotesAntiSpamApp* myApp=(CNotesAntiSpamApp*)AfxGetApp();

	myApp->debugger.Add(__FILE__,__LINE__,"New Search on Timer...");
	// The events are initially set or reset in the CreateEvent call;
	// but they may be left in an improperly initialized state if
	// a worker thread has been previously started and then prematurely
	// killed.  Set/reset the events to the proper initial state.
	// Set the "start recalc" event last, since it is the event the
	// triggers the starting of the worker thread recalculation.
	SetEvent(myApp->m_hEventSearchDone);
	ResetEvent(myApp->m_hEventKillSearchThread);
	ResetEvent(myApp->m_hEventSearchThreadKilled);
	SetEvent(myApp->m_hEventStartSearch);
}
