// NotesAntiSpam.h : main header file for the NOTESANTISPAM application
//

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_NOTESANTISPAM_H__8BC6D03A_517C_4BAC_B75F_71CB56692370__INCLUDED_)
#define AFX_NOTESANTISPAM_H__8BC6D03A_517C_4BAC_B75F_71CB56692370__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"		// main symbols
#include "Debugger.h"	    // Added by ClassView
#include "SearchThread.h"
#include "Config.h"	// Added by ClassView

#define MYWM_ENDNOTESANTISPAM		(WM_APP+200)
#define MYWM_UPDATEDISPLAY     		(WM_APP+201)
#define MYWM_SEARCHSPAMSTART   		(WM_APP+202)
#define MYWM_SEARCHSPAMSTOP    		(WM_APP+203)
#define MYWM_INFORMNEWMAIL     		(WM_APP+204)

/////////////////////////////////////////////////////////////////////////////
// CNotesAntiSpamApp:
// See NotesAntiSpam.cpp for the implementation of this class
//

class CNotesAntiSpamApp : public CWinApp
{
public:
	CConfig m_config;
	static CDebugger debugger;
	HANDLE m_hEventStartSearch;
	HANDLE m_hEventStartTrainDSpam;
	HANDLE m_hEventStartPurgeDSpam;
	HANDLE m_hEventSearchDone;
	HANDLE m_hEventKillSearchThread;
	HANDLE m_hEventSearchThreadKilled;

	CNotesAntiSpamApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CNotesAntiSpamApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(CNotesAntiSpamApp)
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()


protected:
	static void CALLBACK TimerSearchProc (HWND hWnd, UINT uMsg, UINT uIdTimer, DWORD dwTime);

	CWinThread* m_pSearchWorkerThread;
	CSearchThreadInfo m_searchThreadInfo;
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_NOTESANTISPAM_H__8BC6D03A_517C_4BAC_B75F_71CB56692370__INCLUDED_)
