// NotesAntiSpamDlg.h : header file
//

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_NOTESANTISPAMDLG_H__DE14585E_F0CE_4928_8F1D_BD52952E796F__INCLUDED_)
#define AFX_NOTESANTISPAMDLG_H__DE14585E_F0CE_4928_8F1D_BD52952E796F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CNotesAntiSpamDlg dialog
#include "SystemTray.h"
#define WM_ICON_NOTIFY  WM_APP+100

class CNotesAntiSpamDlg : public CDialog
{
// Construction
public:
	static void AddLog(const CString& logMsg);
	CNotesAntiSpamDlg(CWnd* pParent = NULL);	// standard constructor
	
	CSystemTray m_TrayIcon;

// Dialog Data
	//{{AFX_DATA(CNotesAntiSpamDlg)
	enum { IDD = IDD_NOTESANTISPAM_DIALOG };
	CButton	m_searchButton;
	CButton	m_trainButton;
	CString	m_log;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CNotesAntiSpamDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL
	afx_msg LRESULT OnNotifyIcon(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnEndNotesAntiSpam(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnUpdateDisplay(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnInformNewMail(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSearchSpamStart(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSearchSpamStop(WPARAM wParam, LPARAM lParam);

// Implementation
protected:
	HICON m_hIcon;
	static CString	m_logTmp;
	bool m_informNewMailActive;

	// Generated message map functions
	//{{AFX_MSG(CNotesAntiSpamDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnDestroy();
	afx_msg int OnCreate(LPCREATESTRUCT createStruct);
	afx_msg void OnHelpAboutNotesAntiSpam();
	afx_msg void OnFileDSpamStatistic();
	afx_msg void OnConfigurationGeneral();
	afx_msg void OnConfigurationDnsBlacklists();
	afx_msg void OnConfigurationWhitelist();
	afx_msg void OnConfigurationDSpam();
	afx_msg void OnButtonSearch();
	afx_msg void OnButtonTrainDSpam();
	afx_msg void OnFileDspamPurge();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnRestore();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_NOTESANTISPAMDLG_H__DE14585E_F0CE_4928_8F1D_BD52952E796F__INCLUDED_)
