// NotesMail.cpp: implementation of the CNotesMail class.
//
//////////////////////////////////////////////////////////////////////
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "NotesMail.h"
#include ".\notesmail.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CNotesMail::CNotesMail()
:LNMailMessage()
{
}

CNotesMail::~CNotesMail()
{
	LNMailMessage::~LNMailMessage();
}

int CNotesMail::GetReceivedLines(LNText *received)
{
	BOOL        close=false;
	LNText      textItem;
	LNString    tmpLNStr;
	LNItemArray itemArray;

	received->DeleteAll();

	if(!IsOpen())
	{
		Open();
		close=true;
	}

	GetItems(&itemArray);
	
	for(unsigned int j=0; j<itemArray.GetCount(); j++)
	{
		if(itemArray[j].IsType(LNITEMTYPE_TEXT))
		{
			textItem=itemArray[j];
			if(textItem.GetName()=="Received")
			{
				for(unsigned int i=0; i<textItem.GetCount(); i++)
				{
					tmpLNStr=textItem[i];
					received->Append(tmpLNStr);
				}
			}
		}
	}
	
	if(close)
		Close();

	return received->GetCount();
}

CString CNotesMail::dump(BOOL dosFmt)
{
	LNString	Data;
	LNText		TextData;
	LNINT		Count;
	LNINT		Index;
	LNRichText  body;
	CString     tmp;
	BOOL        close=false;
	BOOL        throwAllErrs=false;
	CString     retVal;

	if(!IsOpen())
	{
		Open();
		close=true;
	}

	// Read and print NoteID
	if(dosFmt)
		tmp.Format("NoteID : %i\r\n",GetNoteID());
	else
		tmp.Format("NoteID : %i\n",GetNoteID());
	retVal+=tmp;

	// Read and print the message header information.
	GetReceivedLines (&TextData);
	Count = TextData.GetCount ();
	for (Index = 0; Index < Count; Index++)
	{
		Data = (LNString) TextData[Index];
		if(dosFmt)
			tmp.Format("Received: %s\r\n",((const char *) Data));
		else
			tmp.Format("Received: %s\n",((const char *) Data));
		retVal+=tmp;
	}
	
	GetSender (&Data);
	if(dosFmt)
		tmp.Format("From:    %s\r\n",((const char *) Data));
	else
		tmp.Format("From:    %s\n",((const char *) Data));
	retVal+=tmp;

	GetRecipients (&TextData);
	Count = TextData.GetCount ();
	tmp="To:      ";
	for (Index = 0; Index < Count; Index++)
	{
		Data = (LNString) TextData[Index];
		if (Index > 0)
			tmp+=", ";
		tmp+=((const char *) Data);
	}
	if(dosFmt)
		retVal+=tmp+"\r\n";
	else
		retVal+=tmp+"\n";
		

	GetCC (&TextData);
	Count = TextData.GetCount ();
	tmp="cc:      ";
	for (Index = 0; Index < Count; Index++)
	{
		Data = (LNString) TextData[Index];
		if (Index > 0)
			tmp+=", ";
		tmp+=((const char *) Data);
	}
	if(dosFmt)
		retVal+=tmp+"\r\n";
	else
		retVal+=tmp+"\n";

	if(dosFmt)
		tmp.Format("Subject: %s\r\n\r\n",GetSubjectString());
	else
		tmp.Format("Subject: %s\n\n",GetSubjectString());
	retVal+=tmp;

	//Body
	// switch off exception-handling
	if(LNGetThrowAllErrors())
	{
		LNSetThrowAllErrors(FALSE);
		throwAllErrs=true;
	}
	else
	{
		throwAllErrs=false;
	}

	GetBody(&body);
	body.GetText(&Data);
	tmp=((const char *) Data);
	if(!dosFmt)
		tmp.Replace("\r\n","\n");
	if(dosFmt)
		retVal+=tmp+"\r\n";
	else
		retVal+=tmp+"\n";

	// switch exception-handling to old state
	LNSetThrowAllErrors(throwAllErrs);

	if(close)
		Close ();

	// UPDATE_OHMI 
	int nType = 0;

	// retValɋ؂蕶}
	// ؂́AAЂ炪ȁAJ^JiAp؂ւƂ
	int n=0;
	while (n<retVal.GetLength()) {
		int nPos = n;
		int nNewType = nType;
		TCHAR c1 = retVal.GetAt(n++);
		if (_istlead(c1)) {
			TCHAR c2 = retVal.GetAt(n++);
            unsigned int nMBC = MAKEWORD(c2, c1);
            if(_ismbckata(nMBC)) nNewType = 11;		// J^Ji
			else if(_ismbchira(nMBC)) nNewType = 12;// Ђ炪
			else if(nMBC == 0x815b)	nNewType = nNewType;	// [
			else if(!_ismbcl0(nMBC)) nNewType = 13;	// 
			else nNewType = 20;						// ̑

		} else {
			nNewType = 0;
		}
		if (nType != nNewType) {
			retVal.Insert(nPos, TCHAR(' '));
			nType = nNewType;
			n++;
		}
	}
	// UPDATE_OHMI

	return retVal;
}

CString CNotesMail::GetSubjectString()
{
	LNString	Data;
	LNText		TextData;
	LNINT		Count;
	LNINT		Index;
	CString     retVal;

	GetSubject (&TextData);
	Count = TextData.GetCount ();
	for (Index = 0; Index < Count; Index++)
	{
		Data = (LNString) TextData[Index];
		if (Index > 0)
			retVal+=", ";
		retVal+=((const char *) Data);
	}

	return retVal;
}

void CNotesMail::SetSubjectString(const CString& str)
{
	LNString	lnStr;

	lnStr=str;
	SetSubject(lnStr);

	return;
}

CString CNotesMail::GetMessageID()
{
	CString retVal;
	LNText item;
	LNString    tmpLNStr;

	GetItem("$MessageID",&item);
	tmpLNStr=item[0];
	retVal=tmpLNStr;

	return retVal;
}

CString CNotesMail::GetDSpamSignature(void)
{
	CString  retVal="";
	LNText   item;
	LNString tmpLNStr;

	if(HasItem("X_DSpamSignature"))
	{
		if(GetItem("X_DSpamSignature",&item)==LNNOERROR)
		{
			tmpLNStr=item[0];
			retVal=tmpLNStr;
		}
	}

	return retVal;
}

bool CNotesMail::SetDSpamSignature(const CString& signature)
{
	LNText   newItem;
	LNString newLNStr;

	newLNStr=signature;
	newItem.Append(newLNStr);
	
	if(CreateItem("X_DSpamSignature", newItem, LNITEMFLAGS_AUTO_SUMMARY, LNITEMOPTION_DELETE_APPEND)==LNNOERROR)
		return true;

	return false;
}

bool CNotesMail::GetDSpamIsSpam(void)
{
	bool  retVal=false;
	LNText   item;
	LNString tmpLNStr;
	CString  tmpStr;

	if(HasItem("X_DSpamIsSpam"))
	{
		if(GetItem("X_DSpamIsSpam",&item)==LNNOERROR)
		{
			tmpLNStr=item[0];
			tmpStr=tmpLNStr;
			if(tmpStr=="true")
				retVal=true;
			else
				retVal=false;
		}
	}

	return retVal;
}

bool CNotesMail::SetDSpamIsSpam(bool spam)
{
	LNText   newItem;
	LNString newLNStr;

	if(spam)
		newLNStr="true";
	else
		newLNStr="false";

	newItem.Append(newLNStr);
	
	if(CreateItem("X_DSpamIsSpam", newItem, LNITEMFLAGS_AUTO_SUMMARY, LNITEMOPTION_DELETE_APPEND)==LNNOERROR)
		return true;

	return false;
}

bool CNotesMail::GetDSpamIsLearned(void)
{
	bool  retVal=false;
	LNText   item;
	LNString tmpLNStr;
	CString  tmpStr;

	if(HasItem("X_DSpamIsLearned"))
	{
		if(GetItem("X_DSpamIsLearned",&item)==LNNOERROR)
		{
			tmpLNStr=item[0];
			tmpStr=tmpLNStr;
			if(tmpStr=="true")
				retVal=true;
			else
				retVal=false;
		}
	}

	return retVal;
}

bool CNotesMail::SetDSpamIsLearned(bool learned)
{
	LNText   newItem;
	LNString newLNStr;

	if(learned)
		newLNStr="true";
	else
		newLNStr="false";

	newItem.Append(newLNStr);
	
	if(CreateItem("X_DSpamIsLearned", newItem, LNITEMFLAGS_AUTO_SUMMARY, LNITEMOPTION_DELETE_APPEND)==LNNOERROR)
		return true;

	return false;
}
